#! /bin/sh
#
#  Creation du fichier sta_settings.conf s'il n'existe pas
#
STA_SETTINGS="/media/private/sta_settings.conf"
if [ ! -e "$STA_SETTINGS" ]
then
    echo "ctrl_interface=/var/run/wpa_supplicant" >$STA_SETTINGS
    echo "update_config=1" >>$STA_SETTINGS
    echo "uuid=12345678-9abc-def0-1234-56789abcdef0" >>$STA_SETTINGS
    echo "device_name=RS9113_n-Link" >>$STA_SETTINGS
    echo "manufacturer=Redpine Signals INC" >>$STA_SETTINGS
    echo "model_name=OneBox-Mobile" >>$STA_SETTINGS
    echo "model_number=9113" >>$STA_SETTINGS
    echo "serial_number=02" >>$STA_SETTINGS
    echo "device_type=1-0050F204-1" >>$STA_SETTINGS
    echo "os_version=01020300" >>$STA_SETTINGS
    echo "config_methods=display push_button keypad" >>$STA_SETTINGS
    echo "ap_scan=1" >>$STA_SETTINGS
fi

#### Redpine module driver configuration
MODE=3

# Driver Mode 1 (END-TO-END)
DRIVER_MODE=1

COEX_MODE=$MODE

# Enable TA-level SDIO aggregation set 1 else set 0 to disable it.
TA_AGGR=4

# Disable Firmware load set 1 to skip FW loading through Driver
SKIP_FW_LOAD=0

# Recommended to use the default mode 1 (Full Flash mode with Secondary Boot Loader)
FW_LOAD_MODE=1

# Default is Packet handshake mode 2 (Packet hand shake)
HANDSHAKE_MODE=2

# SDIO Clock speed
SDIO_CLOCK_SPEED=50000

# Antenna diversity enable
RSI_ANTENNA_DIVERSITY=0

# Antenna Selection (2 internal / 3 external)
ANT_SEL_VAL=2

# RF_POWER_MODE Selection (0x00 For Both TX and RX High Power)
WLAN_RF_PWR_MODE=0x00
BT_RF_PWR_MODE=0x00
ZIGB_RF_PWR_MODE=0x00

# ONBOARD ANT SELECTION (1 Module onboard / 0 external)
ONBOARD_ANT_SEL=1

# RETRY_COUNT value (valid range is 7 to 15)
SET_RETRY_COUNT=15

# COUNTRY Selection
#  0 World Domain
#  840 US Domain Maps to US Region
#  276 Germany Maps to EU Region
#  392 Japan Maps to Japan Region
SET_COUNTRY_CODE=0


PARAMS=" driver_mode=$DRIVER_MODE"
PARAMS=$PARAMS" firmware_path=$PWD/firmware/"
PARAMS=$PARAMS" onebox_zone_enabled=0x1"
PARAMS=$PARAMS" ta_aggr=$TA_AGGR"
PARAMS=$PARAMS" skip_fw_load=$SKIP_FW_LOAD"
PARAMS=$PARAMS" fw_load_mode=$FW_LOAD_MODE"
PARAMS=$PARAMS" sdio_clock=$SDIO_CLOCK_SPEED"
PARAMS=$PARAMS" enable_antenna_diversity=$RSI_ANTENNA_DIVERSITY"
PARAMS=$PARAMS" coex_mode=$COEX_MODE"
#PARAMS=$PARAMS" ps_handshake_mode=$HANDSHAKE_MODE"
PARAMS=$PARAMS" obm_ant_sel_val=$ANT_SEL_VAL"
PARAMS=$PARAMS" user_onboard_ant_val=$ONBOARD_ANT_SEL"
PARAMS=$PARAMS" wlan_rf_power_mode=$WLAN_RF_PWR_MODE"
PARAMS=$PARAMS" bt_rf_power_mode=$BT_RF_PWR_MODE"
PARAMS=$PARAMS" zigb_rf_power_mode=$ZIGB_RF_PWR_MODE"
PARAMS=$PARAMS" country_code=$SET_COUNTRY_CODE"
PARAMS=$PARAMS" retry_count=$SET_RETRY_COUNT"

#
# Chargement des modules REDPINE et wpa_supplicant
#
cat /dev/null > /var/log/messages
insmod onebox_common_gpl.ko

insmod wlan.ko
insmod wlan_wep.ko
insmod wlan_tkip.ko
insmod wlan_ccmp.ko
insmod wlan_aes_cmac.ko
insmod wlan_acl.ko
insmod wlan_xauth.ko
insmod wlan_scan_sta.ko
insmod onebox_wlan_nongpl.ko
insmod onebox_wlan_gpl.ko

insmod onebox_nongpl.ko $PARAMS
insmod onebox_gpl.ko

#### Enabling Redpine driver protocols (1-> wifi / 2-> BT / 3 -> wifi + BT)

./onebox_util rpine0 enable_protocol 1

#
# Parametrage du mode economie d'energie
#
./onebox_util rpine0 set_ps_params 1 2 0 0 0 0 0 100 100 0 0 1
#
# Demarrage de wpa_supplicant
#
sh wlan_enable.sh
./onebox_util rpine0 create_vap wifi0 sta sw_bmiss
./wpa_supplicant -i wifi0 -D bsd -c $STA_SETTINGS -ddddt > /var/log/redpine &
