#!/bin/sh

# set the mountpoint name according to partition or device name, to obtain "sdcard_p1"
partition_name=${DEVNAME}
i=$((${#partition_name}-2))
j=${partition_name:$i:2}

mount_point="sdcard_"$j

# USB mass storage becomes /dev/mmcblk2p5 if SDCARD extracted
USB_MASS_STORAGE_LUN=/sys/devices/soc0/soc.1/2100000.aips-bus/2184000.usb/ci_hdrc.0/gadget/lun0/file
FILESIZE=$(stat -c%s "$USB_MASS_STORAGE_LUN")
if [ $FILESIZE -gt 1 ]; then
    echo /dev/mmcblk2p5 > $USB_MASS_STORAGE_LUN
fi

# remove the mountpoint directory from /media/user/ (if not empty)
if [ -n $mount_point ]; then

    umount -lv /media/user/$mount_point
    rm -R /media/user/$mount_point
fi
