#!/bin/sh

# set the mountpoint name according to partition or device name, to obtain "sdcard_p1"
partition_name=${DEVNAME}
i=$((${#partition_name}-2))
j=${partition_name:$i:2}

mount_point="sdcard_"$j

# if a plugdev group exist, retrieve it's gid set & it as owner of mountpoint
plugdev_gid="$(grep plugdev /etc/group|cut -f3 -d:)"
if [ -z $plugdev_gid ]; then
    gid=''
else
    chown root:plugdev $mount_point
    gid=",gid=$plugdev_gid"
fi

# create the mountpoint directory in /media/user/ (if not empty)
if [ -n $mount_point ]; then
    mkdir -p /media/user/$mount_point
    # other options (breaks POSIX): noatime,nodiratime,nosuid,nodev
    mount -t $ID_FS_TYPE \
      -o rw,user,sync \
      $DEVNAME /media/user/$mount_point

    # USB mass storage
    USB_MASS_STORAGE_LUN=/sys/devices/soc0/soc.1/2100000.aips-bus/2184000.usb/ci_hdrc.0/gadget/lun0/file
    FILESIZE=$(stat -c%s "$USB_MASS_STORAGE_LUN")
    if [ $FILESIZE -gt 1 ]; then
        echo $DEVNAME > $USB_MASS_STORAGE_LUN
    fi
fi
