#! /bin/sh
### BEGIN INIT INFO
# Provides:             scopixIV
# Required-Start:	udev       
# Required-Stop:        
# Default-Start:        5
# Default-Stop:         0 1 6
# Short-Description:    oscilloscope
### END INIT INFO

# Stop cursor blinking on screen
echo 0 >/sys/class/graphics/fbcon/cursor_blink

# Prevent screen standby
setterm -blank 0 >/dev/tty1
setterm -powerdown 0

# QT5 input handlers will be disabled tu use TLIB
export QT_QPA_EGLFS_DISABLE_INPUT=1

# Le pointeur de souris n'est pas affiche
export QT_QPA_EGLFS_HIDECURSOR=1

# Le script n'est pas suspendu en cas d'erreur
set +e

# Configuration du port serie sur USB
/bin/stty -F /dev/ttyGS0 -icrnl -echo -onlret -onlcr -echoe -echok -echoke -echoctl -icanon -ixon -iexten -isig -clocal

case "$1" in
  start)
        if [ -f /media/private/update/updateOk ] && [ -f /media/private/update/download/update.sh ]
        then
            echo "Updating..."
            rm -f /media/private/update/updateOk
            if [ -f /media/private/update/download/update-display ] 
            then
                chmod +x /media/private/update/download/update-display
                /media/private/update/download/update-display -platform eglfs &
            fi
            sh -x media/private/update/download/update.sh &

        else
            echo "Starting update manager..."
            /opt/update-manager &
            echo "Starting scopixIV..."
            /opt/manager &
        fi
	;;
  stop)
	echo -n "Stopping scopixIV "
	kill -9 `pidof manager` >/dev/null 2>&1
	kill -9 `pidof scopixIV` >/dev/null 2>&1
	kill -9 `pidof battery-display` >/dev/null 2>&1
	kill -9 `pidof Config` >/dev/null 2>&1
	kill -9 `pidof FileMan` >/dev/null 2>&1
	kill -9 `pidof battery-manager` >/dev/null 2>&1
	echo "done"
	;;
  restart)
  	$0 stop
	$0 start
	;;
  *)
	echo "Usage: scopixIV { start | stop | restart }" >&2
	exit 1
	;;
esac

exit 0
