# !/bin/sh
# SCOPIX IV - Installation d'une nouvelle version
#
# Author:  JF Bunaz (jeanfrancois.bunaz@chauvin-arnoux.com)
#
# Change-Log:
# Version: 1.00 - 19-05-2017
#   Vervion initiale
# Version: 1.01 - 29-06-2017
#   Destruction du fichier de calibration de la dalle tactile
# Version: 1.02 - 26-09-2017
#   Installation des documents NF et QSG dans la partition 7
# Version: 1.03 - 10-01-2018
#   Commentaires plus pertinents   
# Version: 1.04 - 04-06-2019
#   Destruction du setup courant pour eviter un crash au demarrage
#
# Le repertoire courant est le repertoire dans lequel se trouve ce script
#
cd "$( dirname "$0" )"
WORK_DIR=`pwd`
DOC_PARTITION="/dev/mmcblk2p7"

# Le 2eme parametre de la ligne d'arguments de LINUX specifie le rootfs
export `awk '{print $2}' /proc/cmdline`

# Le rootfs est installe sur une des 2 partitions  p2 ou p3 de l'eMMC (ping-pong)
case $root in
    /dev/mmcblk2p2)
        INSTALL_PARTITION="/dev/mmcblk2p3"
        INSTALL_DIR="/media/rootfs2"
        PARTITION_START=1181696
        ;;
    *)
        INSTALL_PARTITION="/dev/mmcblk2p2"
        INSTALL_DIR="/media/rootfs"
        PARTITION_START=133120
        ;;
esac

# Copie du rootfs a dans sa partition reservee
umount $INSTALL_PARTITION
mkfs.ext3 $INSTALL_PARTITION
mount -a
cd $INSTALL_DIR
tar xjvf $WORK_DIR/core-image-scopix-imx6sdhcom3scopix.tar.bz2

# Copie du noyau et des blobs dans la partition /media/boot
cd $WORK_DIR
cp zImage /media/boot
cp *.dtb /media/boot
cp settings.bin /media/boot

# Creation eventuel du repertoire d'installation
if [ ! -d $INSTALL_DIR/opt ]
then
    mkdir $INSTALL_DIR/opt
fi

# Copie des applications dans le repertoire /opt du nouveau rootfs
cp battery-display $INSTALL_DIR/opt
chmod +x $INSTALL_DIR/opt/battery-display
cp battery-manager $INSTALL_DIR/opt
chmod +x $INSTALL_DIR/opt/battery-manager
cp Config $INSTALL_DIR/opt
chmod +x $INSTALL_DIR/opt/Config
cp FileMan $INSTALL_DIR/opt
chmod +x $INSTALL_DIR/opt/FileMan
cp manager $INSTALL_DIR/opt
chmod +x $INSTALL_DIR/opt/manager
cp scopixIV $INSTALL_DIR/opt
chmod +x $INSTALL_DIR/opt/scopixIV
cp update-display $INSTALL_DIR/opt
chmod +x $INSTALL_DIR/opt/update-display
cp update-manager $INSTALL_DIR/opt
chmod +x $INSTALL_DIR/opt/update-manager

# Modification du fichier uLinuxEnv pour changer la valeur des arguments de LINUX
case $root in
    /dev/mmcblk2p2)
        sed -e 's/mmc_rootfs_part=p[23]/mmc_rootfs_part=p3/' uLinuxEnv.txt >/media/boot/uLinuxEnv.txt
        ;;
    *)
        sed -e 's/mmc_rootfs_part=p[23]/mmc_rootfs_part=p2/' uLinuxEnv.txt >/media/boot/uLinuxEnv.txt
        ;;
esac

# Installation des traductions
if [ ! -d $INSTALL_DIR/opt/translations ]
then
    mkdir $INSTALL_DIR/opt/translations
fi

cd $INSTALL_DIR/opt/translations
tar xf $WORK_DIR/translations.tar

# Installation des documents NF et QSG
if [ -d /media/doc ]
then
    cd /media/doc
    rm *
    tar xjvf $WORK_DIR/docs.tar.bz2
fi

# Destruction du fichier de calibration de la dalle tactile pour forcer une recalibration manuelle
rm $INSTALL_DIR/etc/pointercal

# Destruction du setup courant pour eviter un crash au demarrage
rm /media/private/setup.cfg 
rm /media/private/sta_settings.conf

# Redemarrage de SCOPIX IV
reboot
