#include <cvidef.h>

/*= <MTX162> Include File ===================================================*/
 
/*===========================================================================*/
/*  Please do not use global variables or arrays in the include file of      */
/*  instrument drivers that will be submitted for inclusion into the         */
/*  LabWindows Instrument Driver Library.                                    */
/*===========================================================================*/
     
#ifndef __mtx162_HEADER
#define __mtx162_HEADER

#include <vpptype.h>

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

#define VI_ERROR_INSTR_FILE_OPEN                (_VI_ERROR+0x3FFC0800L)
#define VI_ERROR_INSTR_FILE_WRITE               (_VI_ERROR+0x3FFC0801L)
#define VI_ERROR_INSTR_INTERPRETING_RESPONSE    (_VI_ERROR+0x3FFC0803L)
#define VI_ERROR_INSTR_PARAMETER9               (_VI_ERROR+0x3FFC0809L)
#define VI_ERROR_INSTR_PARAMETER10              (_VI_ERROR+0x3FFC080AL)
#define VI_ERROR_INSTR_PARAMETER11              (_VI_ERROR+0x3FFC080BL)
#define VI_ERROR_INSTR_PARAMETER12              (_VI_ERROR+0x3FFC080CL)
#define VI_ERROR_INSTR_PARAMETER13              (_VI_ERROR+0x3FFC080DL)
#define VI_ERROR_INSTR_PARAMETER14              (_VI_ERROR+0x3FFC080EL)
#define VI_ERROR_INSTR_PARAMETER15              (_VI_ERROR+0x3FFC080FL)

/*****************************************************************************/
/*= Define Instrument Specific Error/Warning Codes Here =====================*/
/*****************************************************************************/
#define VI_WARNING_INSTR_OFFSET                           (0x3FFC0900L)
#define VI_ERROR_INSTR_OFFSET                   (_VI_ERROR+0x3FFC0900L)

#define PREFIX_ERROR_INVALID_CONFIGURATION      (VI_ERROR_INSTR_OFFSET + 0xF0L)


/*****************************************************************************/
/*= Define Instrument Specific Error Codes Here =============================*/
/*****************************************************************************/
#define VI_ERROR_PARAMETER9             (_VI_ERROR+0x3FFC0009L)


#define VI_ERROR_MTX162_ERROR                   (_VI_ERROR+0x3FFC0900L)
#define VI_ERROR_MTX162_INCONSISTENT_PARAMETER3 (_VI_ERROR+0x3FFC0903L)
#define VI_ERROR_MTX162_INCONSISTENT_PARAMETER5 (_VI_ERROR+0x3FFC0905L)
#define VI_ERROR_MTX162_INCONSISTENT_PARAMETER6 (_VI_ERROR+0x3FFC0906L)
#define VI_ERROR_MTX162_INCONSISTENT_PARAMETER7 (_VI_ERROR+0x3FFC0907L)
#define VI_ERROR_MTX162_AUTOTEST_PROBLEM        (_VI_ERROR+0x3FFC090BL)
#define VI_ERROR_MTX162_CHAN_NOT_ACTIVE         (_VI_ERROR+0x3FFC090CL)
#define VI_ERROR_MTX162_FILE_NOT_FOUND          (_VI_ERROR+0x3FFC090DL)
#define VI_ERROR_MTX162_EXISTING_FILE           (_VI_ERROR+0x3FFC090EL)
#define VI_ERROR_MTX162_NO_CHAN_ENABLED         (_VI_ERROR+0x3FFC090FL)
#define VI_ERROR_MTX162_INVALID_FILE_CONTENT    (_VI_ERROR+0x3FFC0910L)
/*****************************************************************************/
/*= GLOBAL USER-CALLABLE FUNCTION DECLARATIONS (Exportable Functions) =======*/
/*****************************************************************************/
ViStatus _VI_FUNC mtx162_init (ViRsrc resourceName, ViBoolean IDQuery,
                    ViPSession instrumentHandle);
ViStatus _VI_FUNC mtx162_example (ViSession instrumentHandle, ViInt16 source,
                    ViInt16 timebaseA, ViInt16 voltageRange, ViInt16 coupling,
                    ViReal64 _VI_FAR waveformArray[], ViPInt32 numberofsamples, 
                    ViPReal64 XStart, ViPReal64 XIncrement);
ViStatus _VI_FUNC mtx162_verticalSetup (ViSession instrumentHandle, ViInt16 input,
                    ViBoolean state, ViInt16 coupling, ViInt16 probe,
                    ViInt16 voltDiv, ViReal64 offsetvolts, ViReal64 bandwidth);
ViStatus _VI_FUNC mtx162_horizontalSetup (ViSession instrumentHandle,
                    ViInt16 range, ViReal64 runafterdelays);
ViStatus _VI_FUNC mtx162_setGeneralTrigger (ViSession instrumentHandle, ViInt16 triggerSource, 
					ViBoolean slope, ViInt16 coupling, ViInt16 type, ViReal64 levelvolts);
ViStatus _VI_FUNC mtx162_setWaveformDisplay (ViSession instrumentHandle, ViInt16 acquisition,
					ViInt16 averagerate, ViInt16 displaymode);
ViStatus _VI_FUNC mtx162_setCursors (ViSession instrumentHandle, ViInt16 reference, 
					ViBoolean Unattached_cur, ViReal64 t1s, ViReal64 t2s);
ViStatus _VI_FUNC mtx162_runAutoset (ViSession instrumentHandle);
ViStatus _VI_FUNC mtx162_runAcquisition (ViSession instrumentHandle, ViBoolean Run);
ViStatus _VI_FUNC mtx162_readCursors (ViSession instrumentHandle, ViInt16 reference, ViPReal64 t1s,
					ViPReal64 t2s, ViPReal64 dTs, ViPReal64 v1v, ViPReal64 v2v, ViPReal64 dVv);
ViStatus _VI_FUNC mtx162_readChToArr (ViSession instrumentHandle, ViInt16 source, ViReal64 _VI_FAR waveformArray[],
                    ViPInt32 numberofsamples, ViPReal64 XStart, ViPReal64 XIncrement ); 
ViStatus _VI_FUNC mtx162_readChToFile (ViSession instrumentHandle, ViInt16 source,
                    ViString fileName, ViBoolean overwriteFile);
ViStatus _VI_FUNC mtx162_readFileToArr (ViSession instrumentHandle, ViString fileName, ViReal64 _VI_FAR waveformArray[],
					ViPInt32 numberofsamples, ViPReal64 XStart, ViPReal64 XIncrement);
ViStatus _VI_FUNC mtx162_saveSetup (ViSession instrumentHandle, ViBoolean mode, ViString fileName, ViBoolean overwriteFile);
ViStatus _VI_FUNC mtx162_writeInstrData (ViSession instrumentHandle, ViString writeBuffer);
ViStatus _VI_FUNC mtx162_readInstrData (ViSession instrumentHandle, ViInt32 numberBytesToRead, 
					ViChar _VI_FAR readBuffer[], ViPInt32 numBytesRead);
ViStatus _VI_FUNC mtx162_reset (ViSession instrumentHandle);
ViStatus _VI_FUNC mtx162_selfTest (ViSession instrumentHandle, ViPInt16 selfTestResult, ViChar _VI_FAR selfTestMessage[]);
ViStatus _VI_FUNC mtx162_errorQuery (ViSession instrumentHandle, ViPInt32 errorCode, ViChar _VI_FAR errorMessage[]);
ViStatus _VI_FUNC mtx162_errorMessage (ViSession instrumentHandle, ViStatus errorCode, ViChar _VI_FAR errorMessage[]);
ViStatus _VI_FUNC mtx162_revisionQuery (ViSession instrumentHandle, ViChar _VI_FAR instrumentDriverRevision[],
                    ViChar _VI_FAR firmwareRevision[]);
ViStatus _VI_FUNC mtx162_close (ViSession instrumentHandle);



#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif

/*****************************************************************************/
/*=== END INCLUDE FILE ======================================================*/
/*****************************************************************************/

#endif
