s         -   !  U                                       mtx162      Metrix MTX162 DSO 60MS/s (VISA)                 ViInt16     ViInt32    ViReal64      ViRsrc     	 	ViBoolean     	 	ViSession      ViStatus       ViChar[]      ViChar      ViString     	  ViInt16[]     	  ViInt32[]     
  	ViReal64[]      	 
ViBoolean[]    ViUInt16    ViUInt32  Z    This instrument module provides programming support for the Metrix MTX162 (VISA).  The module is divided into the following functions:

Functions/Classes:

(1) Initialize:
This function initializes the instrument and sets it to a default configuration.

(2) Application Functions: (Class)
This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

(3) Configuration Functions: (Class)
This class of functions configures the instrument by setting acquisition and system configuration parameters.

(4) Action/Status Functions: (Class)
This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

(5) Data Functions: (Class)
This class of functions transfers data to or from the instrument.

(6) Utility Functions: (Class)
This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

(7) Close:
This function takes the instrument offline.
    $    This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

Functions:

(1) Example:
This function configures the MTX1054, runs a Single acquisition, reads and displays a waveform.        This class of functions configures the instrument by setting acquisition and system configuration parameters.

Functions/SubClasses:

(1) Vertical Setup:
Configures various vertical control parameters.

(2) Horizontal: (SubClass)
Configures horizontal control parameters.

(3) Trigger: (SubClass)
Configures the triggering system of the oscilloscope.

(4) Display: (SubClass)
Configures the display parameters.

(5) Hardcopy Setup:
Configures the hardcopy parameters.
         This class of functions configures the horizontal parameters.

Functions:

(1) Horizontal Setup:
Configures the Horizontal Setup parameters.

(2) Horizontal Display:
Configures the Horizontal Display parameters.
(3)FFT
Configures the FFT mode.
          This class of functions configures the triggering of the oscilloscope.


 General Trigger :
Configures the general trigger parameters.

        This class of functions configures the display of the oscilloscope.

Functions:

(1) Options :
Configures the optional display parameters.

(2) Waveform:
Configures the waveform display parameters.

(3) Cursors:
Configures the cursors display parameters.

        This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

Functions:

(1) Autoset:
Performs an autoset.

(2) Run/Stop :
Enables or disables the acquisition of input signals.
        This class of functions transfers data to or from the instrument.

Functions:

(1) Read Cursors:
This function reads the cursors positions.

(2) Read Measurements:
This function reads one of the automatic measurement of the oscilloscope.

(3) Waveform:  (Subclass)
This class of functions transfers waveform data to or from the instrument.

(4) Transfer:  (Subclass)
This class of functions transfers files to or from the instrument.
    I    This class of functions transfer waveform data to or from the instrument.

Functions:

(1) Read Channel to Array:
Reads a trace from the instrument and places it in an array.

(2) Read Channel to File:
Reads a trace from the instrument and places it in a file.

(3) Read File to Array:
Reads a file and places it in an array.

         This class of functions transfer files to or from the instrument.

Functions:

(1) Save/Recall Setup to/from File:
Saves a setup to a file or recalls a setup from a file.

    X    This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

Functions:

(1) Write To Instrument:
This function writes commands and queries to the instrument to modify parameters and query device settings.

(2) Read Instrument Data:
This function reads data from instrument buffer and returns it to the specified variable in memory.

(3) Reset:
This function resets the instrument to its default state.

(4) Self-Test:
This function runs the instrument self test and returns the test code.

(5) Error Query:
This function reads an error code from the instrument error queue.

(6) Error Message:
This function takes the Status Code and returns it as a user readable string.
 
(7) Revision Query:
This function returns the revision numbers of the instrument driver and instrument firmware.

        This function performs the following initialization actions:

- Opens a session to the Default Resource Manager resource and a session to the specified device using the interface and address specified in the Resource_Name control.

- Performs an identification query on the Instrument.

- Sends initialization commands to the instrument that set any necessary programmatic variables such as Headers Off, Short Command form, and Data Transfer Binary to the state necessary for the operation of the instrument driver.

- Returns an Instrument Handle which is used to differentiate between different sessions of this instrument driver.

- Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
        This control specifies the interface and address of the device that is to be initialized (Instrument Descriptor). The exact grammar to be used in this control is shown in the note below. 

Default Value:  "USB"

Notes:

(1) Based on the Instrument Descriptor, this operation establishes a communication session with a device.  The grammar for the Instrument Descriptor is shown below.  Optional parameters are shown in square brackets ([]).

Interface   Grammar
------------------------------------------------------
TCPIP       TCPIP[board]::host address::23::SOCKET
USB         USB


Example with TCPIP Parameters :
- Board = 0
- Port = 23
- IP address of oscilloscope = 192.168.0.100

"TCPIP0::192.168.0.100::23::SOCKET"



The default value for optional parameters are shown below.

Optional Parameter          Default Value
-----------------------------------------
board                       0
host address                IP address
        This control specifies if an ID Query is sent to the instrument during the initialization procedure.

Valid Range:
VI_OFF (0) - Skip Query
VI_ON  (1) - Do Query (Default Value)

Notes:
   
(1) Under normal circumstances the ID Query ensures that the instrument initialized is the type supported by this driver. However circumstances may arise where it is undesirable to send an ID Query to the instrument.  In those cases; set this control to "Skip Query" and this function will initialize the selected interface, without doing an ID Query.    7    This control returns an Instrument Handle that is used in all subsequent function calls to differentiate between different sessions of this instrument driver.

Notes:

(1) Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.

BFFC0011  Instrument returned invalid response to ID Query

BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.     /    ,    Ressource Name                     )        ID Query                               }    Instrument Handle                 6#      Status                           N 
                                           
                                            "USB"  ! Do Query VI_ON Skip Query VI_OFF    	           	           gTCPIP Parameters : 
Board = 0
Port = 23
ex : "TCPIP0::192.168.0.100::23:: SOCKET" for IP 192.168.0.100    0USB Parameters : 
ex : "USB" for USB connection   }    This function is an example of this driver's functions use.

The instrument is set to the single shot mode.
User can change the source channel, the timebase, the input voltage range and the input coupling.
A trigger is then sent to the instrument.
The function waits until the acquisition is completed.
Channel is read out from the instrument.
Waveform is interpolated if needed.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Channel) out of range.
BFFC0003  Parameter 3 (Timebase) out of range.
BFFC0004  Parameter 4 (Voltage Range) out of range.
BFFC0005  Parameter 5 (Coupling) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.
BFFC090C  Channel is not active.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     m    This control selects the source channel.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4     x    This control selects the input coupling of the selected channel.

Valid Values:
0 - AC  (Default Value)
1 - DC
2 - GND        This control selects the main timebase (A) value.

Valid Values: 
0  - 1ns 
1  - 2ns 
2  - 5ns
3  - 10ns  
4  - 20ns 
5  - 50ns
6  - 100ns  
7  - 200ns
8  - 500ns
9  - 1s  
10 - 2s
11 - 5s
12 - 10s  
13 - 20s 
14 - 50s
15 - 100s  
16 - 200s 
17 - 500s 
18 - 1ms  
19 - 2ms  
20 - 5ms 
21 - 10ms   
22 - 20ms 
23 - 50ms 
24 - 100ms   
25 - 200ms  
26 - 500ms 
27 - 1s  
28 - 2s
29 - 5s
30 - 10s  
31 - 20s
32 - 50s        This control sets vertical sense for the specified channel. 

Valid Values:

0  - 2mV/div 
1  - 5mV/div  
2  - 10mV/div           
3  - 20mV/div           
4  - 50mV/div             
5  - 100mV/div          
6  - 200mV/div          
7  - 500mV/div          
8  - 1V/div           
9  - 2V/div  
10 - 5V/div               
11 - 10V/div  (Default Value)
12 - 20V/div              
13 - 50V/div              
14 - 100V/div             
15 - 200V/div            
16 - 500V/div            
17 - 1kV/div              

Note : This control value must be consistent with the probe value. See the Digiscope 2000 Operating Instructions manual for more details. If it is inconsistent an error is generated : VI_ERROR_INCONSISTENT_PARAMETER7 (0xBFFC0907)


         This control specifies the name of the array in which to place the waveform data.

Notes:

(1) The Real Array must be large enough to hold the requested points.     R    This control returns the number of valid points read from the selected channel.
     i    This control returns the time of the first data point in seconds (with respect to the trigger point).

     I    This control returns the incrementing value in seconds for the X axis.
    &g#      Status                            +7#         Instrument Handle                 + ) G        Source                            ,K )  P    Coupling                          , )   P    Time base                         .{ )  P    Voltage Range                     1n     `    Waveform Array                    2     `    Number of samples                 2r ,   `    X Start                           2    `    X Increment                        	                          CH1 0 CH2 1              AC 0 DC 1 GND 2           !  200 s 34 100 s 33 50 s 32 20 s 31 10 s 30 5 s 29 2 s 28 1 s 27 500 ms 26 200 ms 25 100 ms 24 50 ms 23 20 ms 22 10 ms 21 5 ms 20 2 ms 19 1 ms 18 500 s 17 200 s 16 100 s 15 50 s 14 25 s 13 10 s 12 5 s 11 2.5 s 10 1 s 9 500 ns 8 250 ns 7 125 ns 6 50 ns 5 20 ns 4 10 ns 3 5 ns 2        	      n100 V 14 50 V 13 20 V 12 10 V 11 5 V 10 2 V 9 1 V 8 500 mV 7 200 mV 6 100 mV 5 50 mV 4 20 mV 3 10 mV 2 5 mV 1    	            	            	           	               This function configures the selected input channel of the instrument.

The following settings are available :
- Channel
- State
- Coupling
- Probe
- Channel inversion
- Range
- Offset
- Bandwidth limitation        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Input) out of range.
BFFC0003  Parameter 3 (State) out of range.
BFFC0004  Parameter 4 (Coupling) out of range.
BFFC0005  Parameter 5 (Probe) out of range.
BFFC0006  Parameter 6 (Polarity) out of range.
BFFC0007  Parameter 7 (Volts/div) out of range.
BFFC0008  Parameter 8 (Offset) out of range.

BFFC0803  Error scanning response.
BFFC0809  Parameter 9 (Bandwidth) out of range.

BFFC0900  Instrument specific error.
BFFC0907  Parameter 7 (Volts/div) is inconsistent.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     e    This control selects the channel to configure.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
  
     y    This control selects the coupling of the specified channel.

Valid Values: 
0 - AC  
1 - DC  (Default Value)
2 - GND  
         This control selects the probe of the specified channel.

Valid Values: 
1 - x 1  (Default Value)
2 - x 10
3 - x 100 
4 - x 1000 
        This control sets vertical sense for the specified channel. 

Valid Values:

0  - 2.50mV/div 
1  - 5.00mV/div  
2  - 10.0mV/div           
3  - 20.0mV/div           
4  - 50.0mV/div             
5  - 100mV/div          
6  - 200mV/div          
7  - 500mV/div          
8  - 1V/div     (Default Value)      
9  - 2V/div  
10 - 5V/div               
11 - 10V/div  
12 - 20V/div              
13 - 50V/div              
14 - 100V/div             
15 - 200V/div            
16 - 500V/div            
17 - 1kV/div              

Note : This control value must be consistent with the probe value. See the Digiscope 2000 Operating Instructions manual for more details. If it is inconsistent an error is generated : VI_ERROR_INCONSISTENT_PARAMETER7 (0xBFFC0907)


        This control sets the signal offset of the specified channel. 

Valid Ranges:

vertical sense       offset range
2.5mV/div              +/- 80mV
5mV/div              +/- 80mV
10mV/div             +/- 400mV
20mV/div             +/- 400mV
50mV/div             +/- 2V
100mV/div            +/- 2V
200mV/div            +/- 2.5V
500mV/div            +/- 12.5V
1V/div               +/- 12.5V
2V/div               +/- 64V
5V/div               +/- 64V
10V/div              +/- 64V
20V/div              +/- 640V
50V/div              +/- 640V
100V/div             +/- 640V
200V/div             +/- 6400V
500V/div             +/- 6400V
1kV/div              +/- 6400V

Default Value: 0.0
     t    This control selects the state of the specified channel.

Valid Values: 
VI_ON  (1)   (Default Value)
VI_OFF (0) 
     }    This control selects the state of the specified channel.

Valid Values: 
VI_ON  (1) - On  (Default Value)
VI_OFF (0) - Off
    8A#      Status                            =#         Instrument Handle                 >q ) G        Input                             > )        Coupling                          ?_ )}        Probe                             ?  d  K    Volt/Div                          B    K    Offset (volts)                    E         Bandwidth                         F )         State                              	                          CH1 1 CH2 2              AC 0 DC 1 GND 2                x1 1 x10 10 x100 100 x1000 1000        	      w100 V 14 50 V 13 20 V 12 10 V 11 5 V 10 2 V 9 1 V 8 500 mV 7 200 mV 6 100 mV 5 50.0 mV 4 20.0 mV 3 10.0 mV 2 5 .00mV 1    0.0               'OFF 0 15MHz 15e6 1.5MHz 1.5e6 5kHz 5e3   On VI_ON Off VI_OFF        This function configures the horizontal settings of the instrument.

The following settings are available :

- Pretrigger 
- Range (the main timebase)

    P    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Size) out of range.
BFFC0003  Parameter 3 (Pretrig) out of range.
BFFC0004  Parameter 4 (Delay) out of range.
BFFC0005  Parameter 5 (RangeA) out of range.
BFFC0006  Parameter 6 (DelayA) out of range.
BFFC0007  Parameter 7 (RangeB) out of range.
BFFC0008  Parameter 8 (DelayB) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.
BFFC0907  Parameter 7 (RangeB) is inconsistent.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control selects the main timebase  value.

Valid Values:
0  - 1ns
1  - 2ns 
2  - 5ns
3  - 10ns  
4  - 20ns 
5  - 50ns
6  - 100ns  
7  - 200ns
8  - 500ns - (Default Value)
9  - 1s  
10  - 2s
11 - 5s
12 - 10s  
13 - 20s 
14 - 50s
15 - 100s  
16 - 200s 
17 - 500s 
18 - 1ms  
19 - 2ms  
20 - 5ms 
21 - 10ms   
22 - 20ms 
23 - 50ms 
24 - 100ms   
25- 200ms  
26 - 500ms 
27 - 1s  
28 - 2s
29 - 5s
30 - 10s  
31 - 20s
32 - 50s
33 - 100s
34 - 200s        This control selects the pretrig value ().

Default Value: 0.0
Valid Values are between -10*Range and 25*Range:

Range     Max Values    Min Values      Middle Values 

200s   ->  5000          -2000           -1000
100s   ->  2500          -1000           -500
50s    ->  1250           -500           -250
20s    ->  500           -200            -100
10s    ->  250           -100            -50
5s     ->  125           -50             -25
2s     ->  50            -20             -10
1s     ->  25            -10             -5 
500ms  ->  12500         -5000           -2500
200ms  ->  5000          -2000           -1000
100ms  ->  25*100        -10*100         -500
50ms   ->  25*50         -10*50          -250
20ms   ->  25*20         -10*20          -100
10ms   ->  25*10         -10*10          -50
5ms    ->  25*5          -10*5           -25
2ms    ->  25*2          -10*2           -10
1ms    ->  25*1          -10*1           -5 
500us  ->  25*500        -500*10         -2500
200us  ->  25*200        -10*200         -1000
100us  ->  25*100        -10*100         -500
50us   ->  25*50         -10*50          -250
20us   ->  25*20         -10*20          -100
10us   ->  25*10         -10*10          -50
5us    ->  25*5          -10*5           -25
2us    ->  25*2          -10*2           -10
1us    ->  25*1          -10*1           -5 
500ns  ->  25*500        -500*10         -2500
200ns  ->  25*200        -10*200         -1000
100ns  ->  25*100        -10*100         -500
50ns   ->  25*100        -10*100         -500
20ns   ->  25*100        -10*100         -500
10ns   ->  25*100        -10*100         -500
5ns    ->  25*100        -10*100         -500
2ns    ->  25*100        -10*100         -500
1ns    ->  25*100        -10*100         -500
        Jj#      Status                            O#         Instrument Handle                 Pa L \  P    Range                             R2 NR  `    Run after delay                    	                      !  200 s 34 100 s 33 50 s 32 20 s 31 10 s 30 5 s 29 2 s 28 1 s 27 500 ms 26 200 ms 25 100 ms 24 50 ms 23 20 ms 22 10 ms 21 5 ms 20 2 ms 19 1ms 18 500 s 17 200 s 16 100 s 15 50 s 14 25 s 13 10s 12 5 s 11 2.5 s 10 1 s 9 500 ns 8 250 ns 7 125 ns 6 50 ns 5 25 ns 4 10 ns 3 5 ns 2    0.0        This function configures the general trigger parameters of the instrument.

The following settings are available :

- Trigger Source 
- Slope
- Coupling
- Noise Rejection
- Type
- Level

        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Channel) out of range.
BFFC0003  Parameter 3 (Slope) out of range.
BFFC0004  Parameter 4 (Coupling) out of range.
BFFC0006  Parameter 5 (Type) out of range.
BFFC0007  Parameter 6 (Level) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.
BFFC0905  Parameter 5 (HF Rejection) is inconsistent.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     ~    This control selects the trigger source to configure.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - External
4 - LINE     |    This control sets the slope of the specified channel.

Valid Values: 
VI_ON  (1) - Up (Default Value)
VI_OFF (0) - Down  
         This control selects the coupling mode of the specified channel.

Valid Values: 
0 - AC (Default Value)
1 - DC  
2 - LF Rej
3 - HF Rej
4 _ TV-Field
5 - TV-line         This control sets level of trigger for the specified channel. 

Valid Range:
-7.5 * vertSense (vertSense in Volts/div)  to  7.5 * vertSense (vertSense in Volts/div)

Default Value: 0.0 V
     p    This control selects the type of trigger.

Valid Values: 
0 - Triggered
1 - Auto (Default Value)
2 - Single  
    \#      Status                            a
#         Instrument Handle                 a ) 9        Trigger Source                    b2 )         Slope                             b )T        Coupling                          c_    `    Level (volts)                     d$  P        Type                               	                          CH1 0 CH2 1 Line 3   Up VI_ON Down VI_OFF               AC 0 DC 1 LF rej 2 HF rej 3    0.0              Trig'd 0 Auto 1 Single 2        This function configures the waveform display of the instrument.

The following settings are available :

- Min/Max acquisition
- Average rate
- Mode 
- Repetitive Signal
     u    This control sets the average rate.

Valid Values: 
0 - No averaging (Default Value)
1 - 2  
2 - 4
3 - 16  
4 - 64
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    z    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (MinMax) out of range.
BFFC0003  Parameter 3 (Average rate) out of range.
BFFC0004  Parameter 4 (Display Mode) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     f    This control selects the display mode.

Valid Values: 
0 - Vector   (Default Value)
1 - Envelope
        s    This control Valids the Min/Max Acquisition.

Valid Values: 
0 - Normal_OFF   (Default Value)
1 - Envelope_ ON


    gh H  Z    Average rate                      g#         Instrument Handle                 h#      Status                            m 5        Display Mode                      mt >         Min-Max                                       16 4 8 3 4 2 2 1 No averaging 0        	                     Vector 0 Envelope 1              ON 0 OFF 1        This function sets horizontal cursors.

The following settings are available :

- Cursors 
- Reference
- Unattached cursors 
- T1
- T2
- TPhase
     W    This control selects the reference.

Valid Values: 
0 - CH1  (Default Value)
1 - CH2
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Reference) out of range.
BFFC0003  Parameter 3 (Unattached cursors) out of range.
BFFC0004  Parameter 4 (T1) out of range.
BFFC0005  Parameter 5 (T2) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.     v    This control sets the position of the vertical cursor #1.

Valid Range:
+/- 100 * horizSense (horizSense in s/div)

     v    This control sets the position of the vertical cursor #2.

Valid Range:
+/- 100 * horizSense (horizSense in s/div)

     t    This control selects the unattached cursors.

Valid Values: 
VI_OFF (0) - Off  
VI_ON  (1) - On   (Default Value)
    p )         Reference                         pm#         Instrument Handle                 q#      Status                            u  ~  `    T1 (s)                            v3    `    T2 (s)                            v +        Unattached cursors                            CH1 0 CH2 1        	           250E-3    500E-3   On VI_ON Off VI_OFF    6    This function performs an autoset of the instrument.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.
BFFC090F  No channel is enabled.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    x#      Status                            }#         Instrument Handle                  	               D    This function controls the acquisition system of the instrument. 
    >    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Mode) out of range.
BFFC0003  Parameter 3 (Wait?) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         This control valid the acquisition system of the instrument. 

Valid Values:
VI_OFF (0) - Stop 
VI_ON  (1) - Run   (Default Value)

    ~t#      Status                            #         Instrument Handle                 Y Y         Acquisition                        	              Run VI_ON Stop VI_OFF    Z    This function reads cursors positions.
All measured quantities are in their basic units.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Reference) out of range.
BFFC0003  Parameter 3 (T1) out of range.
BFFC0004  Parameter 4 (T2) out of range.
BFFC0005  Parameter 5 (dT) out of range.
BFFC0006  Parameter 6 (V1) out of range.
BFFC0007  Parameter 7 (V2) out of range.
BFFC0008  Parameter 8 (dV) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     |    This control selects the reference channel for the cursors positions.

Valid Values: 
0 - CH1  (Default Value)
1 - CH2
  
     ?    This control outputs the position of the vertical cursor #1.
     ?    This control outputs the position of the vertical cursor #2.
     ?    This control outpus the difference between vertical cursors.
     @    This control outpus the position of the horizontal cursor #1.
     ?    This control outpus the position of the horizontal cursor #2.     A    This control outpus the difference between horizontal cursors.
    #         Instrument Handle                 #      Status                              9        Reference                         I     `    T1 (s)                             b    `    T2 (s)                                 `    dT (s)                             \   `    V1 (V)                            f b\   `    V2 (V)                             Y   `    dV (V)                                 	                      CH1 0 CH2 1    	           	           	           	           	           	           [    This function reads the specified channel from the instrument and places it in an array.
     ]    This control selects the source channel.

Valid Values: 
0 - CH1  (Default Value)
1 - CH2

         This function specifies the name of array in which to place the waveform data.

Notes:

(1) The Real Array must be large enough to hold the requested points.His numberr of elements is 50000.
     S    This function returns the number of valid points read from the selected channel.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Source) out of range.
BFFC0003  Parameter 3 (Interpolation) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.
BFFC090C  Channel is not active.
BFFC0910  Invalid file content.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     j    This function returns the time of the first data point in seconds (with respect to the trigger point).

     J    This function returns the incrementing value in seconds for the X axis.
     3        Source                              
   `    Waveform Array                         `    Number of samples                 2#         Instrument Handle                 #      Status                            c +   `    X Start                               `    X Increment                                   CH1 0 CH2 1    	            	                	           	           	           M    This function reads a channel from the instrument and stores it as a file.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Source) out of range.
BFFC0003  Parameter 3 (Drive) out of range.
BFFC0004  Parameter 4 (Filename) out of specifications.
BFFC0005  Parameter 5 (Overwrite File?) out of range.

BFFC0801  Error writing to file.
BFFC0803  Error scanning response

BFFC0900  Instrument specific error.
BFFC090C  Channel is not active.
BFFC090E  File already exists.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
        This function specifies the name of the wave data file.

Default Value: ""

Notes:

(1) When storing a file to Computer, precede all backslashes with an additional backslash, e.g. if the file is in the \cvi\instr directory, enter the filename as "\\cvi\\instr\\anyfile".

(2) File name must be 15-character long max plus ".TRC" extension.The extention must be in capital letter.
If not, an error is generated :0xBFFC0004 

(3) If the target file already exists and overwrite is not selected, an error is generated : 0xBFFC090E

         This function specifies whether or not to write over the specified file if it already exists.

Valid Range:  
VI_OFF (0) - No  (Default Value)
VI_ON  (1) - Yes
     \    This control selects the source channel.

Valid Values: 
0 - CH1  (Default Value)
1 - CH2
    J#         Instrument Handle                 #      Status                               y       File Name                          C        Overwrite File?                    +        Source                                 	           ""    Yes VI_ON No VI_OFF               CH1 0 CH2 1    N    This function reads a stored waveform file and places the data in an array.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Drive) out of range.
BFFC0003  Parameter 3 (Filename) out of specifications.
BFFC0004  Parameter 4 (Interpolation) out of range.

BFFC0800  Error opening file.
BFFC0803  Error scanning response

BFFC0900  Instrument specific error.
BFFC090D  File not found.
BFFC0910  Invalid file content.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.        This function specifies the name of the wave data file.

Default Value: ""

Notes:

(1) When reading a file from Computer, precede all backslashes with an additional backslash, e.g. if the file is in the \cvi\instr directory, enter the filename as "\\cvi\\instr\\anyfile".

(2) File name must be 15-character long max + ".TRC" extension.
The extention must be in capital letter.
If not an error is generated :0xBFFC0003  

(3) If file does not exist an error is generated : 0xBFFC090D



         This function specifies the name of array in which to place the waveform data.

Notes:

(1) The Real Array must be large enough to hold the requested points.His numberr of elements is 50000.     P    This function returns the number of valid points read from the selected file.
     j    This function returns the time of the first data point in seconds (with respect to the trigger point).

     J    This function returns the incrementing value in seconds for the X axis.
    #         Instrument Handle                 n#      Status                            L =        File Name                         >     `    Waveform Array                         `    Number of samples                 ^ .   `    X Start                               `    X Increment                            	           ""    	            	            	           	           7    This function save or recall set-up to or from file.
    D    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Mode) out of range.
BFFC0003  Parameter 3 (Drive) out of range.
BFFC0004  Parameter 4 (Filename) out of specifications.
BFFC0005  Parameter 5 (Overwrite File?) out of range.

BFFC0800  Error opening file.
BFFC0801  Error writing to file.
BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.
BFFC090D  File not found.
BFFC090E  File already exists.
BFFC0910  Invalid file content.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This function specifies the name of the setup data file.

Default Value: ""

Notes:

(1) When reading/writing a file from/to Computer, precede all backslashes with an additional backslash, e.g. if the file is in the \cvi\instr directory, enter the filename as "\\cvi\\instr\\anyfile".

(2) File name must be 8-character long max + ".CFG" extension.
The extention must be in capital letter.

If not an error is generated :0xBFFC0004  

(3) When saving a setup : if the target file already exists and overwrite is not selected an error is generated : 0xBFFC090E

(4) When recalling a setup : if file does not exist an error is generated : 0xBFFC090D

         This function specifies whether or not to write over the specified file if it already exists on disk.

Valid Range:  
VI_OFF (0) - No  (Default Value)
VI_ON  (1) - Yes
     |    This control selects between Save and Recall mode.

Valid Range:  
VI_OFF (0) - Recall
VI_ON  (1) - Save  (Default Value)
    #      Status                            f#         Instrument Handle                          File Name                          ]        Overwrite File?                   J )        Mode                               	               ""    Yes VI_ON No VI_OFF   Save VI_ON Recall VI_OFF    m    This function writes commands and queries to the instrument to modify parameters and query device settings.    z    The user can use this control to send common commands and queries to the instrument. This control can also be used to write any valid command to the instrument.

Default Value:  "*CLS\r"

Notes:

(1) The command or query to be sent to the instrument may be a literal enclosed in double quotes terminated by '\r' i.e. "*CLS\r" or may be contained in a variable of type string.
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     M E      Write Buffer                      #      Status                            #         Instrument Handle                  	"*CLS\r"    	              7    This function reads data from the instrument's output buffer and returns it to the specified variable in memory.

Notes:

(1) Because the instrument may return both numeric and text data in response to queries this function returns the data in string format.

(2) If valid data is not available at the instrument's output buffer when this function is called the instrument will hang up and the function will not return until it times out.  If the time-out is disabled this function will hang indefinitely and it may be necessary to reboot the computer to break out.        The number of bytes specified by this control should be greater than or equal to the number of bytes which are to be read from the instrument. If the actual number of bytes to be read is greater than the number this control specifies then multiple reads will be required to empty the instrument's output buffer.

If the instrument's output buffer is not emptied the instrument may return invalid data when future reads are performed.

Default Value:  50 (See NOTE 2)

Notes:

(1) If NO DATA is available at the instrument's output buffer when this function is called the instrument will hang up and the function will not return until it times out.  If the time-out is disabled, this function will hang indefinitely and it may be necessary to reboot the computer.

(2) If the number of bytes expected is greater than 50 the value of this control may be increased. If the actual number of bytes read is larger than the declared size of the read buffer a run-time error will be generated.
        The incoming data from the instrument is placed into this variable.

Notes:

(1) Because the instrument may return both numeric and text data in response to queries this function returns the data in string format.

(2) This function does not overwrite any old data left in the string variable from the last time the function was called. String data in LabWindows/CVI is terminated with an ASCII null(0x0) and string manipulation functions will only recognize data before the ASCII null.

(3) The declared size of the string variable must be greater than the actual number of bytes read from the instrument if it is not a run-time error will be generated.
        This variable contains the actual number of bytes read from the instrument. This is the value which is returned by the read function.

Notes:

(1) If the actual number of bytes read is less than the number of bytes specified in the Number Bytes To Read control then the output buffer has probably been emptied. If the read function fails and the number of bytes read is 0, the most probable cause for the failure is there was no data available at the instrument's output buffer.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    U M K   `    Number Bytes To Read              9  H      Read Buffer                        Mx   `    NumBytes Read                     ˺#      Status                            _#         Instrument Handle                  50    	            	            	               ~    This function resets the instrument to a known state.
See the Digiscope 2000 Operating Instructions manual for more details.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    ѻ#      Status                            `#         Instrument Handle                  	               W    This function runs the instrument's self test routine and returns the test result(s).         This control contains the value returned from the instrument self test.  Zero means success.  For any other code, see the device's operator's manual.
         This control contains the string returned from the self test. See the device's operation manual for an explanation of the string's contents.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0803  Error scanning response.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     = 2   `    Self Test Result                  x =   ,    Self-Test Message                 U#      Status                            #         Instrument Handle                  	           	            	               H    This function reads an error code from the instrument's error queue.

     N    This control returns the error code read from the instrument's error queue.
         This control returns the error message string read from the instrument's error message queue.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    	 = 2   `    Error Code                        _ =   ,    Error Message                     
#      Status                            #         Instrument Handle                  	            	            	                   This function takes the Status Code returned by the instrument driver functions, interprets it and returns it as a user readable string.      t    This control accepts the Status Code returned from the instrument driver functions.

Default Value:
0 - VI_SUCCESS         This control returns the interpreted Status Code as a user readable message string.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.
3FFF0085  Unknown status.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  VI_NULL     =    `    Error Code                        \ =       Error Message                      #      Status                            #         Instrument Handle                  0    	            	           VI_NULL   0    This function returns the revision numbers of the instrument driver and instrument firmware, and tells the user what firmware the driver is compatible with, for example:

This instrument driver's Revision Number is "Rev 1.0, 04/2005, CVI 6.0" and is compatible with Instrument Firmware Revision "1.6".
         This control returns the Instrument Driver Software Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].         This control returns the Instrument Firmware Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     = 2       Instrument Driver Revision        # =,       Firmware Revision                 #      Status                            O#         Instrument Handle                  	            	            	                   This function performs the following operations:
viClose (instrSession) and viClose (rmSession).

Notes:

(1) The instrument must be reinitialized to use it again.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    #      Status                            <#         Instrument Handle                  	                       "     K*    init                                     $  34 
    K.    example                                  7h  F 	    K.    verticalSetup                            I  Y.     K.    horizontalSetup                          [B  d     K.    setGeneralTrigger                        f  m     K.    setWaveformDisplay                       ot  w-     K.    setCursors                               x  }     K.    runAutoset                               ~(       K.    runAcquisition                              	    K.    readCursors                              F  '     K.    readChToArr                                (     K.    readChToFile                             y  "     K.    readFileToArr                                   K.    saveSetup                                   [     K.    writeInstrData                                  K.    readInstrData                            5       K.    reset                                    y  ܽ     K.    selfTest                                 ݹ  Q     K.    errorQuery                               M  a     K.    errorMessage                             ]       K.    revisionQuery                                   K.    close                                                                      DInitialize                          %Application Functions                DExample                             QConfigure Functions                  DVertical Setup                      	/Horizontal                           DHorizontal Setup                    
.Trigger                              DGeneral Trigger                     
Display                              DWaveform                             DCursors                             Action/Status Functions              DAutoset                              DRun/Stop                            Data                                 DRead Cursors                        Waveform                             DRead Channel To Array                DRead Channel To File                 DRead File To Array                  Transfer                             DSave/Recall Setup To/From File      Utility Functions                    DWrite To Instrument                  DRead Instrument Data                 DReset                                DSelf-Test                            DError-Query                          DError Message                        DRevision Query                       DClose                           