#include <cvidef.h>

/*= <mxOX50x2> Include File ===================================================*/
 
/*===========================================================================*/
/*  Please do not use global variables or arrays in the include file of      */
/*  instrument drivers that will be submitted for inclusion into the         */
/*  LabWindows Instrument Driver Library.                                    */
/*===========================================================================*/
     
#ifndef __mxOX50x2_HEADER
#define __mxOX50x2_HEADER

#include <vpptype.h>

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

#define VI_ERROR_INSTR_FILE_OPEN                (_VI_ERROR+0x3FFC0800L)
#define VI_ERROR_INSTR_FILE_WRITE               (_VI_ERROR+0x3FFC0801L)
#define VI_ERROR_INSTR_INTERPRETING_RESPONSE    (_VI_ERROR+0x3FFC0803L)
#define VI_ERROR_INSTR_PARAMETER9               (_VI_ERROR+0x3FFC0809L)
#define VI_ERROR_INSTR_PARAMETER10              (_VI_ERROR+0x3FFC080AL)
#define VI_ERROR_INSTR_PARAMETER11              (_VI_ERROR+0x3FFC080BL)
#define VI_ERROR_INSTR_PARAMETER12              (_VI_ERROR+0x3FFC080CL)
#define VI_ERROR_INSTR_PARAMETER13              (_VI_ERROR+0x3FFC080DL)
#define VI_ERROR_INSTR_PARAMETER14              (_VI_ERROR+0x3FFC080EL)
#define VI_ERROR_INSTR_PARAMETER15              (_VI_ERROR+0x3FFC080FL)

/*****************************************************************************/
/*= Define Instrument Specific Error/Warning Codes Here =====================*/
/*****************************************************************************/
#define VI_WARNING_INSTR_OFFSET                           (0x3FFC0900L)
#define VI_ERROR_INSTR_OFFSET                   (_VI_ERROR+0x3FFC0900L)

#define PREFIX_ERROR_INVALID_CONFIGURATION      (VI_ERROR_INSTR_OFFSET + 0xF0L)


/*****************************************************************************/
/*= Define Instrument Specific Error Codes Here =============================*/
/*****************************************************************************/
#define VI_ERROR_PARAMETER9             (_VI_ERROR+0x3FFC0009L)


#define VI_ERROR_mxOX50x2_ERROR                   (_VI_ERROR+0x3FFC0900L)
#define VI_ERROR_mxOX50x2_INCONSISTENT_PARAMETER3 (_VI_ERROR+0x3FFC0903L)
#define VI_ERROR_mxOX50x2_INCONSISTENT_PARAMETER5 (_VI_ERROR+0x3FFC0905L)
#define VI_ERROR_mxOX50x2_INCONSISTENT_PARAMETER6 (_VI_ERROR+0x3FFC0906L)
#define VI_ERROR_mxOX50x2_INCONSISTENT_PARAMETER7 (_VI_ERROR+0x3FFC0907L)
#define VI_ERROR_mxOX50x2_AUTOTEST_PROBLEM        (_VI_ERROR+0x3FFC090BL)
#define VI_ERROR_mxOX50x2_CHAN_NOT_ACTIVE         (_VI_ERROR+0x3FFC090CL)
#define VI_ERROR_mxOX50x2_FILE_NOT_FOUND          (_VI_ERROR+0x3FFC090DL)
#define VI_ERROR_mxOX50x2_EXISTING_FILE           (_VI_ERROR+0x3FFC090EL)
#define VI_ERROR_mxOX50x2_NO_CHAN_ENABLED         (_VI_ERROR+0x3FFC090FL)
#define VI_ERROR_mxOX50x2_INVALID_FILE_CONTENT    (_VI_ERROR+0x3FFC0910L)

/*****************************************************************************/
/*= GLOBAL USER-CALLABLE FUNCTION DECLARATIONS (Exportable Functions) =======*/
/*****************************************************************************/
ViStatus _VI_FUNC mxOX50x2_init (ViRsrc resourceName, ViBoolean IDQuery,
                    ViPSession instrumentHandle);
ViStatus _VI_FUNC mxOX50x2_example (ViSession instrumentHandle, ViInt16 source,
                    ViInt16 timebaseA, ViInt16 voltageRange, ViInt16 coupling,
                    ViReal64 waveformArray[], ViPInt32 numberofsamples, 
                    ViPReal64 XStart, ViPReal64 XIncrement);
ViStatus _VI_FUNC mxOX50x2_verticalSetup (ViSession instrumentHandle, ViInt16 input,
                    ViBoolean state, ViInt16 coupling, ViInt16 probe,
                    ViInt16 voltDiv, ViReal64 offsetvolts, ViInt16 bandwidth);
ViStatus _VI_FUNC mxOX50x2_horizontalSetup (ViSession instrumentHandle,
                    ViInt16 range, ViReal64 runafterdelays);
ViStatus _VI_FUNC mxOX50x2_horizontalDisplay (ViSession instrSession, ViInt16 trace);
ViStatus _VI_FUNC mxOX50x2_setGeneralTrigger (ViSession instrSession, ViInt16 channel,
								ViBoolean slope, ViInt16 pulse, ViReal64 pulseWidth,
								ViInt16 type, ViReal64 level, ViInt16 filter);
ViStatus _VI_FUNC mxOX50x2_setPulsTrigger (ViSession instrSession, ViInt16 pulsType,
                    		ViReal64 pulse);
ViStatus _VI_FUNC mxOX50x2_setOptionDisplay (ViSession instrSession, ViInt16 device_mode);
ViStatus _VI_FUNC mxOX50x2_setWaveformDisplay (ViSession instrSession,ViInt16 peakDetect,
					ViInt16 average_rate, ViInt16 envelope);
ViStatus _VI_FUNC mxOX50x2_setCursors (ViSession instrSession, ViInt16 cursor,
					ViInt16 reference, ViReal64 t1, ViReal64 t2);
ViStatus _VI_FUNC mxOX50x2_runAutoset (ViSession instrumentHandle);
ViStatus _VI_FUNC mxOX50x2_runAcquisition (ViSession instrumentHandle, ViBoolean Run);
ViStatus _VI_FUNC mxOX50x2_readCursors (ViSession instrumentHandle, ViInt16 reference, ViPReal64 t1s,
					ViPReal64 t2s, ViPReal64 dTs, ViPReal64 v1v, ViPReal64 v2v, ViPReal64 dVv);
ViStatus _VI_FUNC mxOX50x2_readMeasurement (ViSession instrumentHandle, 
                    ViInt16 measurement, ViInt16 reference, ViPReal64 reading);
ViStatus _VI_FUNC mxOX50x2_readChToArr (ViSession instrumentHandle, ViInt16 source, ViReal64 waveformArray[],
                    ViPInt32 numberofsamples, ViPReal64 XStart, ViPReal64 XIncrement, ViPReal64 YIncrement); 
ViStatus _VI_FUNC mxOX50x2_readChToFile ( ViSession instrSession, ViInt16 channel,
					ViString filename, ViBoolean overwrite);
ViStatus _VI_FUNC mxOX50x2_readFileToArr (ViSession instrumentHandle, ViInt16 drives, ViString fileName,
					ViReal64 waveformArray[],
					ViPInt32 numberofsamples, ViPReal64 XStart, ViPReal64 XIncrement, ViPReal64 YIncrement);
ViStatus _VI_FUNC mxOX50x2_writeFileToMem (ViSession instrumentHandle, ViString fileName);
ViStatus _VI_FUNC mxOX50x2_saveSetup (ViSession instrumentHandle, ViBoolean mode, ViString fileName,
					ViBoolean overwriteFile);
ViStatus _VI_FUNC mxOX50x2_fileTransferToComputer (ViSession instrSession, ViString filename, ViBoolean overwrite);
ViStatus _VI_FUNC mxOX50x2_writeInstrData (ViSession instrumentHandle, ViString writeBuffer);
ViStatus _VI_FUNC mxOX50x2_readInstrData (ViSession instrumentHandle, ViInt32 numberBytesToRead, 
					ViChar readBuffer[], ViPInt32 numBytesRead);
ViStatus _VI_FUNC mxOX50x2_reset (ViSession instrumentHandle);
ViStatus _VI_FUNC mxOX50x2_selfTest (ViSession instrumentHandle, ViPInt16 selfTestResult, ViChar selfTestMessage[]);
ViStatus _VI_FUNC mxOX50x2_errorQuery (ViSession instrumentHandle, ViPInt32 errorCode, ViChar errorMessage[]);
ViStatus _VI_FUNC mxOX50x2_errorMessage (ViSession instrumentHandle, ViStatus errorCode, ViChar errorMessage[]);
ViStatus _VI_FUNC mxOX50x2_revisionQuery (ViSession instrumentHandle, ViChar instrumentDriverRevision[],
                    ViChar firmwareRevision[]);
ViStatus _VI_FUNC mxOX50x2_close (ViSession instrumentHandle);

ViStatus _VI_FUNC mxOX50x2_Meterconfig (ViSession instrumentHandle, ViInt16 Input, ViInt16 Measure, ViInt16 Coupling, 
					ViBoolean AutoRange, ViInt16 VoltRang, ViInt16 OhmRang, ViInt16 CapaRang);
ViStatus _VI_FUNC mxOX50x2_readMeterMeas (ViSession instrumentHandle, ViInt16 Reference, ViPReal64 Reading);


#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif

/*****************************************************************************/
/*=== END INCLUDE FILE ======================================================*/
/*****************************************************************************/

#endif
