s              h  @                                        gx1304      Metrix GX1304 Function Generator                   Instrument Name: GX1304 Function Generator

 Description:     This instrument module provides
                  programming support for the
                  GX1304.
                  The module is divided into the
                  following functions:

 Functions/Classes:

 (1) Initialize:
     Initialize the instrument and set to default
     configuration.

 (2) Configure : (Class)
     Provides functions to configure the Main and
     Auxiliary generators as well as the Amplitude
     and Frequency Modulation (Sub Classes).

 (3) Memory Operations : (Class)
     Provides functions to Save and Recall the
     instrument Setup (stored in the instrument)
     or to Transfer instrument Setup (checksum
     binary blocks).

 (4) Utility Functions: (Class)
     Provides lower level functions to communicate
     with the instrument, and change instrument
     parameters.

 (5) Close:
     Take the instrument offline.           Configure : (Class)
     Provides functions to configure the Main and
     Auxiliary generators as well as the Amplitude
     and Frequency Modulation (Sub Classes).
    J      Configure/ Amplitude Modulation : (Sub Class)
     Provides functions to configure the Amplitude
     Modulation.

     AM (Amplitude Modulation)
            Sets the following parameters:
            * function
            * modulation frequency
            * depth

     VCA (Voltage Controlled Amplitude)
            Sets the following parameters:
            * function
            * start amplitude
            * stop amplitude
            * sweep time

     Sum
            Sets the following parameters:
            * function
            * frequency
            * amplitude
          Configure/ Frequency Modulation : (Sub Class)
     Provides functions to configure the Frequency
     Modulation.

     FM (Frequency Modulation)
        Sets the following parameters:
        * function
        * modulation frequency
        * deviation

     VCF (Voltage Controlled Frequency)
        Sets the following parameters:
        * function
        * start frequency
        * stop frequency
        * sweep time           Memory Operations : (Class)
     Provides functions to Save and Recall the
     instrument Setup (stored in the instrument)
     or to Transfer instrument Setup (checksum
     binary blocks).

     Store & Recall Setup
        Saves or recalls the specified (1 to 51)
        instrument setup (stored in the
        instrument).

     Transfer Setup
        Allows complete instrument setup to be
        transferred rapidly to and from the PC
        to and from the controller in the form
        of checksummed binary blocks.    _     Class Name:    Utility Functions

 Description:   Provides lower level functions to
                communicate with the instrument,
                and change instrument parameters.

 Functions:

 (1) Write To Instrument:
     Writes commands and queries to the instrument
     to modify parameters and query device
     settings.

 (2) Read Instrument Data:
     Reads data from instrument buffer and returns
     it to the specified variable in memory.

 (3) Reset:
     This function resets the instrument to its
     default state.

 (4) Self Test:
     This function runs the instrument self test
     and returns the test code.

 (5) Error Query:
     This function reads an error code from the
     instrument error queue.

 (6) Revision Query:
     This function returns the revision numbers of
     the instrument driver and instrument
     firmware.         Panel Name:    Initialize

 Description:   Initializes the instrument in the
                following ways:

                - opens the instrument and sets
                  its GPIB address to the speci-
                  fied value

                - performs an identification query
                  on the instrument

                - sets the instrument to a default
                  configuration (See Note below)

                - returns an instrument ID which
                  is used to identify the
                  instrument in subsequent calls.


Note : Default Configuration

      Main gen : 10Khz 50% Sine 1Vpp Output off
      Aux gen  :  1Khz 50% Sine 1Vpp Output off
      All trigger and modulation menus cleared
    J     Control Name:  GPIB Address

 Description:   Specifies the address on the GPIB
                to be used to communicate
                with the instrument.  This value
                must correspond to the current
                internal setting of the
                instrument.

 Variable Type: Integer

 Valid Range:   0 to 30

 Default Value: 1

 NOTE:  The Default Value of this control should
        be set to the factory default of the
        instrument, however if your instrument's
        actual setting is different this control's
        default should be changed.         Control Name:  ID Query

 Description:   Specifies if an ID Query is sent
                to the instrument during the
                initialization procedure.

 Variable Type: Integer

 Valid Range:   0 - Skip Query
                1 - Do Query (Default)

 NOTE:  Under normal circumstances the ID Query
        ensures that the instrument initialized
        over the GPIB is the type supported by
        this driver.  However circumstances may
        arise where it is undesirable to send an
        ID Query to the instrument.  In those
        cases; set this control to "Skip Query"
        and this function will initialize the
        GPIB and the Command arrays in the driver,
        without doing an ID Query.         Control Name:  Reset Device

 Description:   Specifies if the instrument is to
                be reset to its power-on settings
                during the initialization
                procedure.

 Variable Type: Integer

 Valid Range:   0 - Don't Reset
                1 - Reset Device (Default)

 NOTE: If you do not want the instrument reset.
       Set this control to "Don't Reset" while
       initializing the instrument.    3    Control name    : ID Instrument

Description     : Returns an instrument ID that
                  is used in all subsequent
                  function calls to select the
                  instrument at the Address
                  specified.
                  If more than one instrument of
                  the same type is used,this value
                  will be used to differentiate
                  beetween them. The first
                  instrument initialized will be
                  assigned an Instrument ID of 1.

Variable Type   : Integer    
    
 Control Name:  Error Code

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   GPIB Address out of range
       -2   ID Query out of range
       -3   Reset Device out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      233   Error configuring GPIB address
      240   Instrument timed out    Y = =          GPIB Address                       =          ID Query                           =\         Reset Device                      B           ID Instrument                     }         Error code                         5   Do Query 1 Skip Query 0   Reset Device 1 Don't Reset 0    	            	                      Panel name : Main generator

      Description: Sets the following parameters:

                * function
                * frequency
                * amplitude
                * symmetry
                * offset
                * phase            Control label  : Function

    Description    : Specifies the output signal .

    Variable type  : integer

    Variable range : 0 to 8

                     0 : Main Out off
                     1 : Sine
                     2 : Triangle
                     3 : Square
                     4 : Offset
                     5 : Peak positive voltage
                     6 : Peak negative voltage
                     7 : Positive going pulse
                     8 : Negative going pulse

             Control label  : Frequency

    Description    : Specifies the frequency (Hz)

    Variable type  : real

    Variable range : 0.01 to 13 000 000.0

    1        Control label  : Amplitude

    Description    : Specifies the AC amplitude
                     in terms of peak to peak
                     voltage (V)

    Variable type  : real

    Variable range :

    0.002 to 20.0 emf for sine,triangle and square
    0.001 to 10.0 emf for unipolar waveform             Control label  : Symmetry

    Description    : Specifies the symmetry of
                     the main generator (%) .

    Variable type  : real

    Variable range : 5.0 to 95.0
             Control label  : Offset

    Description    : Specifies the DC offset of
                     the main generator (emf V) .

    Variable type  : real

    Variable range : -10.0 to +10.0
             Control label  : Phase

    Description    : Specifies the start phase of
                     the main generator () .

    Variable type  : real

    Variable range : - 360.0 to +360.0
    y    Control Name    : ID instrument

Description     : Accepts the instrument ID
                  returned by the Initialize
                  fonction to select the desired
                  instrument.

Valid Range     : 1 to Maximum Instance of this
                  instrument.
                  The Maximum Instances of this
                  instrument is the maximum number
                  of instruments that can be
                  controlled by this driver in a
                  single system.The value is set
                  internally in the driver and is
                  typically 10.

Variable Type   : Integer
    k     Control Name:  Error Code

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   ID instrument out of range
       -2   Function out of range
       -3   Frequency out of range
       -4   Amplitude out of range
       -5   Symmetry out of range
       -6   DCO out off range
       -7   Phase out of range

      230   Error writing to instrument
      232   Instrument not initialized

      301    Peak amplitude out of range
      302    FM deviation >= main frequency
      303    FM deviation+main frequency >13 Mhz     - j         Function                            -          Frequency (Hz)                    ! -$         Amplitude (Vpp)                   " }          Symmetry                          # }$         DC Offset (V)                     $R }         Start/Stop Phase                  %  	          ID Instrument                     '         Error Code                                 	   GOff 0 Sine 1 Trian 2 Square 3 Offset 4 + pk 5 - pk 6 + puls 7 - puls 8    10000.0    1.0    50.0    0.0    0.0    1    	                      Panel name : Auxiliary generator

      Description: Sets the following parameters:

                * function
                * frequency
                * amplitude
                * symmetry             Control label  : Function

    Description    : Specifies the output signal .

    Variable type  : integer

    Variable range : 0 to 6

                     0 : Auxiliary Out off
                     1 : Sine
                     2 : Triangle
                     3 : Square
                     4 : Ramp
                     5 : Main Generator Frequency
                         Controlled Voltage (FCV)
                     6 : Main Generator Amplitude
                         Controlled Voltage (ACV)             Control label  : Frequency

    Description    : Specifies the frequency (Hz)

    Variable type  : real

    Variable range : 0.005 to 50 000.0
            Control label  : Amplitude

    Description    : Specifies the AC amplitude
                     in terms of peak to peak
                     voltage (V)

    Variable type  : real

    Variable range :

    0.002 to 20.0 emf for sine,triangle and square             Control label  : Symmetry

    Description    : Specifies the symmetry of
                     the auxiliary generator (%) .

    Variable type  : real

    Variable range : 5.0 to 95.0    y    Control Name    : ID instrument

Description     : Accepts the instrument ID
                  returned by the Initialize
                  fonction to select the desired
                  instrument.

Valid Range     : 1 to Maximum Instance of this
                  instrument.
                  The Maximum Instances of this
                  instrument is the maximum number
                  of instruments that can be
                  controlled by this driver in a
                  single system.The value is set
                  internally in the driver and is
                  typically 10.

Variable Type   : Integer
         Control Name:  Error Code

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   ID instrument out of range
       -2   Function out of range
       -3   Frequency out of range
       -4   Amplitude out of range
       -5   Symmetry out of range

      230   Error writing to instrument
      232   Instrument not initialized
    - - j         Function                          /  -          Frequency (Hz)                    / -$         Amplitude (Vpp)                   0 }          Symetry                           1            ID Instrument                     4         Error Code                                    1Off 0 Sine 1 Trian 2 Square 3 Ramp 4 FCV 5 ACV 6    1000.0    1.0    50.0    1    	                      Panel name : AM (Amplitude Modulation)

      Description: Sets the following parameters:

                * function
                * modulation frequency
                * depth            Control label  : Function

    Description    : Specifies the shape of the
                     modulating signal (auxiliary
                     generator).

    Variable type  : integer

    Variable range : 0 to 4

                     0 : AM off
                     1 : Sine
                     2 : Triangle
                     3 : Square
                     4 : Ext Signal             Control label  : Mod Freq (Hz)

    Description    : Specifies the Modulation
                     frequency (Hz) .

    Variable type  : real

    Variable range : 0.005 to 50 000.0
             Control label  : Depth

    Description    : Specifies the Amplitude Modu-
                     lation frequency .

    Variable type  : real

    Variable range : 0.0 to 99.0
    y    Control Name    : ID instrument

Description     : Accepts the instrument ID
                  returned by the Initialize
                  fonction to select the desired
                  instrument.

Valid Range     : 1 to Maximum Instance of this
                  instrument.
                  The Maximum Instances of this
                  instrument is the maximum number
                  of instruments that can be
                  controlled by this driver in a
                  single system.The value is set
                  internally in the driver and is
                  typically 10.

Variable Type   : Integer
         Control Name:  Error Code

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   ID instrument out of range
       -2   Function out of range
       -3   Frequency out of range
       -4   Depth out of range

      230   Error writing to instrument
      232   Instrument not initialized    80 - j         Function                          9 -          Mod freq (Hz)                     : }          AM Depth (%)                      ;>            ID Instrument                     =         Error Code                                    $Off 0 Sine 1 Trian 2 Square 3 Ext 4    100.0    50.0    1    	                      Panel name : VCA
                   (Voltage Controlled Amplitude)

      Description: Sets the following parameters:

                * function
                * start amplitude
                * stop amplitude
                * sweep time
            Control label  : Function

    Description    : Specifies the signal (inter-
                     nal or external) and the law
                     which controls the main gene-
                     rator amplitude .

    Variable type  : integer

    Variable range : 0 to 4

                     0 : VCA off
                     1 : Int Lin
                     2 : Int Log
                     3 : Ext Lin
                     4 : Ext Log             Control label  : Start Amplitude

    Description    : Specifies the Start amplitude
                     of the main output in terms
                     of peak to peak voltage (V).

    Variable type  : real

    Variable range : 0.002 to 20.0             Control label  : Stop Amplitude

    Description    : Specifies the Stop amplitude
                     of the main output in terms
                     of peak to peak voltage (V).

    Variable type  : real

    Variable range : 0.002 to 20.0             Control label  : Sweep Time (S)

    Description    : Specifies the sweep time
                     of the VCA mode .

    Variable type  : real

    Variable range : 20E-06 to 200.0    y    Control Name    : ID instrument

Description     : Accepts the instrument ID
                  returned by the Initialize
                  fonction to select the desired
                  instrument.

Valid Range     : 1 to Maximum Instance of this
                  instrument.
                  The Maximum Instances of this
                  instrument is the maximum number
                  of instruments that can be
                  controlled by this driver in a
                  single system.The value is set
                  internally in the driver and is
                  typically 10.

Variable Type   : Integer
         Control Name:  Error Code

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   ID instrument out of range
       -2   Function out of range
       -3   Start voltage out of range
       -4   Stop voltage out of range
       -5   Sweep time out of range

      230   Error writing to instrument
      232   Instrument not initialized

      301   VCA stop/VCA start ratio out of range    A - c         Function                          Co -          Start Ampl (V)                    Ds -$         Stop Ampl (V)                     Eu }          Sweep Time (S)                    F9            ID Instrument                     H         Error Code                                    .Off 0 Int lin 1 Int Log 2 Ext lin 3 Ext log 4    1.00    5.00    1.0    1    	                      Panel name : Sum

      Description: Sets the following parameters:

                * function
                * frequency
                * amplitude

    \        Control label  : Function

    Description    : Specifies the signal added to
                     the main generator .

    Variable type  : integer

    Variable range : 0 to 4

                     0 : SUM off
                     1 : Sine
                     2 : Triangle
                     3 : Square
                     4 : External             Control label  : Mod freq (Hz)

    Description    : Specifies the frequency of
                     the signal added to the main
                     generator .

    Variable type  : real

    Variable range : 0.005 to 50 000.0             Control label  : Sum Ampl (Vpp)

    Description    : Specifies the amplitude of
                     the signal added to the main
                     generator .

    Variable type  : real

    Variable range : 0.002 to 20.0    y    Control Name    : ID instrument

Description     : Accepts the instrument ID
                  returned by the Initialize
                  fonction to select the desired
                  instrument.

Valid Range     : 1 to Maximum Instance of this
                  instrument.
                  The Maximum Instances of this
                  instrument is the maximum number
                  of instruments that can be
                  controlled by this driver in a
                  single system.The value is set
                  internally in the driver and is
                  typically 10.

Variable Type   : Integer
         Control Name:  Error Code

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   ID instrument out of range
       -2   Function out of range
       -3   Frequency out of range
       -4   Amplitude out of range

      230   Error writing to instrument
      232   Instrument not initialized

      301   Peak Amplitude out of range
            (Sum Vpp/2 + Main Vpp/2 +DCO < 10.0)    L - j         Function                          NU -          Mod freq (Hz)                     OH -$         SUM ampl (Vpp)                    P8            ID Instrument                     R         Error Code                                    $Off 0 Sine 1 Trian 2 Square 3 Ext 4    1.0    5.00    1    	                      Panel name : FM
                   (Frequency Modulation)

      Description: Sets the following parameters:

                * function
                * modulation frequency
                * deviation
            Control label  : Function

    Description    : Specifies the shape of the
                     modulating signal (auxiliary
                     generator).

    Variable type  : integer

    Variable range : 0 to 4

                     0 : FM off
                     1 : Sine
                     2 : Triangle
                     3 : Square
                     4 : Ext Signal             Control label  : Mod Freq (Hz)

    Description    : Specifies the Modulation
                     frequency (Hz) .

    Variable type  : real

    Variable range : 0.005 to 50 000.0
             Control label  : FM Deviation (Hz)

    Description    : Specifies the frequency
                     deviation .

    Variable type  : real

    Variable range : 0.001 to 13 000 000.0
    y    Control Name    : ID instrument

Description     : Accepts the instrument ID
                  returned by the Initialize
                  fonction to select the desired
                  instrument.

Valid Range     : 1 to Maximum Instance of this
                  instrument.
                  The Maximum Instances of this
                  instrument is the maximum number
                  of instruments that can be
                  controlled by this driver in a
                  single system.The value is set
                  internally in the driver and is
                  typically 10.

Variable Type   : Integer
         Control Name:  Error Code

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   ID instrument out of range
       -2   Function out of range
       -3   Mode frequency out of range
       -4   FM deviation out of range

      230   Error writing to instrument
      232   Instrument not initialized

      301   FM deviation >= MAIN frequency
      302   FM deviation+main frequency >13 Mhz
    V - j         Function                          Xc -          Mod freq (Hz)                     Y( -$         FM deviation (Hz)                 Y            ID Instrument                     \p         Error Code                                    $Off 0 Sine 1 Trian 2 Square 3 Ext 4    1.0    1000.0    1    	                      Panel name : VCF
                   (Voltage Controlled Frequency)

      Description: Sets the following parameters:

                * function
                * start frequency
                * stop frequency
                * sweep time
            Control label  : Function

    Description    : Specifies the signal (inter-
                     nal or external) and the law
                     which controls the main gene-
                     rator frequency .

    Variable type  : integer

    Variable range : 0 to 4

                     0 : VCF off
                     1 : Int Lin
                     2 : Int Log
                     3 : Ext Lin
                     4 : Ext Log             Control label  : Start Frequency (Hz)

    Description    : Specifies the Start frequency
                     of the main output .

    Variable type  : real

    Variable range : 0.001 to 13000000.0             Control label  : Stop Frequency (Hz)

    Description    : Specifies the Stop frequency
                     of the main output .

    Variable type  : real

    Variable range : 0.001 to 13000000.0             Control label  : Sweep Time (S)

    Description    : Specifies the sweep time
                     of the VCF mode .

    Variable type  : real

    Variable range : 20E-06 to 200.0    y    Control Name    : ID instrument

Description     : Accepts the instrument ID
                  returned by the Initialize
                  fonction to select the desired
                  instrument.

Valid Range     : 1 to Maximum Instance of this
                  instrument.
                  The Maximum Instances of this
                  instrument is the maximum number
                  of instruments that can be
                  controlled by this driver in a
                  single system.The value is set
                  internally in the driver and is
                  typically 10.

Variable Type   : Integer
         Control Name:  Error Code

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   ID instrument out of range
       -2   Function out of range
       -3   Start frequency out of range
       -4   Stop frequency out of range
       -5   Sweep time out of range

      230   Error writing to instrument
      232   Instrument not initialized

      301   VCF stop/VCF start ratio out of range    ` - c         Function                          b -          Start Freq (Hz)                   c_ -$         Stop Freq (Hz)                    d3 }          Sweep Time (S)                    d            ID Instrument                     gx         Error Code                                    .Off 0 Int lin 1 Int Log 2 Ext lin 3 Ext log 4    1.00    10000.0    1.0    1    	                      Panel name : Store & Recall Setup

      Description: Saves or recalls the specified
                   (1 to 51) instrument setup
                   (stored in the instrument).
             Control label  : Function

    Description    : Saves or recalls the complete
                     instrument setup .

    Variable type  : integer

    Variable range : 0 to 1

                     0 : Save
                     1 : Recall             Control label  : Store Number

    Description    : Specifies the store or recall
                     number.

    Variable type  : integer

    Variable range : 1 to 51    y    Control Name    : ID instrument

Description     : Accepts the instrument ID
                  returned by the Initialize
                  fonction to select the desired
                  instrument.

Valid Range     : 1 to Maximum Instance of this
                  instrument.
                  The Maximum Instances of this
                  instrument is the maximum number
                  of instruments that can be
                  controlled by this driver in a
                  single system.The value is set
                  internally in the driver and is
                  typically 10.

Variable Type   : Integer
    e     Control Name:  Error Code

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   ID instrument out of range
       -2   Function out of range
       -3   Store number out of range

      230   Error writing to instrument
      232   Instrument not initialized    k - f         Function                          l -         Store Number                      m            ID Instrument                     p         Error Code                                    Store 0 Recall 1            2  1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8 9 9 10 10 11 11 12 12 13 13 14 14 15 15 16 16 17 17 18 18 19 19 20 20 21 21 22 22 23 23 24 24 25 25 26 26 27 27 28 28 29 29 30 30 31 31 32 32 33 33 34 34 35 35 36 36 37 37 38 38 39 39 40 40 41 41 42 42 43 43 44 44 45 45 46 46 47 47 48 48 49 49 50 50    1    	                     Panel name : Transfer Setup

      Description: Allows complete instrument
                   setup to be transferred rapidly
                   to and from the controller in
                   the form of checksummed binary
                   blocks .
                   The data is read from the
                   GX1304 by sending the STORE?
                   query with the required number
                   as the parameter . The response
                   to this query is the correspon-
                   ding STORE command with the
                   store number parameter and the
                   binary block with its length
                   declaration header .

                   i.e. the response to STORE? 2
                   is STORE2,#3386<binary data>LF-
                   with END-

                   The response is stored in the
                   specified file and returned to
                   the instrument as later requi-
                   red . Note that the binary data
                   contains a checksum and should
                   not be modified , but the store
                   number may be altered as requi-
                   red .

        With the large number of stores available
        in th GX1304 , many test steps may be
        downloaded from a configuration file by
        the controller in advance , with the
        actual test sequence consisting simply of
        Writing commands . This minimizes bus
        traffic and maximises responses speed
        during the test .            Control label  : Function

    Description    : Allows a complete instrument
                     setup to be transferred rapi-
                     dly to or from the controller
                     in the form of checksummed
                     binary blocks .

    Variable type  : integer

    Variable range : 0 to 1

                     0 : Read to file
                     1 : Write from file            Control label  : Store number

    Description    : In reading mode it specifies
                     the store number of the setup
                     instrument to be red .

                     In writing mode , the store
                     number is not used (See Panel
                     Help for more explanations).

    Variable type  : integer

    Variable range : 1 to 50
             Control label  : Filename

    Description    : Specifies the filename to be
                     red (Write from file) or
                     written (Read to file) .

    Variable type  : String

    y    Control Name    : ID instrument

Description     : Accepts the instrument ID
                  returned by the Initialize
                  fonction to select the desired
                  instrument.

Valid Range     : 1 to Maximum Instance of this
                  instrument.
                  The Maximum Instances of this
                  instrument is the maximum number
                  of instruments that can be
                  controlled by this driver in a
                  single system.The value is set
                  internally in the driver and is
                  typically 10.

Variable Type   : Integer
         Control Name:  Error Code

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   ID instrument out of range
       -2   Function out of range
       -3   Store number out of range

      228   Error writing to instrument from file
      229   Error reading from instrument to file
      230   GPIB write error
      232   Instrument not initialized

      301   Error on opening file
      302   Bad file size ( <> 387 or 388)    y - g         Function                          {\ -         Store Number                      | }          Filename                          }            ID Instrument                     C         Error Code                       /3                                                       Read 0 Write 1            2  1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8 9 9 10 10 11 11 12 12 13 13 14 14 15 15 16 16 17 17 18 18 19 19 20 20 21 21 22 22 23 23 24 24 25 25 26 26 27 27 28 28 29 29 30 30 31 31 32 32 33 33 34 34 35 35 36 36 37 37 38 38 39 39 40 40 41 41 42 42 43 43 44 44 45 45 46 46 47 47 48 48 49 49 50 50    "C:\\SETUP1.DAT"    1    	            (Read function only)         Panel Name:    Write To Instrument

 Description:   Writes commands and queries to the
                instrument to modify parameters
                and query device settings.    [     Control Name:  Write Buffer

 Description:   The user can use this control to
                send common commands and queries
                to the instrument. This control
                can also be used to write any
                valid command to the instrument.

 Variable Type: String (char *)

 Default Value: "*RST"

 NOTES: (1) The command or query to be sent to the
            instrument may be a literal enclosed
            in double quotes i.e. "*RST" or may be
            contained in a variable of type
            string.

        (2) If the number of bytes to be written
            is greater than the size of "cmd" in
            the source code then the size of cmd
            must be increased. The original size
            of cmd is 50 bytes (cmd[50]) the
            largest cmd may be declared as is
            32,767 bytes.    k     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.

 Default Value: 1         Control Name:  Error Code

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range

      230   Error writing to instrument
      232   Instrument not initialized     M          Write Buffer                      8            Instrument ID                              Error Code                         "*RST"    1    	                Panel Name:    Read Instrument Data

 Description:   Reads data from instrument buffer
                and returns it to the specified
                variable in memory.

 NOTES: (1) Because the instrument may return both
            numeric and text data in response to
            queries this function returns the data
            in string format.

        (2) If valid data is NOT available at the
            instrument's output buffer when this
            function is called the instrument will
            hang up and the function will not
            return until it times out.  If the
            time-out is disabled this function
            will hang indefinitely and it may be
            neccessary to reboot the computer to
            break out.         Control Name:  Number of Bytes to Read

 Description:   The number of bytes specified by
                this control should be greater
                than or equal to the number of
                bytes which are to be read from
                the instrument. If the actual
                number of bytes to be read is
                greater than the number this
                control specifies then multiple
                reads will be necessary to empty
                the instrument's output buffer.

                If the instrument's output buffer
                is not emptied the instrument may
                return invalid data when future
                reads are performed.

 Variable Type: Integer

 Default Value: 50 (See NOTE 2)

 NOTES: (1) If NO DATA is available at the
            instrument's output buffer when this
            function is called the instrument will
            hang up and the function will not
            return until it times out.  If the
            time-out is disabled, this function
            will hang indefinitely and it may be
            necessary to reboot the computer.

        (2) If the number of bytes expected is
            greater than 50 the value of this
            control may be increased. If the
            actual number of bytes read is larger
            than the declared size of the read
            buffer a run-time error will be
            generated.         Control Name:  Read Buffer

 Description:   The incoming data from the
                instrument is placed into this
                variable.

 Variable Type: String (char *)

 NOTES: (1) Because the Instrument may return both
            numeric and text data in response to
            queries this function returns the data
            in string form.

        (2) This function does not overwrite any
            old data left in the string variable
            from the last time the function was
            called. String data in LabWindows is
            terminated with an ASCII null(Hex 0)
            and string manipulation functions will
            only recognize data before the ASCII
            null.

        (3) The declared size of the string
            variable must be greater than the
            actual number of bytes read from the
            instrument if it is not a run-time
            error will be generated.         Control Name:  Number of Bytes Read

 Description:   This variable contains the actual
                number of bytes read from the
                instrument. This is the value
                which is returned by ibrd in the
                global variable ibcnt.

 Variable Type: Integer *

 NOTE: If the actual number of bytes read is less
       than the number of bytes specified in
       number of bytes to read then the output
       buffer is probably empty. If the number of
       bytes read is 0 and the instrument returns
       a 231 error code the read function failed.
       The most probable cause for the read to
       fail is because there was no data available
       at the instrument's output buffer.    k     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.

 Default Value: 1         Control Name:  Error Code

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range

      231   Error reading from instrument
      232   Instrument not initialized     M K         Number Bytes To Read              ; M          Read Buffer                        Mx         NumBytes Read                                 Instrument ID                     I         Error Code                         50    	            	            1    	            r     Panel Name:    Reset

 Description:   This function resets the
                instrument to its default state.    k     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.

 Default Value: 1    !     Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range

      230   Error writing to instrument
      232   Instrument not initialized    "            Instrument ID                              Error Code                         1    	                 Panel Name:    Self Test

 Description:   This function runs the
                instrument's self test routine and
                returns the test result(s).          Control Name:  Pass/Fail Code

 Description:   This is the value returned by the
                self test.  Zero means success.
                For any other code, see the
                Device's operator's manual.

 Variable Type: Integer *         Control Name:  Self Test Message

 Description:   This is the string returned by the
                self test. See the device's
                operation manual for an
                explanation of the string's
                contents.

 Variable Type: String (char *)    k     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.

 Default Value: 1         Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range

      226   Error polling instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      239   Error configuring time out
      240   Instrument timed out     = |         Pass/Fail Code                     =@         Self-Test Message                             Instrument ID                     n         Error Code                         	           	            1    	                 Panel Name:    Revision Query

 Description:   This function returns the revision
                numbers of the instrument driver
                and instrument firmware.          Control Name:  Driver Revision

 Description:   This control returns the
                Instrument Driver Revision.

 Variable Type: String (char *)          Control Name:  Instrument Firmware Revision

 Description:   This control returns the
                Instrument's Firmware Revision.

 Variable Type: String (char *)    k     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.

 Default Value: 1    ~     Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response     = |         Driver Revision                    =@         Firmware Revision                 e            Instrument ID                              Error Code                         	            	            1    	                    Function name : Close

    Description   : Close the instrument module
                    and place the instrument in
                    local mode .
    y    Control Name    : ID instrument

Description     : Accepts the instrument ID
                  returned by the Initialize
                  fonction to select the desired
                  instrument.

Valid Range     : 1 to Maximum Instance of this
                  instrument.
                  The Maximum Instances of this
                  instrument is the maximum number
                  of instruments that can be
                  controlled by this driver in a
                  single system.The value is set
                  internally in the driver and is
                  typically 10.

Variable Type   : Integer
    c     Control Name:  Error Code

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range

      221   Unable to close instrument
      232   Instrument not initialized
      234   Error in placing instrument in local
            mode.                ID Instrument                              Error Code                         1    	                  h       K.    init                                       *     K.    maing                                    ,F  5     K.    auxg                                     7l  ?H     K.    am                                       @  J     K.    vca                                      LH  T     K.    sum                                      U  ^b     K.    fm                                       _  ig     K.    vcf                                      k
  qr     K.    storecall                                s  W     K.    transfer                                        K.    write                                      p     K.    read                                            K.    reset                                    9  a     K.    self_test                                ^  ^     K.    revision_query                           [       K.    close                                                                       DInitialize                          +Configure                            DMain generator                       DAuxiliary generator                 Amplitude Modulation                 DAM                                   DVCA                                  DSum                                 /Frequency Modulation                 DFM                                   DSweep                               Memory Operations                    DStore & Recall Setup                 DTransfer Setup                      Utility Functions                    DWrite To Instrument                  DRead Instrument Data                 DReset                                DSelf-Test                            DRevision Query                       DClose                           