s         ߮                                              gx1010      Metrix GX1010 Function Generator                   Instrument Name: Metrix GX1010 10MHz
                  DDS Function Generator.

 Description:     This instrument module provides
                  programming support for the
                  GX1010.  The module is divided
                  into the following functions:

 Functions/Classes:

 (1) Initialize
     Initialize the instrument and optionally
     interrogate the ID and set to the specified
     reset conditions.

 (2) Configure...
     This class of functions configures the main
     generator and allows access
     to the Modulation capabilities of the GX1010.
        (1) Main Generator
            Set up such GX1010 Main Generator
            parameters as  output function,
            frequency and amplitude.
        (2) Modulation...
            This class of functions configures and
            controls the Modulation capabilities
            of the GX1010.
            (1) AM and VCA
                Amplitude Modulation.
            (2) Sweep
                Software controlled Frequency.
            (3) FSK
                Frequency shift keying
            (4) Hop
                Set up and run Hop mode
        (3) Trigger (Burst)
            Set up and control the Trigger
            capabilities of the GX1010.
        (4) Gate
            Set up and control the Trigger
            capabilities of the GX1010.
        (5) Set Status
            Configure the IEEE 488.2 status
            reporting capabilities of the GX1010.

 (3) Local Storage
     Executes the Store and Recall commands.

 (4) Get Status
     Returns the current value of the specified
     IEEE 488.2 status byte.

 (5) Miscellaneous
     This class of functions allows access to
     additional GX1010 remote control commands
     which is not available elsewhere in this
     driver. Also included are file operations.
        (1) Send Command String
        (2) Get Response String
        (3) File Operations
        (4) Arbitary
            This class of functions gives access
            to the arbitary waveform capabilities
            of the GX1010
            (1) New ARB
            (2) ARb Local storage
            (3) Define Staircase waveform

 (6) Close
     Take the instrument offline.          Class name:  Configure

  Description: This class of functions configures
               the main generator and allows
               access to the Modulation
               capabilities of the GX1010.

  Functions/class:

        (1) Main Generator
            Set up such GX1010 Main Generator
            parameters as  output function,
            frequency and amplitude.
        (2) Modulation...
            This class of functions configures and
            controls the Modulation capabilities
            of the GX1010.
            (1) AM and VCA
                Amplitude Modulation.
            (2) Sweep
                Sweeps the Frequency.
        (3) Trigger (Burst/Gate)
            Set up and control the Trigger and
            Gate capabilities of the GX1010.
        (5) Set Status
            Configure the IEEE 488.2 status
            reporting capabilities of the GX1010.
          Class name:  Configure

  Description: This class of functions configures
               and controls the Modulation
               capabilities of the GX1010.

  Functions/class:

            (1) AM and VCA
                Amplitude Modulation.
            (2) Sweep
                Software controlled Frequency.
            (3) FSK
                Frequency shift keying
            (4) Hop
                Set up and run Hop mode
          Class name:   Miscellaneous

  Description:  This class of functions allows
                access to additional GX1010 remote
                control commands which is not
                available elsewhere in this
                driver. Also included are file
                operations.

 Functions/classes:
     (1) Send Command String
     (2) Get Response String
     (3) File Operations
     (4) Arbitary
            This class of functions gives access
            to the arbitary waveform capabilities
            of the GX1010
            (1) New ARB
            (2) ARb Local storage
            (3) Define Staircase waveform


          Class name:   Arbitary

  Description:  This class of functions gives
                access to the arbitary waveform
                capabilities of the GX1010
                 (1) New ARB
                 (2) ARb Local storage
                 (3) Define Staircase waveform


    P     Panel Name:    Initialize

 Description:   Initializes the instrument in the
                following ways:

                - opens the instrument and sets
                  its GPIB address to the speci-
                  fied value

                - optionally performs an
                  identification query on the
                  instrument

                - optionally sets the instrument
                  to a default configuration

                - returns an instrument ID which
                  is used to identify the
                  instrument in subsequent calls.    _     Control Name:  Address

 Description:   Specifies the address on the
                GPIB to be used to communicate
                with the instrument.  This value
                must correspond to the current
                internal setting of the
                instrument.

 Variable Type: Integer

 Valid Range:   0 to 30

 Default Value: 5    
     Control Name:  Instrument ID

 Description:   Returns an Instrument ID that is
                used in all subsequent function
                calls to select the instrument at
                the Address specified.

                If more than one instrument of the
                same type is used, this value will
                be used to differentiate between
                them. The first instrument
                initialized will be assigned an
                Instrument ID of 1.

 Variable Type: Integer         Control Name:  ID Query

 Description:   Specifies if an ID Query is sent
                to the instrument during the
                initialization procedure.

 Variable Type: Integer

 Valid Range:   1 = Yes
                0 = No

 Default Value: 1 - Yes

 NOTE:  Under normal circumstances the ID Query
        insures that the instrument initialized
        over the GPIB is the type supported by
        this driver. However circumstances may
        arise where it is undesirable to send an
        ID Query to the instrument. In those
        cases; set this control to Skip Query
        and this function will initialize the
        GPIB and the Command arrays in the driver,
        without doing an ID Query.         Control Name:  Reset

 Description:   Specifies if the instrument is to
                be reset during the initialization
                procedure.

 Variable Type: Integer

 Valid Range:   0 = No Reset
                1 = Reset device

 Default Value: 1 = Reset

 NOTE: If you do not want the instrument reset.
       Set this control to No Reset while
       initializing the instrument.    u     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   GPIB Address out of range
       -2   ID Query out of range
       -3   Reset Device out of range

      220   Unable to open instrument
      221   Unable to close instrument
      223   Instrument identification query failed
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      240   Instrument timed out     - g           Address                            -          Instrument ID                        `          ID Query                           $          Reset Device                      n          Error                                                                       6                                            5    	           Do Query 1 Skip Query 0   Yes 1 No 0    	            )Instrument driver version 2.0 March 1996    Copyright (c) TTi Ltd.   X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.                  Instrument ID                      1   8     Panel Name:    Main Generator

 Description:   Sets up Function, Frequency,
                Peak-Peak Output level and Output
                status for the Main Generator.
                Secondary functions are provided
                to set DC Offset, Symmetry, Phase
                and output impedance.         Control Name:  Function

 Description:   Specifies the output waveform
                function.

 Variable Type: Integer

 Valid Range:   0 = Sine
                1 = Triangle
                2 = Square
                3 = Positive Pulse
                4 = Negative Pulse
                5 = Positive Ramp
                6 = Negative Ramp
                7 = Staircase
                8 = ARB
                9 = Noise

 Default Value: 0 - Sine          Control Name:  Frequency

 Description:   The output Frequency expressed in
                Hz.

 Variable Type: double

 Valid Range:   1e-4 to 10e+6 (0.1mHz to 10MHz)

 Default Value: 10kHz    I     Control Name:  Pk-Pk Output

 Description:   Specifies the output level as a
                peak to peak EMF value expressed
                in Volts.

 Variable Type: double

 Valid Range:   Waveform function dependent. See
                GX1010 instruction manual for more
                information.

 Default Value: 20V          Control Name:  Output

 Description:   Turns the Main output on or off.

 Variable Type: Integer

 Valid Range:   1 = On
                0 = Off

 Default Value: 1 - On          Control Name:  Sense

 Description:   Sets the output sense to NORMAL or
                INVERTed.

 Variable Type: Integer

 Valid Range:   1 = Invert
                0 = Normal

 Default Value: 0    i     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Function value out of range
       -3   Output value out of range
       -4   Frequency value out of range
       -5   DC offset value out of range
       -6   Symmetry value out of range
       -7   Phase value out of range
       -8   Zout value out of range
       -9   Sense value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    $  L           Function                          &  u         Frequency (Hz)                    'X           Pk-Pk Output (V)                  ( V          Output                            )\            Sense                             *,  P         Error                                      
   cSine 0 Triangle 1 Square 2 Pos Pulse 3 Neg Pulse 4 Pos Ramp 5 Neg Ramp 6 Staircase 7 ARB 8 Noise 9    10000    20    On 1 Off 0    Invert 1 Normal 0    	                 Control Name:  DC Offset

 Description:   Sets the output Offset voltage as
                an EMF value expressed in Volts

 Variable Type: double

 Valid Range:   -10 to +10

 Default Value: 0.0    .            DC Offset (V)                      0.0   y     Control Name:  Symmetry

 Description:   Sets the output Symmetry as a
                percentage.

 Variable Type: double

 Valid Range:   0.1% to 99.9%

 Default Value: 50.0%

  Note: The symmetry can always be specified over
  the range specified above but some waveform
  functions impose temporary limit of their own,
  see the instruction manual for more information.
    /            Symmetry (%)                       50.0         Control Name:  Zout

 Description:   Set the output impedance.

 Variable Type: Integer

 Valid Range:   1 = 600 Ohms
                0 =  50 Ohms

 Default Value: 0    1T             Zout                               600 Ohm 1 50 Ohm 0         Control Name:  Phase

 Description:   Sets the Start/Stop Phase
                parameter expressed in degrees.

 Variable Type: integer

 Valid Range:   -360 to +360

 Default Value: 0    2O             Phase (deg)                        0         Panel Name:    AM and VCA

 Description:   Enables AM and sets up Waveform,
                Modulation Depth and Frequency.
                If the modulation source is
                external VCA mode is selected.    :     Control Name:  Enable

 Description:   Sets the status of AM.

 Variable Type: Integer

 Valid Range:
                0 = Off
                1 = On
                2 = On and configure

 Default Value: 0 - Off

 Note: If set to ON or OFF all other controls
 are ignored, to use these you must use
 On + config.         Control Name:  Waveform

 Description:   Selects the modulation waveform.

 Variable Type: Integer

 Valid Range:   0 = Sine  (1kHz)
                1 = Square
                2 = External (VCA mode)

 Default Value: 1

 Note: If sinewave modulation is selected The
 Modulation frequency (TGEN) will be fixed to
 1kHz. Otherwise the TGEN will be left free for
 other modes. Selecting sinewave causes the Mod
 frequency control to be ignored.    A     Control Name:  Mod Depth

 Description:   Sets the Depth of modulation
                expressed as a percentage of the
                carrier. This parameter has no
                effect if the modulation Waveform
                is External.

 Variable Type: integer

 Valid Range:   0% to 100%

 Default Value: 30         Control Name:  Mod Frequency

 Description:   Sets the internal modulation
                frequency in Hz.This parameter has
                no effect if the modulation
                Waveform is External.
                Note. This parameter is actually
                the internal Trigger generator
                frequency.

 Variable Type: double

 Valid Range:   5e-3 to 50e+3 (5mHz to 50kHz)

 Default Value: 1000

 Note: The internal trigger generator period has
 a setting resolution of 20us max. This
 driver converts the requested frequency to a
 period value and sends the resulting number to
 the GX1010. This may cause a warning that the
 20us resolution has been exceeded. This can
 usually be ignored.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Enable value out of range
       -3   Waveform value out of range
       -4   Mod depth value out of range
       -5   Frequency value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    4. M a          Enable                            5p M           Waveform                          74 M          Mod Depth (%)                     8} M         Mod Frequency (Hz)                ;X             Instrument ID                     =          Error                                         Off 0 On 1 On + config 2               &Square 1 Sine (1kHz) 0 External VCA 2    30    1000    1    	                 Panel Name:    Sweep

 Description:   Enables Sweep (Software Controlled
                Frequency) and sets up the Mode,
                Start and Stop Frequencies and the
                sweep time.    =     Control Name:  Enable

 Description:   Sets the status of Sweep.

 Variable Type: Integer

 Valid Range:
                0 = Off
                1 = On
                2 = On and configure

 Default Value: 0 - Off

 Note: If set to ON or OFF all other controls
 are ignored, to use these you must use
 On + config.          Control Name:  Start Frequency

 Description:   The Sweep Start Frequency
                expressed in Hz.

 Variable Type: double

 Valid Range:   1e-4 to 10e+6 (0.1mHz to 10MHz)

 Default Value: none          Control Name:  Stop Frequency

 Description:   The Sweep Stop Frequency
                expressed in Hz.

 Variable Type: double

 Valid Range:   1e-4 to 10e+6 (0.1mHz to 10MHz)

 Default Value: none    H     Control Name:  Mode

 Description:   Sets the Sweep mode.

 Variable Type: Integer

 Valid Range:   1 = Start - Stop
                0 = Stop - Start

 Default Value: 1 - Start - Stop

 Note: Setting this control to 1 will cause the
 sweep to go from the Start frequency to the Stop
 frequency. 0 will reverse the direction.
          Control Name:  Law

 Description:   Sets the Sweep Law.

 Variable Type: Integer

 Valid Range:   0 = Linear
                1 = Logarithmic

 Default Value: 0 - linear
          Control Name:  Trigger Source

 Description:   Sets the Sweep Trigger source.

 Variable Type: Integer

 Valid Range:   0 = Continuous
                1 = Man/Remote
                2 = External

 Default Value: 0 - Continuous
          Control Name:  Time

 Description:   Specifies the internal Sweep ramp
                time in seconds.

 Variable Type: double

 Valid Range:   10e-3 to 999

 Default Value: none         Control Name:  Marker A

 Description:   The Frequency for Marker A
                expressed in Hz.

 Variable Type: double

 Valid Range:   1e-4 to 10e+6 (0.1mHz to 10MHz)

 Default Value: none

 Note: This is the Marker frequency set on the
 sweep menu.          Control Name:  Marker B

 Description:   The Frequency for Marker B
                expressed in Hz.

 Variable Type: double

 Valid Range:   1e-4 to 10e+6 (0.1mHz to 10MHz)

 Default Value: none

 Note: This is the Main generator frequency.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Enable value out of range
       -3   Mode value out of range
       -4   Law value out of range
       -5   Time value out of range
       -6   Start frequency value out of range
       -7   Stop frequency value out of range
       -8   Trigger source value out of range
       -9   Marker A frequency value out of range
      -10   Marker B frequency value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    B   o          Enable                            Ce           Start frequency (Hz)              D9 j         Stop frequency (Hz)               E m           Mode                              F[ m           Law                               G mA          Trigger Source                    G mj         Time (sec)                        H   	        Marker A                          I          Marker B                          J             Instrument ID                     M"          Error                                         Off 0 On 1 On + config 2           Start - Stop 1 Stop - Start 0    Log 1 Lin 0               %Continuous 0 Man/Remote 1 External 2                1    	            I     Panel Name:    FSK

 Description:   Enables FSK and sets up parameters    ;     Control Name:  Enable

 Description:   Sets the status of FSK.

 Variable Type: Integer

 Valid Range:
                0 = Off
                1 = On
                2 = On and configure

 Default Value: 0 - Off

 Note: If set to ON or OFF all other controls
 are ignored, to use these you must use
 On + config.          Control Name:  Trigger Source

 Description:   Sets the FSK Trigger source.

 Variable Type: Integer

 Valid Range:   0 = Internal
                1 = Man/Remote
                2 = External

 Default Value: 0 - Internal
          Control Name:  Frequency A

 Description:   FSK frequency A, actually
                the main generator frequency,
                expressed in Hz.

 Variable Type: double

 Valid Range:   1e-4 to 10e+6 (0.1mHz to 10MHz)

 Default Value: none    x     Control Name:  Internal Generator

 Description:   Sets the internal trigger
                frequency in Hz.
                Note. This parameter is actually
                the internal Trigger generator
                frequency (TGEN).

 Variable Type: double

 Valid Range:   5e-3 to 50e+3 (5mHz to 50kHz)

 Default Value: 1000

 Note: The internal trigger generator period has
 a setting resolution of 20us max. This
 driver converts the requested frequency to a
 period value and sends the resulting number to
 the GX1010. This may cause a warning that the
 20us resolution has been exceeded. This can
 usually be ignored.          Control Name:  Stop Frequency

 Description:   FSK frequency B expressed in Hz.

 Variable Type: double

 Valid Range:   1e-4 to 10e+6 (0.1mHz to 10MHz)

 Default Value: none    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Enable value out of range
       -3   Trigger Source value out of range
       -4   FSK frequency A value out of range
       -5   FSK frequency B value out of range
       -6   Internal generator value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    S& = v          Enable                            Ti =          Trigger Source                    UQ =c         Frequency A                       VO           Internal Generator                X c         Frequency B                       Y             Instrument ID                     [          Error                                         Off 0 On 1 On + config 2               #Internal 0 Man/Remote 1 External 2        1000        1    	           E     Panel Name:    Hop

 Description:   Enables HOP or sets up
                Parameters for each step

 Note: To avoid possible bus lockouts you
 should not execute any other panels or functions
 from this driver (except the Send Trigger panel)
 while Hop is running. Always set enable to OFF
 and execute this pannel first.    _     Control Name:  Enable

 Description:   Sets the status/configuration of
                Hop.

 Variable Type: Integer

 Valid Range:
                0 = Off
                1 = On
                2 = Configure step

 Default Value: 2 - Configure step

 Note: If set to OFF all other controls
 are ignored, RUN uses only the Last step control,
 Config step uses all other controls.

 Note: To avoid possible bus lockouts you
 should not execute any other panels or functions
 from this driver (except the Send Trigger panel)
 while Hop is running. Always set enable to OFF
 and execute this pannel first.
          Control Name:  Step number

 Description:   The step to configure

 Variable Type: Integer

 Valid Range:   0 to 15

 Default Value: 0    0     Control Name:  Time

 Description:   The time for this step in seconds.
                0 and 1ms have special meanings,
                see below

 Variable Type: Double

 Valid Range:   0ms = Man/Remote
                1ms = External
                2ms to 65s = time duration

 Default Value: 1 sec          Control Name:  Last Step

 Description:   The last step in the sequence to
                execute.

 Variable Type: Integer

 Valid Range:   0 to 15

 Default Value: 1         Control Name:  Function

 Description:   Specifies the output waveform
                function.

 Variable Type: Integer

 Valid Range:   0 = Sine
                1 = Triangle
                2 = Square
                3 = Positive Pulse
                4 = Negative Pulse
                5 = Positive Ramp
                6 = Negative Ramp
                7 = Staircase
                8 = ARB

 Default Value: 0 - Sine          Control Name:  Frequency

 Description:   The output Frequency expressed in
                Hz.

 Variable Type: double

 Valid Range:   1e-4 to 10e+6 (0.1mHz to 10MHz)

 Default Value: 1kHz    I     Control Name:  Pk-Pk Output

 Description:   Specifies the output level as a
                peak to peak EMF value expressed
                in Volts.

 Variable Type: double

 Valid Range:   Waveform function dependent. See
                GX1010 instruction manual for more
                information.

 Default Value: 20V    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.          Control Name:  DC Offset

 Description:   Sets the output Offset voltage as
                an EMF value expressed in Volts

 Variable Type: double

 Valid Range:   -10 to +10

 Default Value: 0.0    $     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Enable value out of range
       -3   Step value out of range
       -4   frequency value out of range
       -5   DC offset value out of range
       -6   Last step value out of range
       -7   time value out of range
       -8   Function vaqlue out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out

 Note: To avoid possible bus lockouts you
 should not execute any other panels or functions
 from this driver (except the Send Trigger panel)
 while Hop is running. Always set enable to OFF
 and execute this pannel first.    aB - Z          Enable                            c -           Step Number                       d: -         Time (sec)                        er -          Last Step                         f% m           Function                          g m         Frequency (Hz)                    h          Pk-Pk Output (V)                  i             Instrument ID                     lO          DC Offset (V)                     m          Error                                                                                                                             Off 0 Run 1 Config Step 2    0    1    1            	   [Sine 0 Triangle 1 Square 2 Pos Pulse 3 Neg Pulse 4 Pos Ramp 5 Neg Ramp 6 Staircase 7 ARB 8    1000    20    1    0.0    	            !----------Configuration---------    -----Run-----         Panel Name:    Trigger (Burst)

 Description:   This panel allows access to the
                Trigger function of the GX1010    ?     Control Name:  Enable

 Description:   Sets the status of Trigger.

 Variable Type: Integer

 Valid Range:
                0 = Off
                1 = On
                2 = On and configure

 Default Value: 0 - Off

 Note: If set to ON or OFF all other controls
 are ignored, to use these you must use
 On + config.          Control Name:  Trigger Source

 Description:   Sets the Trigger source.

 Variable Type: Integer

 Valid Range:   0 = Internal
                1 = Man/Remote
                2 = External

 Default Value: 0 - Internal
          Control Name:  Burst Count

 Description:   Sets the number of cycles of the
                main generator waveform in each
                burst.

 Variable Type: double

 Valid Range:   0.5 to 1023

 Default Value: 1.0    x     Control Name:  Internal Generator

 Description:   Sets the internal trigger
                frequency in Hz.
                Note. This parameter is actually
                the internal Trigger generator
                frequency (TGEN).

 Variable Type: double

 Valid Range:   5e-3 to 50e+3 (5mHz to 50kHz)

 Default Value: 1000

 Note: The internal trigger generator period has
 a setting resolution of 20us max. This
 driver converts the requested frequency to a
 period value and sends the resulting number to
 the GX1010. This may cause a warning that the
 20us resolution has been exceeded. This can
 usually be ignored.          Control Name:  Phase

 Description:   Sets the Start/Stop Phase
                parameter expressed in degrees.

 Variable Type: integer

 Valid Range:   -360 to +360

 Default Value: 0    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    
     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Enable value out of range
       -3   Trigger source value out of range
       -4   Burst count value out of range
       -5   Internal generator value out of range
       -6   Phase value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out
    tL = v          Enable                            u =          Trigger Source                    vw =c         Burst Count                       w_           Internal Generator                y c          Phase (deg)                       z             Instrument ID                     }          Error                                         Off 0 On 1 On + config 2               #Internal 0 Man/Remote 1 External 2    1    1000    0    1    	            u     Panel Name:    Gate

 Description:   This panel allows access to the
                Gating function of the GX1010    <     Control Name:  Enable

 Description:   Sets the status of Gate.

 Variable Type: Integer

 Valid Range:
                0 = Off
                1 = On
                2 = On and configure

 Default Value: 0 - Off

 Note: If set to ON or OFF all other controls
 are ignored, to use these you must use
 On + config.          Control Name:  Trigger Source

 Description:   Sets the Gating trigger source.

 Variable Type: Integer

 Valid Range:   0 = Internal
                1 = Man/Remote
                2 = External

 Default Value: 0 - Internal
    x     Control Name:  Internal Generator

 Description:   Sets the internal trigger
                frequency in Hz.
                Note. This parameter is actually
                the internal Trigger generator
                frequency (TGEN).

 Variable Type: double

 Valid Range:   5e-3 to 50e+3 (5mHz to 50kHz)

 Default Value: 1000

 Note: The internal trigger generator period has
 a setting resolution of 20us max. This
 driver converts the requested frequency to a
 period value and sends the resulting number to
 the GX1010. This may cause a warning that the
 20us resolution has been exceeded. This can
 usually be ignored.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Enable value out of range
       -3   Trigger source value out of range
       -4   Internal generator value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out
     ] v          Enable                             ]	          Trigger Source                     ]G         Internal Generator                1             Instrument ID                               Error                                         Off 0 On 1 On + config 2               #Internal 0 Man/Remote 1 External 2    1000    1    	               Panel name:     Status Reporting

Description:    Specify the way in which status is
                reported and Service Request is
                generated as defined in the IEEE
                488.2 standard.

                The function provides access to
                the three status enable registers
                in the GX1010, these are:

                Service Request Enable Register
                - Specifies which bits, when set,
                  in the Status Byte register will
                  generate a Service Request.

                Standard Event Enable Register
                - Specifies which bits, when set,
                  in the Standard Event Status
                  register will set the ESB bit in
                  the Status Byte Register.


                Parallel Poll Enable Register
                - Specifies which bits, when set,
                  in the Status Byte register will
                  be used to form the ist local
                  message

                See the IEEE 488.2 Standard and
                the instrument  instruction book
                for a full description of status
                reporting capabilities.    <    Control name:   Set Status Enable

Description:    Used to select which enable
                register will receive the byte
                value.

Variable type:  integer

Valid range:    0 = SRQ enable
                1 = Standard Event Enable
                2 = Parallel Poll

Default value   0 - SRQ Enable
         Control name:   Value

Description:    A byte value which will be written
                to the selected enable register.

Variable type:  integer

Valid range:    0 to 255

Default value:  0
    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Status Enable value out of range
       -3   Register Value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out     ]           Set Status Enable                  ]          Value                                          Instrument ID                               Error                                         +SRQ enable 0 Event Enable 1 Parallel Pol 2    0    1    	           d    Panel name:     Send Trigger

Description:    Send a trigger command to the
                GX1010. If MAN/REMOTE is selected
                as the trigger source for any
                active mode then that mode will be
                triggered by this command. If no
                modes are active then the command
                will be ignored.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Status Enable value out of range
       -3   Register Value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out                 Instrument ID                     x          Error                              1    	                Panel name:     Local Storage

Description:    Stores or Recalls the complete
                state of the GX1010 to or from
                local non-volatile memory.          Control Name:  Operation

 Description:   Selects the recall or store
                operation.

 Variable Type: Integer

 Valid Range:   0 = Recall
                1 = Store

 Default Value: 0 - Recall    W    Control name:   Store Number

Description:    Select the number of the store to
                Recall from or Store to.

Variable type:  integer

Valid range:    0 to 9

Default value:  1

 NOTE:  Store 0 is read only and contains the
 default parameters as used in the *RST command.
 Attempting to write to store 0 will generate an
 error.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Operation value out of range
       -3   Store Number out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    4 ]           Operation                         
 ]          Store Number                      i             Instrument ID                               Error                                         Recall 0 Store 1    1    1    	            x    Panel name:     Read Status

Description:    Returns the byte value from the
                selected status register.        Control name:   Read Status

Description:    Used to select which status
                register to read

Variable type:  integer

Valid range:    0 = Status Byte
                1 = Standard Event Status
                2 = SRQ enable
                3 = Standard Event Enable
                4 = Parallel Poll Enable
                5 = Execution Error

Default value   0 - Status Byte

         Control name:   Value

Description:    Returns the value read from the
                selected register.

Variable type:  integer    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Status Enable value out of range
       -3   Register Value out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      240   Instrument timed out     ]           Read Status                       m ]          Value                                          Instrument ID                     Y          Error                                         SStatus byte 0 Std Event 1 SRQ enable 2 Event Enable 3 Parallel Pol 4 Exeq. error 5    	            1    	                Panel name:     Send command string

Description:    Sends a string of bytes to the
                GX1010 from a string variable.         Control name:   Command String

Description:    This control specifies data to be
                sent to the GX1010. The absolute
                maximum length allowed is 200
                bytes.

Variable type:  String    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    3     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    % ]          Command                                        Instrument ID                     n          Error                                  1    	                Panel name:     Get response string

Description:    Reads a response from the GX1010
                into a string variable.        Control name:   Response Stirng

Description:    This control specifies a string
                variable to receive the response
                from the GX1010. The string must
                be long enough to receive the
                response to avoid overflow. To aid
                in checking this the number of
                bytes put into the string is
                returned from the function. The
                absolute maximum length allowed is
                2000 bytes.

Variable type:  String         Control name:   Number of Bytes

Description:    This value is the number of bytes
                returned by the GX1010 and
                placed in the string.

Variable type:  Integer    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    5     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range

      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out     ]          Response                           ]          Number Of Bytes                                Instrument ID                               Error                              	            	            1    	               Panel name:     File Operations

Description:    Send or Receive a binary block to
                or from the GX1010. The data will
                be read from or written to a file.

Note            This operation is usefull for
                LRN blocks.         Control Name:  Operation

 Description:   Selects to send a file to the
                GX1010 or Get a file from GX1010.

 Variable Type: Integer

 Valid Range:   0 = Send file to GX1010
                1 = Get file from GX1010

 Default Value: 0 - Send file         Control name:   File name

Description:    This control specifies file name
                from which the binary block will
                be sent to the GX1010.

Variable type:  String - max length 50 characters    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Operation value out of range

      228   Error writing to instrument from file
      229   Error reading from instrument to file
      232   Instrument not initialized
      240   Instrument timed out    ` ]           Operation                         n ]         File Name                         N             Instrument ID                               Error                                         Send File 0 Get File 1        1    	           1     Panel Name:    New ARB/STAIRCASE

 Description:   Allows a new arbitary
                or Staircase waveform to
                be downloaded to the GX1010. After
                downloading a new ARB should be
                saved to ARB Local storage to
                avoid it being overwritten.
    L    Control name:   File name

Description:    This control specifies file name
                from which the waveform data will
                be sent to the GX1010.

Variable type:  String - max length 50 characters

 Note; The file format will be as follows
    ARB
        SETARB followed by a space and then
        1024 integers comma delimited
        valid range -512 to +511
    Stair
        SETSTAIR followed by a space and then
        1 to 16 pairs of integers length,level
        comma delimited
        valid range length 0 to 1024
                    level  -512 to +511
    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Operation value out of range

      228   Error writing to instrument from file
      229   Error reading from instrument to file
      232   Instrument not initialized
      240   Instrument timed out    Ė ]          File Name                                      Instrument ID                     J          Error                                  1    	                 Panel Name:    ARB Local storage

 Description:   Allows ARB waveforms to be stored
                and recalled from local
                non-volatile memory. The current
                ARB is always the last recalled or
                downloaded.          Control Name:  Operation

 Description:   Selects the recall or store
                operation.

 Variable Type: Integer

 Valid Range:   0 = Recall
                1 = Store

 Default Value: 0 - Recall        Control name:   Store Number

Description:    Select the number of the store to
                Recall from or Store to.

Variable type:  integer

Valid range:    1 to max number of stores

Default value:  1

Note: the max number of stores will depend upon
the software level of the instrument V1.1 has 21.
However only the first 5 are writeable and an
error will result if writing is attempted above
this number.         Control name:   Name

Description:    The name to use for a store
                operatrion.

Variable type:  string - max length 16 characters
    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Operation value out of range
       -3   Store number illegal

      228   Error writing to instrument from file
      229   Error reading from instrument to file
      232   Instrument not initialized
      240   Instrument timed out    ̤ ]           Operation                         z ]          Store Number                      !           Name                              ϼ             Instrument ID                               Error                                         Recall 0 Store 1    1    "WAVE"    1    	                 Panel Name:    Close

 Description:   Closes the instrument and takes it
                off line.

 Note: The  instrument must  be reinitialized
       to use it again.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      221   Unable to close instrument
      232   Instrument not initialized                 Instrument ID                     :          Error                              1    	                  /       K.    init                                     #J    8                                       #  ,          config_main                       /Z    8    main_offset                       1    8    main_symmetry                     2  $ C ~   main_zout                         3   8    main_phase                               3M  ?     K.    config_am                                AM  O     K.    config_sweep                             R  ^     K.    fsk                                      _  pJ     K.    hop                                      s       K.    trig                                       S     K.    gate                                            K.    set_status                                      K.    send_trg                                   S     K.    loc_stores                               ]  F     K.    get_status                                      K.    snd_cmd                                  ]  W     K.    get_resp                                 T  N     K.    file_ops                                 ]       K.    new_arb                                  ˞       K.    arb_stores                               &  S     K.    close                                                                       DInitialize                          	5Configure                           \Main Generator                      Modulation                           DAM and VCA                           DSweep                                DFSK                                  DHop                                  DTrigger (Burst)                      DGate                                 DSet Status                           DSend Trigger                         DLocal Storage                        DGet Status                          Miscellaneous                        DSend command string                  DGet Response string                  DFile operations                     
Arbitary                             DNew ARB/STAIRCASE                    DARB Local storage                    DClose                           