s         r     m                                        AX3220H     Metrix AX3220                                     AX3220H series power supplies

This instrument module provides GPIB support for
the AX3220H series power supplies. Instruments in
this range meet the requirements of IEEE 488.2
standard. The module will be updated from time to
time as new instruments become available in the
range.

Instruments supported are:

AX3220H         Dual 32 volt, 2 amp, Quad mode

The module contains the following functions:

1. Initialise.

2. Configuration
        1. Set Mode
        2. Set Output
        3. Master Output control
        4. Status Reporting

3. Measurement and Status.
        1. Read Output
        2. Read Status

4.Local Storage.
        1. Store
        2. Recall

5. Close        Panel name:     Initialise

Description:

 Initialises the AX3220x in the following way

        - opens the instrument and sets the GPIB
        address to the specified value.

        - sends device clear and clear status
        commands.

        - queries the instrument to determine the
        type/model number.

        - optionally sets the instrument to its
        default state.

        - optionally performs a self test on the
        instrument.
                      Configuration Functions

These functions perform the complete set up of the
AX3220x power supply. The parameters are sent to
the instrument but the status is not checked so no
instrument errors will be reported. Status may be
read at any time with the read status function.
Available functions are listed below.

Set mode: Set the instrument to the required mode.

Set output: Set voltage, current, OVP, output
status and readback meter damping for each output.

Master output control: Set master output switch on
or off.

Status reporting: Specify the way in which status
is reported and Service Request is generated as
defined in the IEEE 488.2 standard.
        Panel name:     Set Mode

Description:

 Set the instrument to the required mode. Modes
 available are instrument dependant. Tracking is
 possible only between outputs which are
 internally isolated. The number of legal modes is
 instrument dependent.

 AX3220H Modes:

  Mode No.            Description
 ------------   ------------------------------
     0          Outputs 1 and 2 isolated.
                Outputs 1 and 2 may be set to
                tracking (Tracking A = 3).

      1         Outputs 1 and 2 series connected.
                Tracking not possible.

      2         Outputs 1 and 2 parallel
                connected.
                Tracking not possible.
        Panel name:     Set Output

Description:

 Set voltage, current, OVP, output status and
 readback meter damping for each output. The
 values which are legal depend on the instrument
 type and the Mode and Tracking specification.

 The output number is a common control which is
 used for all other functions which are secondary.

 The primary function set_op is a dummy and does
 not execute any code.

 The secondary function set_volts sets the voltage
 on the selected output.

 The secondary function set_current sets the
 current limit on the selected output.

 The secondary function set_ovp sets the over
 voltage limit on the selected output.

 The secondary function, set output status,
 specifies whether the output status of the
 specified output is on or off.

 The secondary function, set damping, specifies
 the reading meter damping for the voltage and
 current of the specified output.
     \    Panel name:     Master Output Control

Description:

 Set master output switch on or off.
    ,    Panel name:     Status Reporting

Description:

 Specify the way in which status is reported and
 Service Request is generated as defined in the
 IEEE 488.2 standard.

 The function provides access to the four status
 enable registers in the AX3220x power supply,
 these are:

 Service Request Enable Register

        - Specifies which bits, when set, in the
        Status Byte register will generate a
        Service Request.

 Standard Event Enable Register

        - Specifies which bits, when set, in the
        Standard Event Status register will set
        the ESB bit in the Status Byte Register.

 Limit Event Register

        - Specifies which bits, when set, in the
        Limit Event Status register will set the
        LIM bit in the Status Byte Register.

 Parallel Poll Enable Register

        - Specifies which bits, when set, in the
        Status Byte register will be used to form
        the ist local message

 See the IEEE 488.2 Standard and the instrument
 instruction book for a full description of status
 reporting capabilities.


    L                Measurement and Status

These functions allow the voltage and current to
be read on each output and the status registers to
be interrogated. Available functions are as
follows.

Read output: Reads the current and voltage from
the specified output.

Read status: Returns the byte value in the
selected status register.
        Panel name:     Read Output

Description:

 Returns the voltage and/or current from the
 selected output.

 The output number is a common control which is
 used for all other functions which are secondary.

 The primary function set_op is a dummy and does
 not execute any code.

 The secondary function read_volts returns the
 output voltage on the selected output.

 The secondary function read_current returns the
 current being drawn from the selected output.
     x    Panel name:     Read Status

Description:    Returns the byte value from the
                selected status register.                      Local Storage

These functions allow the instrument set up to be
stored or recalled from local non-volatile memory.

Store saves the set up to a store specified by the
user.

Recall gets a set up from a store specified by the
user and install it in the AX3220x.
         Panel name:     Store

Description:    Saves the complete state of the
                AX3220x to local non-volatile
                memory.     w    Panel name:     Recall

Description:    Recalls an instrument set up from
                a previous store operation.    -                 Miscelaneous

These functions allow commands to be sent and
responses to be received which are not covered by
other panels in the instrument driver.

Any commands may be sent as a string of bytes.

Responses are received as a string of bytes for
later interrogation by the user program.         Panel name:     Send command string

Description:    Sends a string of bytes to the
                AX3220x from a string variable.         Panel name:     Get response string

Description:    Reads a response from the AX3220x
                into a string variable.         Panel name:     Send block from file

Description:    Sends a binary block to the
                AX3220x from a disc file.

Note            This operation is usefull for
                Learn and Store blocks.         Panel name:     Get block to file

Description:    Gets a binary block from the
                AX2220x and writes it to a disc
                file.

Note            This operation is usefull for
                Learn and Store blocks.         Panel name:     Close

Description:    Takes the instrument off-line.
                The  instrument must  be
                reinitialized to use it again.    U    Control name:   GPIB Address

Description:    This control specifies the
                address used to communicate with
                the AX3220x power supply. It must
                correspond with the value set up
                at the instrument front panel.

Variable type:  Integer

Valid range:    0 to 30

Default value:  11

    `    Control name:   Set Defaults

Description:    When set to Yes the parameters
                in the instrument will be set to
                their default values. If set to No
                the instrument settings will not
                be changed.

Variable type:  Integer

Valid range:    No = 0 , Yes = Any non-zero value

Default value:  Yes         Control name:   Perform Self Test

Description:    Specifies if a self test should
                be performed or not. If the test
                is performed the returned value
                will be in the global variable
                AX3220H_err. A value of zero
                indicates that the test passed.
                See the Error control for a list
                of possible returned values.

Variable type:  Integer

Valid range:    No = 0 , Yes = Any non-zero value

Default value:  No
    V    Control nams:   Error

Description:

 This returned value is placed in the global
 variable AX3220H_err. The value zero indicates
 complete success.

    Error              Description
 ------------------------------------------------
       0     Success
      -1     GPIB Address out of range

     220     Unable to open instrument
     223     Device at specified address is not
             a AX3220x
     230     GPIB write error
     231     No response from instrument
     233     Unable to configure GPIB address
     300     Unable to configure board/device
             when attempting to set timeout to
             30sec or end message to on.
     311 - 374 Self test fail codes. Subtract 300
             and see the instrument instruction
             manual for a complete list of the
             fail codes.

Variable type:  Integer.    . = Y           GPIB Address                       =           Set Defaults                       =          Perform Self Test                 !          Error                              11   Yes 1 No 0    Yes 1 No 0            AX3220H_err        Control name:   Mode

Description:    Selects The required mode.

Variable type:  Integer

Valid range:    Instrument dependent
                (maximum is 0 to 13)

Default value:  0 (all outputs isolated)    B    Control name:   Trip Mode

Description:    Specifies the action to be taken
                when any output trips for any
                reason - ovp or temperature. When
                set to All then the complete
                instrument is shut down - the
                Master On/Off switch is set to
                Off. When set to Single then only
                the output which tripped is shut
                down - Output Status is set Off.

Variable type:  Integer

Valid range:    All = 0 , Single = any non-zero
                value.

Default value:  All
         Control name:   Tracking A

Description:    Selects one of two possible
                tracking specifications.

Variable type:  Integer

Valid range:    Instrument dependent - see manual

Default value:  0 - no tracking

    _    Control name:   Tracking B

Description:    Selects one of two possible
                tracking specifications. This
                value should be set to zero for
                all except quadruple output
                instruments.

Variable type:  Integer

Valid range:    Instrument dependent - see manual

Default value:  0 - no tracking

        Control name:   Error

Description:

 This returned value is placed in the global
 variable AX322H0_err. The value zero indicates
 complete success.


    Error              Description
 ------------------------------------------------
       0     Success
      -1     Mode number out of range
      -2     Tracking A value out of range
      -3     Tracking value B out of range

     230     GPIB write error
     231     No response from instrument
     232     Device not initialised

Variable type:  Integer.    &f - `          Mode                              '> -          Trip Mode                         ) } `         Tracking A                        *q  `         Tracking B                        +          Error                                         Isolated 0 Series 1 Parallel 2    Single 1 All 0               off 0 1 track 2 3               off 0            AX3220H_err   )    Control name:   Output Number

Description:    Indicates the output number to
                which the commands will be sent.

Variable type:  integer

Valid range:    min = 1 , max = number of outputs
                available for the particular
                instrument.

Default value   1
    /z  1           Output Number                                 1 1 2 2       Control name:   Error

Description:

 This returned value is placed in the global
 variable AX3220H_err. The value zero indicates
 complete success.


    Error              Description
 ------------------------------------------------
       0     Success
      -1     Output number out of range

     230     GPIB write error
     232     Device not initialised

Variable type:  Integer.    0           Error                                      AX3220H_err        Control name:   Voltage

Description:    The voltage value to which the
                specified output will be set. The
                value is expressed in Volts.

Variable type:  real

Valid range:    instrument dependent

        Control name:   Error

Description:

 This returned value is placed in the global
 variable AX3220H_err. The value zero indicates
 complete success.


    Error              Description
 ------------------------------------------------
       0     Success
      -1     Output number out of range

     230     GPIB write error
     232     Device not initialised

Variable type:  Integer.    2            Voltage                           3  s         Error                                          AX3220H_err        Control name:   Current

Description:    The current limit value to which
                the specified output will be set.
                The value is expressed in Amps.

Variable type:  real

Valid range:    instrument dependent


        Control name:   Error

Description:

 This returned value is placed in the global
 variable AX3220H_err. The value zero indicates
 complete success.


    Error              Description
 ------------------------------------------------
       0     Success
      -1     Output number out of range

     230     GPIB write error
     232     Device not initialised

Variable type:  Integer.    5            Current                           6  s         Error                                          AX3220H_err       Control name:   OVP

Description:    The over voltage protection value
                to which the specified output will
                be set. The value is expressed in
                Volts.

Variable type:  real

Valid range:    instrument dependent


        Control name:   Error

Description:

 This returned value is placed in the global
 variable AX3220H_err. The value zero indicates
 complete success.


    Error              Description
 ------------------------------------------------
       0     Success
      -1     Output number out of range

     230     GPIB write error
     232     Device not initialised

Variable type:  Integer.    8            OVP                               9  s         Error                                          AX3220H_err        Control name:   Output Status

Description:    Specifies the status of the
                specified output.

Variable type:  integer

Valid range:    Off = 0 , On = any non-zero value

default value:  Off

        Control name:   Error

Description:

 This returned value is placed in the global
 variable AX3220H_err. The value zero indicates
 complete success.


    Error              Description
 ------------------------------------------------
       0     Success
      -1     Output number out of range

     230     GPIB write error
     232     Device not initialised

Variable type:  Integer.    ;             Output Status                     <  e         Error                              On 1 Off 0            AX3220H_err       Control name:   Meter Damping

Description:    Specifies the dampimg applied to
                the readback metering of the
                selected output.

Variable type:  integer

Valid range:    On = 0 , Off = any non-zero
                value

default value:  Off

        Control name:   Error

Description:

 This returned value is placed in the global
 variable AX3220H_err. The value zero indicates
 complete success.


    Error              Description
 ------------------------------------------------
       0     Success
      -1     Output number out of range

     230     GPIB write error
     232     Device not initialised

Variable type:  Integer.    >             Meter Damping                     @  l         Error                              Off 1 On 0            AX3220H_err       Control name:   Master Output

Description:    Used to set the master output
                switch On or Off. When On The
                voltage on all outputs, which
                have their individual Output
                Status switches set to On, will
                appear at the output terminals of
                the instrument.

Variable type:  integer

Valid range:    Off = 0 , On = any non-zero value

default value:  Off
    ]    Control name:   Error

Description:

 This returned value is placed in the global
 variable AX3220H_err. The value zero indicates
 complete success.

    Error              Description
 ------------------------------------------------
       0     Success
     230     GPIB write error
     232     Device not initialised

Variable type:  Integer.    B* ]            Master Output                     C          Error                              ON 1 OFF 0            AX3220H_err        Control name:   Set Status Enable

Description:    Used to select which enable
                register will receive the byte
                value.

Variable type:  integer

Valid range:    min = 0 , max = 3

Default value   0 (SRQ Enable)

         Control name:   Value

Description:    A byte value which will be written
                to the selected enable register.

Variable type:  integer

Valid range:    0 to 255

Default value:  0
        Control name:   Error

Description:

 This returned value is placed in the global
 variable AX3220H_err. The value zero indicates
 complete success.

    Error              Description
 ------------------------------------------------
       0     Success
      -1     Control value out of range
      -2     Byte value out of range

     230     GPIB write error
     231     No response from instrument
     232     Device not initialised

Variable type:  Integer.
    E ]            Set Status Enable                 F ]          Value                             G          Error                                         :SRQ enable 0 Event Enable 1 Limit Enable 2 Parallel Pol 3    0            AX3220H_err   )    Control name:   Output Number

Description:    Indicates the output number from
                which the values will be read.

Variable type:  integer

Valid range:    min = 1 , max = number of outputs
                available for the particular
                instrument.

Default value   1
    J  1           Output Number                                 1 1 2 2                          Error

This returned value is placed in the global
variable AX3220H_err. The value zero indicates
complete success.


    Error              Description
 ------------------------------------------------
       0     Success
      -1     Output number out of range

     230     GPIB write error
     231     No response from instrument
     232     Device not initialised

Variable type:  Integer.    L           Error                                      AX3220H_err        Control Name:   Output voltage

Description:    Voltage being output from the
                power supply.

Control Type:   Real.                           Error

This returned value is placed in the global
variable AX3220H_err. The value zero indicates
complete success.


    Error              Description
 ------------------------------------------------
       0     Success
      -1     Output number out of range

     230     GPIB write error
     231     No response from instrument
     232     Device not initialised

Variable type:  Integer.    M            Output Voltage                    N  s         Error                              	                   AX3220H_err        Control Name:   Output current

Description:    Current being output by the power
                supply.

Control Type:   Real                           Error

This returned value is placed in the global
variable AX3220H_err. The value zero indicates
complete success.


    Error              Description
 ------------------------------------------------
       0     Success
      -1     Output number out of range

     230     GPIB write error
     231     No response from instrument
     232     Device not initialised

Variable type:  Integer.    P            Output Current                    QH  s         Error                              	                   AX3220H_err        Control name:   Read Status

Description:    Used to select which status
                register to read

Variable type:  integer

Valid range:    min = 0 , max = 6

Default value   0 (Status Byte)

         Control Name:   Value

Description:    Retuened byte value of the
                selected register.

Control Type:   integer

Valid range:    0 to 255 - register value
                -1 - an error was encountered.                           Error

This returned value is placed in the global
variable AX3220H_err. The value zero indicates
complete success.


    Error              Description
 ------------------------------------------------
       0     Success
      -1     Status register identifier out of
             range

     230     GPIB write error
     231     No response from instrument
     232     Device not initialised

Variable type:  Integer.    S =            Read Status                       TQ =+         Value                             U2          Error                                         bStatus byte 0 Std Event 1 Limit Event 2 SRQ enable 3 Event Enable 4 Limit Enable 5 Parallel Pol 6    	                    AX3220H_err        Control name:   Store number

Description:    Select the number of the store to
                receive the instrument set up.

Variable type:  integer

Valid range:    1 to 25
    T                       Error

This returned value is placed in the global
variable AX3220H_err. The value zero indicates
complete success.


    Error              Description
 ------------------------------------------------
       0     Success
      -1     Store number out of range

     230     GPIB write error

Variable type:  Integer.    X) ]            Store number                      X          Error                                          AX3220H_err        Control name:   Store number

Description:    Select the number of the store
                from which to recall the
                instrument set up.

Variable type:  integer

Valid range:    1 to 25
    T                       Error

This returned value is placed in the global
variable AX3220H_err. The value zero indicates
complete success.


    Error              Description
 ------------------------------------------------
       0     Success
      -1     Store number out of range

     230     GPIB write error

Variable type:  Integer.    Z ]            Store number                      [          Error                                          AX3220H_err        Control name:   Command String

Description:    This control specifies data to be
                sent to the AX3220x. The absolute
                maximum length allowed is 2000
                bytes.

Variable type:  String


    Q                       Error

This returned value is placed in the global
variable AX3220H_err. The value zero indicates
complete success.


    Error              Description
 ------------------------------------------------
       0     Success

     230     GPIB write error
     232     Device not initialised

Variable type:  Integer.    ]{ =           Command String                    ^i          Error                                          AX3220H_err   
    Control name:   Response Stirng

Description:    This control specifies a string
                variable to receive the response
                from the AX3220x. The string must
                be long enough to receive the
                response to avoid overflow. To aid
                in checking this the number of
                bytes put into the string is
                returned from the function. The
                absolute maximum length allowed is
                2000 bytes.

Variable type:  String
         Control name:   Number of Bytes

Description:    This value is the number of bytes
                returned by the AX3220x and
                placed in the string.

Variable type:  Integer    \                       Error

This returned value is placed in the global
variable AX3220H_err. The value zero indicates
complete success.


    Error              Description
 ------------------------------------------------
       0     Success

     231     No response from instrument
     232     Device not initialised

Variable type:  Integer.    `G =           Response String                   bY =9         Number of Bytes                   c           Error                              	            	                    AX3220H_err        Control name:   File name

Description:    This control specifies file name
                from which the binary block will
                be sent to the AX3220x.

Variable type:  String - max length 50 characters


    t                       Error

This returned value is placed in the global
variable AX3220H_err. The value zero indicates
complete success.


    Error              Description
 ------------------------------------------------
       0     Success

     300     Refer to ibsta and iberr as specified
             for the GPIB library function ibwrtf

Variable type:  Integer.    eR M           File name                         f6          Error                                          AX3220H_err        Control name:   File name

Description:    This control specifies file name
                to which the binary block will be
                written when read from the
                AX3220x.

Variable type:  String - max length 50 characters


    s                       Error

This returned value is placed in the global
variable AX3220H_err. The value zero indicates
complete success.


    Error              Description
 ------------------------------------------------
       0     Success

     300     Refer to ibsta and iberr as specified
             for the GPIB library function ibrdf

Variable type:  Integer.    h7 M           File name                         i8          Error                                          AX3220H_err   u                       Error

This returned value is placed in the global
variable AX3220H_err. The value zero indicates
complete success.


    Error              Description
 ------------------------------------------------
       0     Success

     221     Unable to close device
     230     GPIB write error
     232     Device not initialised

Variable type:  Integer.    k8          Error                                      AX3220H_err   /         %Y     K.    init                                       -     K.    set_mode                          
c         0    F                                       2      8 w    set_op                            5O    8    set_volts                         8W   i  8    set_current                       ;v   i  8    set_ovp                           >c     C    set_op_status                     A     C    set_damping                       
         ER     K.    master_op                         V         I     K.    set_status                                 K    F                                       M      8     read_op                           P2    H    read_volts                        R   k  H    read_current                               V     K.    read_status                       V         Z@     K.    store                                      \     K.    recall                                     _     K.    send_cmd                          -         d     K.    get_response                               g     K.    send_from_file                             j     K.    get_to_file                                l     K.    close                                                                       DInitialise                          Configure                            DSet Mode                            Set Output                           DMaster Output Control                DStatus Reporting                    Measurement and Status               Read Output                          DRead Status                         8Local Storage                        DStore                                DRecall                              kMiscellaneous                        DSend Command String                  DGet Response String                  DSend Block From File                 DGet Block to File                    DClose                           