/*--------- LabWindows Generated Code:   Thu Sep 19 08:52:22 1991 ---------*/

#include        "gpib.h"
#include        "formatio.h"
#include        "AX3220H.h"

int AX3220H_err;
/* error return from all functions */
long AX3220H_model;


/* functions */
int AX3220H_write_data(char *,int );
int AX3220H_read_data(char *,int );
int AX3220H_check_open(void);

/* internal variables */
static int psu;
/* identifier handle */
static char buffer[100];

/* internal functions */
int AX3220H_write_data (buf, cnt)
char *buf;
int cnt;
{
        int r__AX3220H_write_data;

        if (ibwrt (psu, buf, cnt) <= 0)
                AX3220H_err = 230;
        else
                AX3220H_err = 0;
        r__AX3220H_write_data = AX3220H_err;
        return r__AX3220H_write_data;
}

int AX3220H_read_data (buf, cnt)
char *buf;
int cnt;
{
        int r__AX3220H_read_data;

        if (ibrd (psu, buf, cnt) <= 0)
                AX3220H_err = 231;
        else
                AX3220H_err = 0;
        r__AX3220H_read_data = AX3220H_err;
        return r__AX3220H_read_data;
}

void AX3220H_init (addr, set_default, self_test)
int addr;
int set_default;
int self_test;
{
        int id;
        int i__dummy;

        /* device address 0 to 30 */
        /* 1 = set defaults - *RST command */
        /* 1 = perform self test - *TST? */
        if (( -(addr < 0) |  -(addr > 30)) != 0)  {
                AX3220H_err =  -1;
                return;
        }
        if (psu <= 0)  {
                /* device not open */
                psu = OpenDev ("", "AX3220H");
                if (psu <= 0)  {
                        /* can't open device */
                        AX3220H_err = 220;
                        return;
                }
        }
        if (ibpad (psu, addr) <= 0)  {
                /* assign GPIB address */
                AX3220H_err = 233;
                return;
        }
        i__dummy = ibtmo (psu, 14);
        /* 30 sec timeout */
        if ((ibsta & 0x8000) != 0)  {
                AX3220H_err = 300;
                return;
        }
        i__dummy = ibeot (psu, 1);
        /* enable end message */
        if ((ibsta & 0x8000) != 0)  {
                AX3220H_err = 300;
                return;
        }
        i__dummy = ibclr (psu);
        if (AX3220H_write_data ("*CLS\n", 5) != 0)
                /* clear status */
                return;
        if (AX3220H_write_data ("*IDN?\n", 5) != 0)
                /* get identifier string */
                return;
        if (AX3220H_read_data (buffer, 50) != 0)
                return;
        i__dummy = Scan (buffer, "THURLBY-THANDAR,TSP%d,0,0,00", &id);
        /* check idn */
        if (( -(id >= 3221) &  -(id <= 3224)) != 0)
                AX3220H_model = (long)id;
        else  {
                /* error unknown id */
                AX3220H_err = 223;
                return;
        }
        if (set_default != 0)
                if (AX3220H_write_data ("*RST\n", 5) != 0)
                        return;
        if (self_test != 0)  {
                if (AX3220H_write_data ("*TST?\n", 6) != 0)
                        return;
                if (AX3220H_read_data (buffer, 50) != 0)
                        return;
                i__dummy = Scan (buffer, "%d", &id);
                if (id != 0)
                        AX3220H_err = id + 300;
                else
                        AX3220H_err = 0;
                return;
        }
        AX3220H_err = 0;
}

/* all o.k. */
void AX3220H_set_mode (ax_mode, tracka, trackb, l__sdm)
int ax_mode;
int tracka;
int trackb;
int l__sdm;
{
        int sdm;
        int i__dummy;

        /*- Modified value parameter*/
        sdm = l__sdm;
        if (AX3220H_check_open () != 0)
                return;
        /* not initialised */
        if (( -(ax_mode < 0) |  -(ax_mode > 13)) != 0)  {
                AX3220H_err =  -1;
                return;
        }
        if (( -(tracka < 0) |  -(tracka > 15)) != 0)  {
                AX3220H_err =  -2;
                return;
        }
        if (( -(trackb < 0) |  -(trackb > 15)) != 0)  {
                AX3220H_err =  -3;
                return;
        }
        if (sdm != 0)
                sdm = 1;
        i__dummy = Fmt (buffer, "MODE %d,%d,%d;TRIPMODE %d\n", ax_mode, tracka, trackb, sdm);
        if (AX3220H_write_data (buffer, NumFmtdBytes ()) != 0)
                return;
        AX3220H_err = 0;
}

int AX3220H_check_open ()
{
        int r__AX3220H_check_open;

        if (psu <= 0)
                /* device not open */
                AX3220H_err = 232;
        else
                AX3220H_err = 0;
        r__AX3220H_check_open = AX3220H_err;
        return r__AX3220H_check_open;
}

/* success */
void AX3220H_set_op (opno)
int opno;
{

}

/* dummy function all operations are secondary */
void AX3220H_set_volts (opno, voltage)
int opno;
double voltage;
{
        int i__dummy;

        AX3220H_err =  -1;
        /* assume error */
        if (opno < 1)
                return;
        if (( -(AX3220H_model == 3222L) &  -(opno > 2)) != 0)
                return;
        if (AX3220H_check_open () != 0)
                return;
        /* not initialised */
        i__dummy = Fmt (buffer, "V%d %f\n", opno, voltage);
        if (AX3220H_write_data (buffer, NumFmtdBytes ()) != 0)
                return;
        AX3220H_err = 0;
}

/* success */
void AX3220H_set_current (opno, current)
int opno;
double current;
{
        int i__dummy;

        AX3220H_err =  -1;
        /* assume error */
        if (opno < 1)
                return;
        if (( -(AX3220H_model == 3222L) &  -(opno > 2)) != 0)
                return;
        if (AX3220H_check_open () != 0)
                return;
        /* not initialised */
        i__dummy = Fmt (buffer, "I%d %f\n", opno, current);
        if (AX3220H_write_data (buffer, NumFmtdBytes ()) != 0)
                return;
        AX3220H_err = 0;
}

/* success */
void AX3220H_set_ovp (opno, ovp)
int opno;
double ovp;
{
        int i__dummy;

        AX3220H_err =  -1;
        /* assume error */
        if (opno < 1)
                return;
        if (( -(AX3220H_model == 3222L) &  -(opno > 2)) != 0)
                return;
        if (AX3220H_check_open () != 0)
                return;
        /* not initialised */
        i__dummy = Fmt (buffer, "OVP%d %f\n", opno, ovp);
        if (AX3220H_write_data (buffer, NumFmtdBytes ()) != 0)
                return;
        AX3220H_err = 0;
}

/* success */
void AX3220H_set_op_status (opno, l__op_stat)
int opno;
int l__op_stat;
{
        int op_stat;
        int i__dummy;

        /*- Modified value parameter*/
        op_stat = l__op_stat;
        AX3220H_err =  -1;
        /* assume error */
        if (opno < 1)
                return;
        if (( -(AX3220H_model == 3222L) &  -(opno > 2)) != 0)
                return;
        if (AX3220H_check_open () != 0)
                return;
        /* not initialised */
        if (op_stat != 0)
                op_stat = 1;
        i__dummy = Fmt (buffer, "OP%d %d\n", opno, op_stat);
        if (AX3220H_write_data (buffer, NumFmtdBytes ()) != 0)
                return;
        AX3220H_err = 0;
}

/* success */
void AX3220H_set_damping (opno, l__dmpg)
int opno;
int l__dmpg;
{
        int dmpg;
        int i__dummy;

        /*- Modified value parameter*/
        dmpg = l__dmpg;
        AX3220H_err =  -1;
        /* assume error */
        if (opno < 1)
                return;
        if (( -(AX3220H_model == 3222L) &  -(opno > 2)) != 0)
                return;
        if (AX3220H_check_open () != 0)
                return;
        /* not initialised */
        if (dmpg != 0)
                dmpg = 1;
        i__dummy = Fmt (buffer, "DAMPING%d %d\n", opno, dmpg);
        if (AX3220H_write_data (buffer, NumFmtdBytes ()) != 0)
                return;
        AX3220H_err = 0;
}

/* success */
void AX3220H_master_op (l__status)
int l__status;
{
        int status;
        int i__dummy;

        /*- Modified value parameter*/
        status = l__status;
        if (AX3220H_check_open () != 0)
                return;
        /* not initialised */
        if (status != 0)
                status = 1;
        i__dummy = Fmt (buffer, "MASTER %d\n", status);
        if (AX3220H_write_data (buffer, NumFmtdBytes ()) != 0)
                return;
        AX3220H_err = 0;
}

/* success */
void AX3220H_set_status (reg_type, byte_value)
int reg_type;
int byte_value;
{
        char str[5];
        int i__dummy;

        if (AX3220H_check_open () != 0)
                return;
        /* not initialised */
        if (( -(reg_type < 0) |  -(reg_type > 3)) != 0)  {
                AX3220H_err =  -1;
                return;
        }
        if (( -(byte_value < 0) |  -(byte_value > 255)) != 0)  {
                AX3220H_err =  -2;
                return;
        }
        switch (reg_type)  {
        case 0:
                i__dummy = Fmt (str, "*SRE");
                break;
        case 1:
                i__dummy = Fmt (str, "*ESE");
                break;
        case 2:
                i__dummy = Fmt (str, "LSE");
                break;
        case 3:
                i__dummy = Fmt (str, "*PRE");
                break;
        default:
                break;
        }
        i__dummy = Fmt (buffer, "%s %d\n", str, byte_value);
        if (AX3220H_write_data (buffer, NumFmtdBytes ()) != 0)
                return;
        AX3220H_err = 0;
}

/* success */
void AX3220H_read_op (opno)
int opno;
{

}

/* dummy function */
void AX3220H_read_volts (opno, voltage)
int opno;
double *voltage;
{
        int i__dummy;

        AX3220H_err =  -1;
        /* assume error */
        if (opno < 1)
                return;
        if (( -(AX3220H_model == 3222L) &  -(opno > 2)) != 0)
                return;
        if (AX3220H_check_open () != 0)
                return;
        /* not initialised */
        i__dummy = Fmt (buffer, "V%dR?\n", opno);
        /* read voltage */
        if (AX3220H_write_data (buffer, NumFmtdBytes ()) != 0)
                return;
        if (AX3220H_read_data (buffer, 50) != 0)
                return;
        i__dummy = Scan (buffer, "%fV", voltage);
        /* extract voltage value */
        AX3220H_err = 0;
}

/* success */
void AX3220H_read_current (opno, current)
int opno;
double *current;
{
        int i__dummy;

        AX3220H_err =  -1;
        /* assume error */
        if (opno < 1)
                return;
        if (( -(AX3220H_model == 3222L) &  -(opno > 2)) != 0)
                return;
        if (AX3220H_check_open () != 0)
                return;
        /* not initialised */
        i__dummy = Fmt (buffer, "I%dR?\n", opno);
        /* read current */
        if (AX3220H_write_data (buffer, NumFmtdBytes ()) != 0)
                return;
        if (AX3220H_read_data (buffer, 50) != 0)
                return;
        i__dummy = Scan (buffer, "%fA", current);
        /* extract current value */
        AX3220H_err = 0;
}

/* success */
int AX3220H_read_status (reg_type)
int reg_type;
{
        int r__AX3220H_read_status;
        char str[7];
        int byte;
        int i__dummy;

        if (AX3220H_check_open () != 0)  {
                r__AX3220H_read_status =  -1;
                return r__AX3220H_read_status;
        }
        /* not initialised */
        if (( -(reg_type < 0) |  -(reg_type > 6)) != 0)  {
                AX3220H_err =  -1;
                r__AX3220H_read_status =  -1;
                return r__AX3220H_read_status;
        }
        switch (reg_type)  {
        case 0:
                i__dummy = Fmt (str, "*STB?\n");
                break;
        case 1:
                i__dummy = Fmt (str, "*ESR?\n");
                break;
        case 2:
                i__dummy = Fmt (str, "LSR?\n");
                break;
        case 3:
                i__dummy = Fmt (str, "*SRE?\n");
                break;
        case 4:
                i__dummy = Fmt (str, "*ESE?\n");
                break;
        case 5:
                i__dummy = Fmt (str, "LSE?\n");
                break;
        case 6:
                i__dummy = Fmt (str, "*PRE?\n");
                break;
        default:
                break;
        }
        if (AX3220H_write_data (str, NumFmtdBytes ()) != 0)  {
                r__AX3220H_read_status =  -1;
                return r__AX3220H_read_status;
        }
        if (AX3220H_read_data (buffer, 50) != 0)  {
                r__AX3220H_read_status =  -1;
                return r__AX3220H_read_status;
        }
        i__dummy = Scan (buffer, "%d", &byte);
        /* extract value */
        AX3220H_err = 0;
        /* success */
        r__AX3220H_read_status = byte;
        return r__AX3220H_read_status;
}

void AX3220H_store (store_no)
int store_no;
{
        int i__dummy;

        if (AX3220H_check_open () != 0)
                return;
        /* not initialised */
        if (( -(store_no < 1) |  -(store_no > 25)) != 0)  {
                AX3220H_err =  -1;
                return;
        }
        i__dummy = Fmt (buffer, "*SAV %d\n", store_no);
        if (AX3220H_write_data (buffer, NumFmtdBytes ()) != 0)
                return;
        AX3220H_err = 0;
}

/* success */
void AX3220H_recall (store_no)
int store_no;
{
        int i__dummy;

        if (AX3220H_check_open () != 0)
                return;
        /* not initialised */
        if (( -(store_no < 1) |  -(store_no > 25)) != 0)  {
                AX3220H_err =  -1;
                return;
        }
        i__dummy = Fmt (buffer, "*RCL %d\n", store_no);
        if (AX3220H_write_data (buffer, NumFmtdBytes ()) != 0)
                return;
        AX3220H_err = 0;
}

/* success */
void AX3220H_send_cmd (cmd_buf)
char *cmd_buf;
{
        char output_buf[2000];
        int i__dummy;

        if (AX3220H_check_open () != 0)
                return;
        /* not initialised */
        i__dummy = Fmt (output_buf, "%s", cmd_buf);
        if (AX3220H_write_data (cmd_buf, NumFmtdBytes ()) != 0)
                return;
        AX3220H_err = 0;
}

/* success */
int AX3220H_get_response (cmd_buf)
char *cmd_buf;
{
        int r__AX3220H_get_response;

        if (AX3220H_check_open () != 0)  {
                r__AX3220H_get_response =  -1;
                return r__AX3220H_get_response;
        }
        /* not initialised */
        if (AX3220H_read_data (cmd_buf, 2000) != 0)  {
                r__AX3220H_get_response =  -1;
                return r__AX3220H_get_response;
        }
        r__AX3220H_get_response = ibcnt;
        return r__AX3220H_get_response;
}

void AX3220H_send_from_file (fname)
char *fname;
{
        int i__dummy;

        if (AX3220H_check_open () != 0)
                return;
        /* not initialised */
        i__dummy = ibwrtf (psu, fname);
        if ((ibsta & 0x8000) != 0)
                /* any errors */
                AX3220H_err = 300;
        else
                AX3220H_err = 0;
}

/* success */
void AX3220H_get_to_file (fname)
char *fname;
{
        int i__dummy;

        if (AX3220H_check_open () != 0)
                return;
        /* not initialised */
        i__dummy = ibrdf (psu, fname);
        if ((ibsta & 0x8000) != 0)
                /* any errors */
                AX3220H_err = 300;
        else
                AX3220H_err = 0;
}

/* success */
void AX3220H_close ()
{

        if (AX3220H_check_open () != 0)
                return;
        /* not initialised */
        /* first ensure that the input buffer is empty */
        AX3220H_err = 221;
        if (AX3220H_write_data ("*STB?\n", 6) != 0)
                return;
        if (AX3220H_read_data (buffer, 50) != 0)
                return;
        /* now close the device */
        AX3220H_err = 0;
        if (psu > 0)
                if (CloseDev (psu) < 0)  {
                        AX3220H_err = 221;
                        return;
                }
        psu = 0;
}

