/*== ASYC2 Include File ===================================================*/

/*== GLOBAL FUNCTION DECLARATIONS =========================================*/
int asyc2_init(int);
int asyc2_voltage(int,int,int,double,int,int,int,int);
int asyc2_current(int,int,int,double,int,int,int);
int asyc2_dB(int,double,int,int);
int asyc2_testline(int,double,int,int);
int asyc2_power(int,int,int);
int asyc2_frequency(int,int,int,int);
int asyc2_cycle(int,int,double,int,int);
int asyc2_pulse_count(int);
int asyc2_pulse_width(int,int,int);
int asyc2_resistance(int,int,double,int,int,int);
int asyc2_continuity_test(int,double,int,int,int);
int asyc2_capacitance(int,int,double,int,int,int);
int asyc2_diode(int,double,int,int);
int asyc2_temperature(int,int,int,int,int,double);
int asyc2_resolution(int);
int asyc2_rejection(int);
int asyc2_input_impedance(int);
int asyc2_lcd(int);
int asyc2_ref_ohm(int);
int asyc2_timer(char *);
int asyc2_status(int *,int *,long *,int *,int *,int *,int *,int *,int *,int *,long *,int *,int *,int *);
int asyc2_data(int,double *,int *);
int asyc2_close (void);

/*== CONSTANT DECLARATIONS ================================================*/

#define OHM      0      /* position of the commutator on Ohm               */
#define CAPA     1      /* position of the commutator on Capa              */
#define TEMP     3      /* position of the commutator on Temperature       */
#define VAC      4      /* position of the commutator on Vac               */
#define MV       5      /* position of the commutator on mV                */
#define VDC      6      /* position of the commutator on Vdc               */
#define MA       8      /* position of the commutator on mA                */
#define A10      9      /* position of the commutator on 10A               */
#define A5m     10      /* position of the commutator on 5mA               */
#define A50m    11      /* position of the commutator on 50mA              */
#define A500m   12      /* position of the commutator on 500mA             */
#define uA      13      /* position of the commutator on 500A             */
#define FREQ    14      /* position of the commutator on Frequency         */

#define AUTO    -1      /* reference for auto ranging mode                 */
#define DC      0       /* DC measurement                                  */
#define PEAKP   2       /* Peak+ measurement                               */
#define PEAKM   3       /* Peak- measurement                               */
#define AC      4       /* AC    measurement                               */
#define ACDC    6       /* AC+DC measurement                               */

#define MX53     0      /* Instrument Type: MX53                           */
#define MX54     1      /* Instrument Type: MX54                           */
#define MX55     3      /* Instrument Type: MX55                           */
#define MX56     2      /* Instrument Type: MX56                           */
