s         և     '  `                                       asyc2       ASYC II multimeter                            ^    This instrument driver provides programming
support for ASYC2 multimeters.

Functions and Classes:

1. Initialize - Open the RS232 COM port,
initializes the instrument and stores the
configuration.

2. Configure - Configure the measurements for:
    2.1.  Voltage
    2.2.  Current
    2.3.  dB
    2.4.  Test line
    2.5.  Resistive power
    2.6.  Duty cycle
    2.7.  Pulse Count
    2.9.  Chronometer
    2.10. Resistance
    2.11. Continuity test
    2.12. Capacitance
    2.13. Diode Voltage
    2.14. Temperature

3. Change mode - Configure the following modes:
    3.1. Resolution
    3.2. Rejection
    3.3. Input Impedance
    3.4. OHM reference
    3.5. Timer
    3.6. LCD

4. Measure - Take a measurement from the
instrument in the following mode:
    4.1 MIN
    4.2 MAX
    4.3 AVG
    4.4 Last
    4.5 Next

5. Close - close the RS232 COM port.    H    Functions to configure the instrument for a
measurement:

1.  Voltage
2.  Current
3.  dB
4.  Testline
5.  Power
6.  Frequency
7.  Duty cycle
8.  Pulse count
9.  Chrono
10. Resistance
11. Continuity test
12. Capacitance
13. Diode voltage
14. Temperature

If the measurement is not available for the
instrument an error appends.    }    Functions to specify special configurations:

1. Resolution (5.000 or 50.000 points)
2. Rejection (50 or 60 Hz)
3. Input impedance (for measurement in the mV
   range)
4. Measurement mode (Normal or calibration)
5. Ohm value reference (for dB or resistive power
   measurement)
6. Timer value (for repetitive measurement)
7. Lcd (to display a measurement or all the
   segments)
         Functions to read the configuration of the
instrument or to define the measurements to
execute.

1. Configuration: gives the status of the
   instrument.
2. Measurement: defines the measurement (MIN, MAX,
   AVG, last, next).
     c    Initializes the instrument module by opening a
COM port, and reads the status of the DMM ASYC II.         Specifies the COM port for the RS232.

Variable Type: integer

Valid Range:   1 - COM1
               2 - COM2
               3 - COM3
               4 - COM4

Default Value: 1 - COM1    (    Displays the results of the instrument driver
function call:

Variable Type: integer

Error Codes:
        0   Success

       -1   COM port out of range
       -2   canal out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      239   Error in configuring timeout
      240   Instrument timed out

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)
     Z          COM Port                                    Error                                                  	            1    Switches the instrument to voltage measurement.         Specifies the type of measurement.

Variable Type: integer

Valid Range:   0 -  DC
               1 -  AC
               2 -  AC+DC
               3 -  Peak+
               4 -  Peak-

Default Value: 0 -  DC    2    Specifies the range of the measurement
(auto ranging is disable with Peak measurement).

Variable Type:  integer

Variable Range:  0 - AUTO
                 1 - 500 mV
                 2 - 5 V
                 3 - 50 V
                 4 - 500 V
                 5 - 750/1000 V

Default Value:   0 - AUTO         Specifies the ZOOM mode to expand the bargraph.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off         Specifies the MEM mode to fix the display to the
current value.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off
         Specifies the LHRD mode to the last reading hold
current value.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off

         Specifies the SURV mode to access the surveillance
mode in which minimum, maximum and sliding average
values of the current measurement are stored.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off



    y    Specifies the REL Mode. If it is

  - Last Value:
        the last value measured becomes the
        reference value derived from subsequence
        measurement

  - Reference:
        the reference value is the value
        stored in the panel 'Reference'.

Variable Type:  integer

Variable Range:  2 - Reference
                 1 - Last Value
                 0 - Off
    x    Specifies the relative reference value.

Variable Type:   double

Variable Range:  according to Range:
    750/1000 V       -1000  to +1000 VOLT
         500 V        -500  to  +500 VOLT
          50 V         -50  to   +50 VOLT
           5 V          -5  to    +5 VOLT
         500mV        - 0.5 to    0.5VOLT
          AUTO       -1000  to +1000 VOLT

Default Value:   0    d    Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

       -1   Config out of range
       -2   Range out of range
       -3   REL Mode out of range
       -4   Reference out of range
       -5   Zoom out of range
       -6   Memo out of range
       -7   Lrhd out of range
       -8   Surv out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      300   Function not available
      301   Wrong position of the rotary switch
      302   Two arguments are incompatible
      303   Measurement is overloaded (OL)

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)     - c           Function                           -           Range                             
 M+          Zoom                              z Mc          Hold                              ) M          Lrhd                               M          Surv                                T          REL Mode                          `           Reference (VOLT)                            Error                                                                                    "DC 0 AC 1 AC+DC 2 Peak+ 3 Peak- 4              1750/1000 V 5 500 V 4 50 V 3 5 V 2 500mV 1 AUTO 0    On 1 Off 0    On 1 Off 0    On 1 Off 0    On 1 Off 0              Reference 2 Last Value 1 Off 0    0    	            %Set rotary switch to VDC,mVDC or VAC    1    Switches the instrument to current measurement.         Specifies the type of measurement.

Variable Type: integer

Valid Range:   0 -  DC
               1 -  AC
               2 -  AC+DC
               3 -  Peak+
               4 -  Peak-

Default Value: 0 -  DC    /    Specifies the range of the measurement
(auto ranging is disable with Peak measurement).

Variable Type:  integer

Variable Range:  0 - AUTO
                 1 - 500 A
                 2 - 5 mA
                 3 - 50 mA
                 4 - 500 mA
                 5 - 10 A

Default Value:   0 - AUTO         Specifies the ZOOM mode to expand the bargraph.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off
         Specifies the MEM mode to fix the display to the
current value.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off

         Specifies the SURV mode to access the surveillance
mode in which minimum, maximum and sliding average
values of the current measurement are stored.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - On

        Specifies the REL Mode. If it is

  - Last Value:
        the last value measured becomes the
        reference value derived from subsequence
        measurement

  - Reference:
        the reference value is the value
        stored in the panel 'Reference'.

Variable Type:  integer

Variable Range:  2 - Reference
                 1 - Last Value
                 0 - Off

Default Value:   0 - Off
    _    Specifies the relative reference value.

Variable Type:   double

Variable Range: according to the range :

          10 A    -10000 to +10000mA
         500mA      -500 to   +500mA
          50mA       -50 to    +50mA
           5mA        -5 to     +5mA
         500A      -0.5 to   +0.5mA
          AUTO      -500 to   +500mA

Default Value:  0
    B    Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

       -1   Config out of range
       -2   Range out of range
       -3   REL Mode of range
       -4   Reference out of range
       -5   Zoom out of range
       -6   Memo out of range
       -7   Surv out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      300   Function not available
      301   Wrong position of the rotary switch
      302   Two arguments are incompatible
      303   Measurement is overloaded (OL)

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)     - c           Function                           -           Range                              M+          Zoom                              V Mc          Hold                               M          Surv                              	  T          REL Mode                                      Reference (mA)                    "          Error                                                                                    "DC 0 AC 1 AC+DC 2 Peak+ 3 Peak- 4              +10 A 5 500mA 4 50mA 3 5mA 2 500A 1 AUTO 0    On 1 Off 0    On 1 Off 0    On 1 Off 0              Reference 2 Last Value 1 Off 0    0    	            "Set rotary switch to A,mA or 10A    M    Sets the instrument to dBm measurement.

This function is available on VAC.         Specifies the MEM mode to fix the display to the
current value.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off

         Specifies the SURV mode to access the surveillance
mode in which minimum, maximum and sliding average
values of the current measurement are stored.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off
        Specifies the REL Mode. If it is

  - Last Value:
        the last value measured becomes the
        reference value derived from subsequence
        measurement

  - Reference:
        the reference value is the value
        stored in the panel 'Reference'.

Variable Type:  integer

Variable Range:  2 - Reference
                 1 - Last Value
                 0 - Off

Default Value:   0 - Off
     |    Specifies the relative reference value.

Variable Type:   double

Variable Range: -500.0 to +500.0 dB

Default Value:   0
        Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

       -1   REL Mode out of range
       -2   Reference out of range
       -3   Surv out of range
       -4   Memo out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      300   Function not available
      301   Wrong position of the rotary switch
      302   Two arguments are incompatible
      303   Measurement is overloaded (OL)

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)    ( Mc          Hold                              )0 M          Surv                              *3  T           REL Mode                          +           Reference                         ,R          Error                                                                                                                    On 1 Off 0    On 1 Off 0              Reference 2 Last Value 1 Off 0    0    	            Set rotary switch to VAC    from -500 to +500 dB    V    Switches the instrument to Testline measurement.

This function is available on VAC.         Specifies the MEM mode to fix the display to the
current value.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off

         Specifies the SURV mode to access the surveillance
mode in which minimum, maximum and sliding average
values of the current measurement are stored.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off
        Specifies the REL Mode. If it is

  - Last Value:
        the last value measured becomes the
        reference value derived from subsequence
        measurement

  - Reference:
        the reference value is the value
        stored in the panel 'Reference'.

Variable Type:  integer

Variable Range:  2 - Reference
                 1 - Last Value
                 0 - Off

Default Value:   0 - Off
     x    Specifies the relative reference value.

Variable Type:   double

Variable Range: 0 to +600 Volts

Default Value:   0
        Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

       -1   REL Mode out of range
       -2   Rel. reference out of range
       -3   Memo out of range
       -4   Surv out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      300   Function not available
      301   Wrong position of the rotary switch
      302   Two arguments are incompatible
      303   Measurement is overloaded (OL)

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)    1 Mc          Hold                              2S M          Surv                              3V  T           REL Mode                          4           Reference                         5q          Error                            
                                                                                        On 1 Off 0    On 1 Off 0              Reference 2 Last Value 1 Off 0    0    	            Set rotary switch to VAC    from 0 to 600 VOLTS    X    Sets the instrument to resistive Power
measurement.
This function is available on VDC.         Specifies the MEM mode to fix the display to the
current value.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off

         Specifies the SURV mode to access the surveillance
mode in which minimum, maximum and sliding average
values of the current measurement are stored.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off
         Specifies the REL mode. If it is

  - On: the last value measured becomes the
        reference value derived from subsequence
        measurement

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0        Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

       -1   REL Mode out of range
       -2   Memo out of range
       -3   Surv out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      300   Function not available
      301   Wrong position of the rotary switch
      302   Two arguments are incompatible
      303   Measurement is overloaded (OL)

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)    : Mc          Hold                              ;x M          Surv                              <{  6           REL Mode                          =v          Error                                                                         On 1 Off 0    On 1 Off 0    On 1 Off 0    	            Set rotary switch to VDC    /    Sets the instrument to frequency measurement.         Specifies the ZOOM mode to expand the bargraph

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off
         Specifies the MEM mode to fix the display to the
current value.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off

         Specifies the SURV mode to access the surveillance
mode in which minimum, maximum and sliding average
values of the current measurement are stored.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off
         Specifies the REL mode. If it is

  - On: the last value measured becomes the
        reference value derived from subsequence
        measurement

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0        Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

       -1   REL Mode out of range
       -2   Zoom out of range
       -3   Memo out of range
       -4   Surv out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      300   Function not available
      301   Wrong position of the rotary switch
      302   Two arguments are incompatible
      303   Measurement is overloaded (OL)

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)    A M+          Zoom                              Bt Mc          Hold                              C$ M          Surv                              D'  6           REL Mode                          E"          Error                             n                                            On 1 Off 0    On 1 Off 0    On 1 Off 0    On 1 Off 0    	            5Set rotary switch to Voltage or Current Measurements    4    Switches the instrument to Duty Cycle measurement.         Specifies the duty cycle sign:

  + : positive part of the signal
  - : negative part of the signal

Variable Type:  integer

Variable Range:  0 - positive part
                 1 - negative part

Default Value:   0         Specifies the MEM mode to fix the display to the
current value.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off

         Specifies the SURV mode to access the surveillance
mode in which minimum, maximum and sliding average
values of the current measurement are stored.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off
        Specifies the REL Mode. If it is

  - Last Value:
        the last value measured becomes the
        reference value derived from subsequence
        measurement

  - Reference:
        the reference value is the value
        stored in the panel 'Reference'.

Variable Type:  integer

Variable Range:  2 - Reference
                 1 - Last Value
                 0 - Off

Default Value:   0 - Off
     r    Specifies the relative reference value.

Variable Type:   double

Variable Range: 0 to 100%

Default Value:   0
        Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

       -1   Sign out of range
       -2   REL Mode out of range
       -3   Reference out of range
       -4   Memo out of range
       -5   Surv out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      300   Function not available
      301   Wrong position of the rotary switch
      302   Two arguments are incompatible
      303   Measurement is overloaded (OL)

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)    J M n           Sign                              J Mc          Hold                              K M          Surv                              L  T          REL Mode                          N3           Reference                         N          Error                             n                                                                                      + 0 - 1    On 1 Off 0    On 1 Off 0              Reference 2 Last Value 1 Off 0    0    	            5Set rotary switch to Voltage or Current Measurements    from 0 to 100 %    6    Switches the instrument to Pulse Count
measurement.
         Specifies the pusle count sign:

  + : count the positive pulses
  - : count the negative pulses

Variable Type:  integer

Variable Range:  0 - positive pulses
                 1 - negative pulses

Default Value:   0        Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

       -1   Sign out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      300   Function not available
      301   Wrong position of the rotary switch
      302   Two arguments are incompatible
      303   Measurement is overloaded (OL)

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)    TS M n           Sign                              U5          Error                             n                                           + 0 - 1    	            5Set rotary switch to Voltage or Current Measurements    K    Switches the instrument to positive or negative
pulse width measurement.
         Specifies the chrono sign:

  + : count the positive pulses
  - : count the negative pulses

Variable Type:  integer

Variable Range:  0 - positive pulses
                 1 - negative pulses

Default Value:   0         Specifies the MEM mode to fix the display to the
current value.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off

         Specifies the SURV mode to access the surveillance
mode in which minimum, maximum and sliding average
values of the current measurement are stored.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off
        Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

       -1   Sign out of range
       -2   Memo out of range
       -3   Surv out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      300   Function not available
      301   Wrong position of the rotary switch
      302   Two arguments are incompatible
      303   Measurement is overloaded (OL)

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)    Y M n           Sign                              Y Mc          Hold                              Z M          Surv                              [          Error                             n                                           + 0 - 1    On 1 Off 0    On 1 Off 0    	            5Set rotary switch to Voltage or Current Measurements    d    Sets the instrument to Resistance measurement.

(Check that the rotary switch is in OHM position).    \    Specifies the range of the measurement
(auto ranging is disable with Peak measurement).

Variable Type:  integer

Variable Range:  0 - AUTO
                 1 - 500  OHM
                 2 -   5 kOHM
                 3 -  50 kOHM
                 4 - 500 kOHM
                 5 -   5 MOHM
                 6 -  50 MOHM

Default Value:   0 - AUTO         Specifies the ZOOM mode to expand the bargraph

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off
         Specifies the MEM mode to fix the display to the
current value.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off


         Specifies the SURV mode to access the surveillance
mode in which minimum, maximum and sliding average
values of the current measurement are stored.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off
        Specifies the REL Mode. If it is

  - Last Value:
        the last value measured becomes the
        reference value derived from subsequence
        measurement

  - Reference:
        the reference value is the value
        stored in the panel 'Reference'.

Variable Type:  integer

Variable Range:  2 - Reference
                 1 - Last Value
                 0 - Off

Default Value:   0 - Off
        Specifies the relative reference value.

Variable Type:   double

Variable Range:  according to the Range :

          50MOHM       -50000 to   +50000 kOHM
           5MOHM        -5000 to    +5000 kOHM
         500kOHM         -500 to     +500 kOHM
          50kOHM          -50 to      +50 kOHM
           5kOHM           -5 to       +5 kOHM
         500 OHM           -0.5 to     +0.5 kOHM
            AUTO       -50000   to +50000 kOHM

Default Value:   0
    &    Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

       -1   Range out of range
       -2   REL Mode out of range
       -3   Reference out of range
       -4   Zoom out of range
       -5   Memo out of range
       -6   Surv out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      300   Function not available
      301   Wrong position of the rotary switch
      302   Two arguments are incompatible
      303   Measurement is overloaded (OL)

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)    `>             Range                             a M+          Zoom                              b@ Mc          Hold                              b M          Surv                              c  T          REL Mode                          e           Reference (kOHM)                  ge          Error                            +                                                      B50 MOHM 6 5 MOHM 5 500 kOHM 4 50 kOHM 3 5 kOHM 2 500 OHM 1 AUTO 0    On 1 Off 0    On 1 Off 0    On 1 Off 0              Reference 2 Last Value 1 Off 0    0    	            Set rotary switch to OHM    5    Sets the instrument to Continuity Test
measurement.         Specifies the ZOOM mode to expand the bargraph

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off
         Specifies the MEM mode to fix the display to the
current value.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off

         Specifies the SURV mode to access the surveillance
mode in which minimum, maximum and sliding average
values of the current measurement are stored.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off
        Specifies the REL Mode. If it is

  - Last Value:
        the last value measured becomes the
        reference value derived from subsequence
        measurement

  - Reference:
        the reference value is the value
        stored in the panel 'Reference'.

Variable Type:  integer

Variable Range:  2 - Reference
                 1 - Last Value
                 0 - Off

Default Value:   0 - Off
     w    Specifies the relative reference value.

Variable Type:   double

Variable Range:  0 to +500 OHM

Default Value:   0
        Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

       -1   REL Mode out of range
       -2   Reference out of range
       -3   Zoom out of range
       -4   Memo out of range
       -5   Surv out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      300   Function not available
      301   Wrong position of the rotary switch
      302   Two arguments are incompatible
      303   Measurement is overloaded (OL)

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)    mN M+          Zoom                              m Mc          Hold                              n M          Surv                              o  T           REL Mode                          q:           Reference                         q          Error                            +                                                                                       On 1 Off 0    On 1 Off 0    On 1 Off 0              Reference 2 Last Value 1 Off 0    0    	            Set rotary switch to OHM    from 0 to 500 OHM    5    Switches the instrument to Capacitance
measurement.    O    Specifies the range of the measurement.

Variable Type:  integer

Variable Range:  0 - AUTO Range
                 1 -   50 nF
                 2 -  500 nF
                 3 -    5 F
                 4 -   50 F
                 5 -  500 F
                 6 - 5000 F
                 7 -   50 mF

Default Value:   0 - AUTO Range         Specifies the ZOOM mode to expand the bargraph

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off
         Specifies the MEM mode to fix the display to the
current value.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off

         Specifies the SURV mode to access the surveillance
mode in which minimum, maximum and sliding average
values of the current measurement are stored.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off
        Specifies the REL Mode. If it is

  - Last Value:
        the last value measured becomes the
        reference value derived from subsequence
        measurement

  - Reference:
        the reference value is the value
        stored in the panel 'Reference'.

Variable Type:  integer

Variable Range:  2 - Reference
                 1 - Last Value
                 0 - Off

Default Value:   0 - Off
        Specifies the relative reference value.

Variable Type:   double

Variable Range:  according to the Range :

          50mF    -50000    to +50000 F
        5000F     -5000    to  +5000 F
         500F      -500    to   +500 F
          50F       -50    to    +50 F
           5F        -5    to     +5 F
         500nF        -0.5  to      0.5 F
          50nF        -0.05 to      0.05F
          AUTO    -50000    to +50000 F

Default Value:   0
    &    Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

       -1   Range out of range
       -2   REL Mode out of range
       -3   Reference out of range
       -4   Zoom out of range
       -5   Memo out of range
       -6   Surv out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      300   Function not available
      301   Wrong position of the rotary switch
      302   Two arguments are incompatible
      303   Measurement is overloaded (OL)

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)    wG             Range                             x M+          Zoom                              y< Mc          Hold                              y M          Surv                              z  T          REL Mode                          |           Reference (F)                    ~a          Error                            $                                                      B50 mF 7 5000 F 6 500 F 5 50 F 4 5 F 3 500 nF 2 50 nF 1 AUTO 0    On 1 Off 0    On 1 Off 0    On 1 Off 0              Reference 2 Last Value 1 Off 0    0    	            %Set rotary switch to Capacity (-II-)    r    Switches the instrument to Diode voltage
measurement.
Check if the rotary switch is on Diode (or -II-)
position.         Specifies the MEM mode to fix the display to the
current value.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off

         Specifies the SURV mode to access the surveillance
mode in which minimum, maximum and sliding average
values of the current measurement are stored.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off

        Specifies the REL Mode. If it is

  - Last Value:
        the last value measured becomes the
        reference value derived from subsequence
        measurement

  - Reference:
        the reference value is the value
        stored in the panel 'Reference'.

Variable Type:  integer

Variable Range:  2 - Reference
                 1 - Last Value
                 0 - Off

Default Value:   0 - Off
     v    Specifies the relative reference value.

Variable Type:   double

Variable Range:  0 to +2 VOLT

Default Value:   0
        Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

       -1   REL Mode out of range
       -2   Reference out of range
       -3   Memo out of range
       -4   Surv out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      300   Function not available
      301   Wrong position of the rotary switch
      302   Two arguments are incompatible
      303   Measurement is overloaded (OL)

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)     Mc          Hold                              C M          Surv                              G  T           REL Mode                                     Reference                         `          Error                                                                                                                    On 1 Off 0    On 1 Off 0              Reference 2 Last Value 1 Off 0    0    	            "Set rotary switch to Diode (-I>-)    from 0 to 2 VOLT    2    Sets the instrument to Temperature measurement.
         Specifies the unit of the temperature.

    - Celsius
    - Fahrenheit.

Variable Type:  integer

Variable Range:  0 - Celsius
                 1 - Fahrenheit

Default Value:   0 - Celsius         Specifies the sensor selection.

Variable Type:  integer

Variable Range:  0 - Pt 1000
                 1 - Pt  100

Default Value:   1 - Pt  100
         Specifies the MEM mode to fix the display to the
current value.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off

         Specifies the SURV mode to access the surveillance
mode in which minimum, maximum and sliding average
values of the current measurement are stored.

Variable Type:  integer

Variable Range:  0 - Off
                 1 - On

Default Value:   0 - Off
        Specifies the REL Mode. If it is

  - Last Value:
        the last value measured becomes the
        reference value derived from subsequence
        measurement

  - Reference:
        the reference value is the value
        stored in the panel 'Reference'.

Variable Type:  integer

Variable Range:  2 - Reference
                 1 - Last Value
                 0 - Off

Default Value:   0 - Off
         Specifies the relative reference value.

Variable Type:   double

Variable Range: PT100  : 0 to +500 OHM
                PT1000 : 0 to +5.000 OHM

Default Value:   0
    '    Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

       -1   Unit out of range
       -2   Sensor out of range
       -3   Memo out of range
       -4   Surv out of range
       -5   REL Mode out of range
       -6   Reference out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      300   Function not available
      301   Wrong position of the rotary switch
      302   Two arguments are incompatible
      303   Measurement is overloaded (OL)

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)     M n           Unit                              ] M           Sensor                             Mc          Hold                               M          Surv                                T          REL Mode                          G           Reference                                   Error                                                                                                                                                             
  F 1 C 0   Pt 100 1 Pt 1000 0    On 1 Off 0    On 1 Off 0              Reference 2 Last Value 1 Off 0    0    	            Set rotary switch to C or F    Pt 100  : from 0 to  500 OHM    Pt 1000 : from 0 to 5000 OHM    D    Changes the resolution of the instrument (5.000 or
50.000 points).         Specifies the resolution of the display

    - Low   :  5.000 points
    - High  : 50.000 points

Variable Type:  integer

Variable Range:  0 -  5.000 points
                 1 - 50.000 points

Default Value:   1    y    Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

       -1   Resolution out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      302   Resolution not compatible with
            measurement mode. See Notes below.

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)

Notes :
High resolution not compatible with:

Test Line           
Duty Cycle +/-      
Capacitance         
Diode               
Peak +/- (A,V)      

Low resolution not compatible with:

dB                  
Frequency           
Count +/-           
P Width +/-         
Power               
Temp                    c M            Resolution                        A          Error                            
 High 1 Low 0    	            8    Changes the Rejection of the instrument (50 or 60
Hz).         Specifies the rejection of the instrument

Variable Type:  integer

Variable Range:  0 - 50 Hz
                 1 - 60 Hz

Default Value:   0 - 50 Hz        Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

       -1   Rejection out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)     M            Rejection                         '          Error                              60 Hz 1 50 Hz 0    	            \    Changes the Input impedance of the instrument. It
is used for measurement in the mV range.         Specifies the input impedance for measurement in
the mV range

Variable Type:  integer

Variable Range:  0 -     10 MOHM
                 1 - >10000 MOHM

Default Value:   0 -     10 MOHM        Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

       -1   Input impedance out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)     M            Input impedance                             Error                              >1000 MOHM 1 10 MOHM 0    	            e    Change the OHM value reference of the instrument.
It is used for dB or resistive power measurement.         Specifies the OHM value reference in dB and
resistive power measurement.

Variable Type:  integer

Variable Range:  1 to 9999 (OHM)

Default Value:   600        Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

       -1   OHM value reference out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)     ^            Value                             Q          Error                              600    	            S    Changes the Timer value of the instrument. It is
used for repetitive measurement.    I    Specifies the timer value for repetitive
measurement:
        1st character: hour   (0 to 9)

        2nd character: minute (0 to 5)
        3rd character: minute (0 to 9)

        4th character: second (0 to 5)
        5th character: second (0 to 9)

Variable Type:  string
Variable Range:  "0" to "95959"
Default Value:   "1"        Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

       -1   Timer value out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)     ]           Timer value                       m          Error                              "1"    	            R    Changes the status of the LCD. It can display a
measurement or all the segments.        Specifies the status of the display:

    - Normal display: displays a measurement
    - Full display  : all segments are displayed


Variable Type:  integer

Variable Range:  0 - Normal display
                 1 - full display

Default Value:   0 - Normal display        Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

       -1   Status out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)    / M            Status                            B          Error                                         Normal LCD 0 Full LCD 1    	            >    Configuration: return data informations from the
instrument.     U    Displays the reference of the instrument:

    0, 1, 2, 3.

Variable Type : integer     r    Displays the version of the instrument.

    0 :  First Version
    1 :  Second Version

Variable Type: integer
         Displays the date of the last calibration
(dd/mm/yy).

Variable Type: long

    Example  : 51095

             day    :  5
             month  : 10
             year   : 95         Displays the resolution of the instrument.

    0 => Low   (5.000 points)
    1 => High (50.000 points)

Variable Type: integer
     d    Displays the rejection of the instrument.

    0 => 50 Hz
    1 => 60 Hz

Variable Type: integer

    J    Displays the position of the rotary switch.


        0 => OHM             8 => mA
        1 => CAPA            9 => 10A
        2 => Not Used       10 => 5mA      
        3 => TEMP           11 => 50mA     
        4 => VAC            12 => 500mA    
        5 => mV
        6 => VDC
        7 => FUSE2

Variable Type: integer        Displays the configuration of the measurement.

    0 => A DC      14 => OHM      26 => Power
    2 => A Peak+   15 => Capa     27 =>
    3 => A Peak-   16 => V DC     41 => Frequency
    4 => A AC      18 => V Peak+  42 => P Width+
    6 => A AC+DC   19 => V Peak-  43 => P Width-
   10 => Temp      20 => V AC     44 => D.Cycl.+
   11 => Continu   22 => V AC+DC  45 => D.Cycl.-
   12 =>           24 => dB       46 => Count+
   13 => Diode     25 => Test L.  47 => Count-

Variable Type: integer        Displays the range of the measurement.

         Volt      Ampere       Ohm        Capa
    0 =>  500mV     500A     500 Ohm      50nF
    1 =>    5 V       5mA       5kOhm     500nF
    2 =>   50 V      50mA      50kOhm       5F
    3 =>  500 V     500mA     500kOhm      50F
    4 => 1000 V                 5MOhm     500F
    5 =>             10 A      50MOhm    5000F
    6 =>                                   50mF

Variable Type: integer     {    Displays the input impedance of the instrument.

    0 =>       10 MOhms
    1 =>   > 1000 MOhms

Variable Type: integer
     d    Displays the ohm reference value for dBm and
resistance power measurement.

Variable Type: integer     f    Displays the timer value for repetitive
measurement (ex: 31542 ==> 3h 15' 42").

Variable Type: long         Displays the temperature unity for temperature
measurement.

    0 => Celsius
    1 => Fahrenheit.

Variable Type: integer

        Displays the status of the two fuses :

         Fuse 2     Fuse 1
    0 =>  OFF        OFF
    1 =>  OFF         ON
   10 =>   ON        OFF
   11 =>   ON         ON

   (OFF means that the fuse is blown)

Variable Type: integer

Variable Name: asyc2_fuse1
     f    Displays the status of the battery

    0 => battery ok
    1 => battery out

Variable Type: integer        Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:

        0   Success

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)                 Instrument                        h  |          Version                                      Calibration Date                   N          Resolution                        "           Rejection                          m           Rotary switch                      m |          Measure                            m           Range                              mN          Input Zi                          ' m 	         Ohm Reference                        
        Timer                               |          Temperature                                   Fuses                              N 
         Battery                                     Error                              	            	            	            	            	            	            	            	            	            	            	            	            	            	            	               Define the measurements to execute :

   MIN, MAX,AVG, Last, Next.

  MIN : minimum value stored in SURVeillance mode.

  MAX : maximum value stored in SURVeillance mode.

  AVG : sliding value stored in SURVeillance mode.

  Last: last value measured.

  Next: next value measured.        Specifies the type of the measurement.

Variable Type:  integer

Variable Range:  0 - MIN
                 1 - MAX
                 2 - AVG
                 3 - last
                 4 - next

Default Value:   0 - MIN

Notes :
  MIN : minimum value stored in SURVeillance mode.
  MAX : maximum value stored in SURVeillance mode.
  AVG : sliding value stored in SURVeillance mode.
  Last: last value measured.
  Next: next value measured.


    w    Displays the results of the measurement in
Scientific Format. If you want to display the
results in Floating Point Format, Use the menu
Options/Edit Panel then double click on the
Measurement control and set the Display Format
Floating Point. Use the menu Options/Operate Panel
to take control.

The unities are :

    VOLT        for voltage
    AMPERE      for current
    OHM         for resistance
    Hz          for frequency
    %           for duty cycle
    F           for capacity
    C or F    for temperature

Variable Type:  Double

Note: If Error 300 is displayed (Not available),
      this result is not valid.    C    Displays the configuration of the measurement.

    0 => A DC      14 => OHM      26 => Power
    2 => A Peak+   15 => Capa     27 =>
    3 => A Peak-   16 => V DC     41 => Frequency
    4 => A AC      18 => V Peak+  42 => P Width+
    6 => A AC+DC   19 => V Peak-  43 => P Width-
   10 => Temp      20 => V AC     44 => D.Cycl.+
   11 => Continu   22 => V AC+DC  45 => D.Cycl.-
   12 =>           24 => dB       46 => Cmpt+
   13 => Diode     25 => Test L.  47 => Cmpt-

Variable Type: integer

Note: If Error 300 is displayed (Not available),
      this result is not valid.        Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:
        0   Success

       -1   Type of measurement out of range

      220   Unable to open instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      300   Function not available
      301   Wrong position of the rotary switch
      302   Two arguments are incompatible
      303   Measurement is overloaded (OL)

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)    » = G           Measure                           } M          Result                             MU          Type                              G          Error                                          MIN 0 MAX 1 AVG 2 Last 3 Next 4    	           	            	            e    Takes the instrument off-line.

Note:  The instrument must be reinitialized to use
       it again.    g    Displays the results of the instrument driver
function call:

Variable Type: Integer

Error Codes:
        0   Success

      221   Unable to close instrument
      223   Instrument identification query failed
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out

      300   Function not available
      301   Wrong position of the rotary switch
      302   Two arguments are incompatible
      303   Measurement is overloaded (OL)

      4xx   See RS232 Library error codes
            (rs232err = 400 - Error)    w          Error                              	                         K.    init                                       L 
    K.    voltage                                  n  %U 	    K.    current                                  (+  /C     K.    dB                                       1E  8g     K.    testline                                 :h  @D     K.    power                                    A  H     K.    frequency                                I  Q     K.    cycle                                    T  W     K.    pulse_count                              X  ^^     K.    pulse_width                              _  j     K.    resistance                               m  t     K.    continuity_test                          w
       K.    capacitance                                Q     K.    diode                                    X  & 
    K.    temperature                                     K.    resolution                               H       K.    rejection                                       K.    input_impedance                          A  D     K.    ref_ohm                                    X     K.    timer                                      (     K.    lcd                                             K.    status                                          K.    data                                     
       K.    close                                                                       DInitialize                          Configure                            DVoltage                              DCurrent                              DdB                                   DTest line                            DResistive Power                      DFrequency                            DDuty cycle                           DPulse count                          DPulse width                          DResistance                           DContinuity test                      DCapacitance                          DDiode voltage                        DTemperature                         6Change mode                          DResolution                           DRejection                            DInput impedance                      DOHM reference                        DTimer                                DLCD                                 Measurement and control              DConfiguration                        DMeasurement                          DClose                           