# !/bin/sh
#
# FD, le 31/01/2017
#
# Script permettant la mise à jour du logiciel embarque dans la camera CA1954
# Ce script est récupéré dans l'archive stocké sur la SD card, qui a ete décompressée
# dans le répertoire /home/root/update
# il s'exécute depuis cet emplacement
#
# Le script retourne negatif s'il ya eu une erreur sinon retourne 0 ou 1
# - Si retourne 0 cela signiique que l'update c'est bien passe et que initcam1954 
#   pourra lancer appli test (cas production)
# - Si retourne 1 cela signiique que l'update c'est bien passe mais que initcam1954 
#   ne lancera pas l'appli test et que l'utilisateur devra eteindre la camera à trvaers l'appli displayUpdate
#



############################################################################################################################
# debut des fonctions
############################################################################################################################



#########################################
#
#  ensemble de fonctions outils
#
#########################################



#
# Fonction de montage d'une partition 
# cette fonction verifie que le dossier de montage existe
# si ce n'est le cas elle le cree
# renvoie 0 si montage ok et -1 si error
# cette fonction a 4 parametres 
# $1 le dossier de montage et $2 la partition a monter $3 format partition $4 fichier de log ou son renvoyer les messages
MountPart()
{
	local log=$4
	echo "Start MountPart function to mount $2 partition on $1" >> $log
	if [[ ! -d $1 ]]; then
		echo "$1 directory is not found, must be created $1" >> $log
		mkdir $1 2>>$log
	fi
	echo "mounting $2 partition on $1"  
	mount -t $3 $2 $1 2>>$log

	local ret=$?
	if [[ $ret -ne "0" ]]; then
		echo " => $2 partition mount error on $1, returns:$ret" >> $log
		echo "End MountPart function" >> $log
		return -1
	else
		echo "$2 partition mount successfull on $1" >> $log
		echo "End MountPart function" >> $log
		return 0 
	fi #fin if [[ $ret -ne "0" ]]
}

#
# Fonction de demontage d'une partition 
# cette fonction detruit le dossier de montage une fois que le peripherique est demonte
# renvoie 0 si demontage ok et -1 si error
# cette fonction a 2 parametres 
# $1 le dossier de montage  $2 fichier de log ou son renvoyer les messages
UmoutPart()
{
	local log=$2
	echo "Start UmoutPart function to umount $1" >> $log
	umount $1 2>>$log
	local ret=$?
	if [[ $ret -ne "0" ]]; then
		echo " => $1 umount error" >> $log
		echo "End UmoutPart function" >> $log
		return -1
	else
		echo "$1 umount successfull" >> $log
		echo "Removing $1" >> $log
		rm -r $1 2>> $log
		echo "End UmountPart function" >> $log
		return 0 
	fi #fin if [[ $ret -ne "0" ]]
}



#
# Fonction de test MD5
#
# $1 est un fichier MD5
# $2 est l'autre fichier MD5
# $3 la variable a tester (par exemple zImage)
# $4 est fichier de log
#
# Retourne 1 si le md5 est equivalent
# Retourne 0 si le md5 est different
#
TestMd5()
{
	local fileMd5New=$1
	local fileMd5=$2
	local valtest=$3
	local log=$4
	
	echo "Start TestMd5 function with $valtest file." >> $log 
	#read md5 de rootfs
	local Md5New=$(cat $fileMd5New | grep  $valtest)
	local Md5Old=$(cat $fileMd5 | grep  $valtest)
	echo "Md5New of $valtest value:$Md5New" >> $log
	echo "Md5Old of $valtest value:$Md5Old" >> $log
	if [[ $Md5New == $Md5Old ]]; then
		echo "$valtest MD5Checksums are equal" >> $log 
		echo "End TestMd5 function" >> $log
		return 1
	else
		echo "$valtest MD5Checksums are different" >> $log
		echo "End TestMd5 function" >> $log 
		return 0
	fi #fin if [[ $Md5New == $Md5Old ]]
	
}   



#########################################
#
#  ensemble de fonctions update
#
#########################################



#
# Fonction de mise a jour du fichier dtb (elle ne modifie pas le fichier uLinuxEnv.txt)
# cette fonction considere que la partition boot est monter (a voir si c'est bien)
# elle retourne 1 ou 2 si tout c'est bien passe sinon elle retourne -1. 
# 1 ou 2 correspond a l'indice du nouveau dtb indice qu'il faudra modifier
# dans uLinuxEnv.txt
# elle a trois parametre d'entree
#
#$1 est la src le nouveau fichier dtb, $2 est la destination (cette destination doit aussi
# contenir le fichier uLInuxEnv.txt), $3 logfile
# ATTENTION cette fonction utilise la variable global BASE_NAME_DTB
#
UpdateDtb()
{
	local src=$1
	local dest=$2
	local log=$3
	local ret="0"
	echo "Start UpadteDtb function to copy $src dtb file to $dest" >> $log
	if [[ ! -s ${dest}uLinuxEnv.txt ]]; then
		echo " => Error ${dest}uLinuxEnv.txt not found" >> $log
		echo "End UpadteDtb function" >> $log
		return -1
	fi #fin if [[ -s ${dest}uLinuxEnv.txt ]]
	echo "Search fdt_file in ${dest}uLinuxEnv.txt" >> $log
	export $(cat ${dest}uLinuxEnv.txt | grep "fdt_file")
	#la variable d'environement fdt_file
	if [[ -z $fdt_file ]]; then
		echo "No fdt_file not found" >> $log
		echo "End UpadteDtb function" >> $log
		return -1 
	fi #fin if [[ -z $fdt_file ]];

	#trouve le nouvelle indice du nouveau fichier dtb
	local NEW_INDEX_DTB="1" 
	case $fdt_file in
		${BASE_NAME_DTB}1.dtb)
			NEW_INDEX_DTB="2"
		;;
		${BASE_NAME_DTB}2.dtb)
			NEW_INDEX_DTB="1"
		;;
		*)
			NEW_INDEX_DTB="1"
		;;	
	esac
	echo "New dtb file index is $NEW_INDEX_DTB" >> $log
	echo "copy $src to ${dest}${BASE_NAME_DTB}${NEW_INDEX_DTB}.dtb" >> $log
	cp $src ${dest}${BASE_NAME_DTB}${NEW_INDEX_DTB}.dtb 2>> $log
	ret=$?
	if [[ ret -ne "0" ]]; then
		echo " => $src copy error" >> $log
		echo "End UpadteDtb function" >> $log
		return -1 
	fi #fin if [[ ret -ne "0" ]];
	echo "End UpadteDtb function" >> $log
	return $NEW_INDEX_DTB
}


 

 
#
# Fonction de mise a jour de l'application 
# cette fonction en premier regarde si le dossier destination/opt/ est present
# si ce n'est pas le cas elle cree le dossier.
# Puis elle regarde si le dossier destination/opt/bin est presente
# si ce n'est pas le cas elle cree le dossier.
# Puis elle copie l'exe test de la src vers destination/opt/bin
# elle retourne 0 si ok sinon -1 
# elle a trois parametre d'entree
#
# $1 est la src le nouveau fichier app, $2 est la destination (par exemple '/' '/media/rootfs'  ) , $3 logfile
#
UpdateAppli()
{
	local src=$1
	local dest=$2
	local log=$3
	local ret="0"
	echo "Start UpdateAppli function to copy $src to ${dest}opt/bin" >> $log
	#test presence ou non du dossier destination/opt
	echo "Test to find ${dest}opt folder" >> $log
	if [[ ! -d ${dest}opt ]]; then
		echo "Creating ${dest}opt folder" >> $log
		mkdir ${dest}opt 2>> $log
		ret=$?
		if [[ $ret -ne "0" ]]; then
			echo " => Creation Error" >> $log
			echo "End UpdateAppli function" >> $log
			return -1 
		fi #fin if [[ ret -ne "0" ]];	
	fi #fin if [[ ! -d ${dest}opt ]];
	
	#test presence ou non du dossier destination/opt/bin
	if [[ ! -d ${dest}opt/bin ]]; then
		echo "Creating ${dest}opt/bin" >> $log
		mkdir ${dest}opt/bin 2>> $log
		ret=$?
		if [[ $ret -ne "0" ]]; then
			echo " => Creation error" >> $log
			echo "End UpdateAppli function" >> $log
			return -1 
		fi #fin if [[ ret -ne "0" ]];	
	fi #fin if [[ ! -d ${dest}opt/bin  ]];

	#cp file src to destination
	echo "Copy $src to ${dest}opt/bin" >> $log
	cp $src ${dest}opt/bin 2>> $log
	ret=$?
	if [[ $ret -ne "0" ]]; then
		echo " => Copy error" >> $log
		echo "End UpdateAppli function" >> $log
		return -1 
	fi #fin if [[ ret -ne "0" ]];
	echo "End UpdateAppli function" >> $log
	return 0
}



#
# Fonction de mise a jour du fichier MD5
# cette fonction en premier regarde si le dossier destination/opt/ est present
# si ce n'est pas le cas elle cree le dossier.
# Puis elle regarde si le dossier destination/opt/update est presente
# si ce n'est pas le cas elle cree le dossier.
# Puis elle copie le fichier md5 de la src vers destination /opt/update
# elle retourne 0 si ok sinon -1 
# elle a trois parametre d'entree
#
# $1 est la src le nouveau fichier app, $2 est la destination (par exemple '/' '/media/rootfs'  ) , 
# $3 name file md5 pour la destination $4 logfile,
#
UpdateMD5File()
{
	local src=$1
	local dest=$2
	local NamefileMD5=$3
	local log=$4
	local ret="0"
	echo "Start UpdateMD5File function to copy $src to ${dest}opt/update/$NamefileMD5" >> $log
	#test presence ou non du dossier destination/opt
	echo "Test to find ${dest}opt folder" >> $log
	if [[ ! -d ${dest}opt ]]; then
		echo "Creating ${dest}opt folder" >> $log
		mkdir ${dest}opt 2>> $log
		ret=$?
		if [[ $ret -ne "0" ]]; then
			echo " => Ceation error" >> $log
			echo "End UpdateMD5File function" >> $log
			return -1 
		fi #fin if [[ ret -ne "0" ]];	
	fi #fin if [[ ! -d ${dest}opt ]];
	
	#test presence ou non du dossier destination/opt/update
	if [[ ! -d ${dest}opt/update ]]; then
		echo "Creating ${dest}opt/update" >> $log
		mkdir ${dest}opt/update 2>> $log
		ret=$?
		if [[ $ret -ne "0" ]]; then
			echo " => Creation error" >> $log
			echo "End UpdateMD5File function" >> $log
			return -1 
		fi #fin if [[ ret -ne "0" ]];	
	fi #fin if [[ ! -d ${dest}opt/update ]];

	#cp file src to destination
	echo "Copy $src to ${dest}opt/update/$NamefileMD5" >> $log
	cp $src ${dest}opt/update/$NamefileMD5 2>> $log
	ret=$?
	if [[ $ret -ne "0" ]]; then
		echo " => Copy error" >> $log
		echo "End UpdateMD5File function" >> $log
		return -1 
	fi #fin if [[ ret -ne "0" ]];
	echo "End UpdateMD5File function" >> $log
	return 0
}


#
# Fonction de mise a jour des langues
# cette fonction en premier regarde si le dossier destination/opt/ est present
# si ce n'est pas le cas elle cree le dossier.
# Puis elle regarde si le dossier destination/opt/translations est presente
# si ce n'est pas le cas elle cree le dossier.
# Puis elle desarchive l'archive $src vers destination/opt/translations
# elle retourne 0 si ok sinon -1 
# elle a trois parametre d'entree
#
# $1 est la src le nouveau fichier app, $2 est la destination (par exemple '/' '/media/rootfs'  ) , $3 logfile
#
UpdateLanguage()
{
	local src=$1
	local dest=$2
	local log=$3
	local ret="0"
	echo "Start UpdateLanguage function to copy $src to ${dest}opt/translations" >> $log
	#test presence ou non du dossier destination/opt
	echo "Test to find ${dest}opt folder" >> $log
	if [[ ! -d ${dest}opt ]]; then
		#creation du dossier /opt
		echo "Creating ${dest}opt folder" >> $log
		mkdir ${dest}opt 2>> $log
		ret=$?
		if [[ $ret -ne "0" ]]; then
			echo " => Creation error" >> $log
			echo "End UpdateLanguage function" >> $log
			return -1 
		fi #fin if [[ ret -ne "0" ]];	
	fi #fin if [[ ! -d ${dest}opt ]];
	

	#decompresse l'archive vers destination
	echo "#progressFile $NAME_PROGRESS_FILE" >> $log
	echo "Extracting  $src to ${dest}opt/translations" >> $log
	pv -n -i 0.1 $src 2> NAME_PROGRESS_FILE | tar zxf - -C ${dest}opt/ 2>> $log

	ret=$?
	#
	# Verification du code de retour de la commande tar 	
	# SI (le code retour) est egale à 1 alors on stop le script, on sort
	# en erreur.
	#
	if [[ "$ret" -ne "0" ]]; then
		echo " => $src extraction error, returns=$ret" >> $log
		echo "End UpdateLanguage function" >> $log
		return -1 
	else
	    echo "Extraction is successfull" >> $log
	    echo "#progressfile" >> $log
	fi #fin if [[ ret -ne "0" ]];

	echo "End UpdateLanguage function" >> $log
	return 0
}

#
# Fonction de mise a jour des script bluetooth
# cette fonction en premier regarde si le dossier destination/opt/ est present
# si ce n'est pas le cas elle cree le dossier.
# Puis elle regarde si le dossier destination/opt/bluetooth est presente
# si ce n'est pas le cas elle cree le dossier.
# Puis elle desarchive l'archive $src vers destination/opt/bluetooth
# elle retourne 0 si ok sinon -1 
# elle a trois parametre d'entree
#
# $1 est la src le nouveau fichier app, $2 est la destination (par exemple '/' '/media/rootfs'  ) , $3 logfile
#
UpdateBluetooth()
{
	local src=$1
	local dest=$2
	local log=$3
	local ret="0"
	echo "Start UpdateBluetooth function to copy $src to $dest" >> $log
	#test presence ou non du dossier destination/opt
	echo "Test to find ${dest}opt folder" >> $log
	if [[ ! -d ${dest}opt ]]; then
		#creation du dossier /opt
		echo "Creating ${dest}opt folder" >> $log
		mkdir ${dest}opt 2>> $log
		ret=$?
		if [[ $ret -ne "0" ]]; then
			echo " => Creation error" >> $log
			echo "End UpdateBluetooth function" >> $log
			return -1 
		fi #fin if [[ ret -ne "0" ]];	
	fi #fin if [[ ! -d ${dest}opt ]];
	
	
	#decompresse l'archive vers destination
	echo "#progressFile $NAME_PROGRESS_FILE" >> $log
	echo "Extracting  $src to ${dest}opt/bluetooth" >> $log
	pv -n -i 0.1 $src 2> NAME_PROGRESS_FILE | tar zxf - -C ${dest}opt/ 2>> $log

	ret=$?
	#
	# Verification du code de retour de la commande tar 	
	# SI (le code retour) est egale à 1 alors on stop le script, on sort
	# en erreur.
	#
	if [[ "$ret" -ne "0" ]]; then
		echo " => $src extraction error, returns=$ret" >> $log
		echo "End UpdateBluetooth function" >> $log
		return -1 
	else
	    echo "$src extraction is successfull" >> $log
	    echo "#progressfile" >> $log
	fi #fin if [[ ret -ne "0" ]];

	echo "End UpdateBluetooth function" >> $log
	return 0
}


#
# Fonction de mise a jour du rootfs
# - Premiere action determine dans quelle partition  
#  devra etre copier le roots
# - deuxieme action formatage de la partition dans laquelle sera
# copier le nouveau rootfs
# - troisieme action monter cette partition
# - quatrieme action extraire le rootfs src dans la partition monte
# Cette fonction retourne 2 ou 3 si tous se passe bien sinon -1
# 2 ou 3 correspond au numero de la partition ou est copier le root fs
# elle a deux parametres d'entree
#
# $1 est la src de l''archive rootfs $2 repertoir d'install $3 le log file
# Attention cette fonction ne modifie pas uLinuxEnv.txt
# ATTENTION cette fonction ne demonte par install_dir 
# c'est la fonction appelant qui devrat le faire
#
UpdateRootfs()
{
	local src=$1
	local install_dir=$2
	local log=$3
	local numpart="2"
	local name_part1="/dev/mmcblk2p2"
	local name_part2="/dev/mmcblk2p3"
	local name_part_work=$name_part1
	local ret="0"

	echo "Start UpdateRootfs function to copy new rootfs archive $src" >> $log

	#creation du dossier rootfs si necessaire
	if [[ ! -d $install_dir ]]; then

		echo "Creating $install_dir folder" >> $log
		mkdir $install_dir 2>> $log

		ret=$?
		if [[ $ret -ne "0" ]]; then
			echo " => Creation error" >> $log
			echo "End UpdateRootfs function" >> $log
			return -1 
		fi #fin if [[ ret -ne "0" ]];		
	fi #fin if [[ ! -d $install_dir ]];	

	#chercher la partition cible
	echo "Search partition where the new rootfs will be restore" >> $log
	# Le 3eme parametre de la ligne d'arguments de LINUX specifie le rootfs
	export `awk '{print $3}' /proc/cmdline`

	# Le rootfs est installe sur une des 2 partitions  p2 ou p3 de l'eMMC (ping-pong)
	case $root in
    		$name_part1)
		name_part_work=$name_part2
        	numpart="3"
        	;;
    	*)
		name_part_work=$name_part1
        	numpart="2"
        	;;
	esac


	#formatage de la partition name_part_work
	echo "Build linux file system on $name_part_work" >> $log
	mkfs.ext4 -F -j $name_part_work 2>> $log
	ret=$?
	if [[ $ret -ne "0" ]]; then
		echo " => Format error, returns=$ret" >> $log
		echo "End UpdateRootfs function" >> $log
		return -1 
	fi #fin if [[ ret -ne "0" ]];

	#mount partition name_part_work sur install_dir
	echo "Mount the device $name_part_work on $install_dir" >> $log
	mount -t ext4  $name_part_work $install_dir 2>> $log
	ret=$?
	if [[ $ret -ne "0" ]]; then
		echo " => Mount error, returns=$ret" >> $log
		echo "End UpdateRootfs function" >> $log
		return -1 
	fi #fin if [[ ret -ne "0" ]];

	#decompresse l'archive rootfs src dans le dossier d'install
	echo "#progressFile $NAME_PROGRESS_FILE" >> $log
	echo "Extracting  $src to $install_dir" >> $log
	pv -n -i 0.1 $src 2> NAME_PROGRESS_FILE | tar zxf - -C $install_dir 2>> $log
	ret=$?
	#
	# Verification du code de retour de la commande tar 	
	# SI (le code retour) est egale à 1 alors on stop le script, on sort
	# en erreur.
	#
	if [[ "$ret" -ne "0" ]]; then
		echo " => Extraction error, returns=$ret" >> $log
		echo "Umount and delete $install_dir" >> $log
		umount $install_dir
		rm -r -f $install_dir
		echo "End UpdateRootfs function" >> $log
		return -1 
	else
    	echo "$src extraction is finished" >> $log
	    echo "#progressfile" >> $log
	fi #fin if [[ ret -ne "0" ]];
	

	echo "End UpdateRootfs function" >> $log
	#retourne le numero de partition 
	return $numpart
}

#
# Fonction de mise a jour du kernel linux (elle ne modifie pas le fichier uLinuxEnv.txt)
# elle retourne 1 ou 2 si tout c'est bien passe sinon elle retourne -1. 
# 1 ou 2 correspond a l'indice du nouveau zImage indice qu'il faudra modifier
# dans uLinuxEnv.txt
# elle a trois parametre d'entree
#
#$1 est la src le nouveau fichier zImage, $2 est la destination (cette destination doit aussi
# contenir le fichier uLInuxEnv.txt), $3 logfile
# ATTENTION cette fonction utilise la variable global BASE_NAME_KERNEL
#
UpdateKernel()
{
	local src=$1
	local dest=$2
	local log=$3
	local ret="0"
	echo "Start UpdateKernel function to copy $src to $dest" >> $log
	if [[ ! -s ${dest}uLinuxEnv.txt ]]; then
		echo " => Error ${dest}uLinuxEnv.txt not found" >> $log
		echo "End UpdateKernel function" >> $log
		return -1
	fi
	echo "Search image in ${dest}uLinuxEnv.txt file" >> $log
	export $(cat ${dest}uLinuxEnv.txt | grep "image")
	#la variable d'environement image
	if [[ -z $image ]]; then
		echo "Image not found" >> $log
		echo "End UpdateKernel function" >> $log
		return -1 
	fi #fin if [[ -z $image ]];

	#trouve le nouvelle indice du nouveau fichier dtb
	local NEW_INDEX_ZIMAGE="1"
	echo "Find $image in ${dest}uLinuxEnv.txt"  >> $log
	case $image in
		${BASE_NAME_KERNEL}1)
			NEW_INDEX_ZIMAGE="2"
		;;
		*)
			NEW_INDEX_ZIMAGE="1"
		;;	
	esac
	echo "Copy new zImage file $src to ${dest}${BASE_NAME_KERNEL}${NEW_INDEX_ZIMAGE}" >> $log
	cp $src ${dest}${BASE_NAME_KERNEL}${NEW_INDEX_ZIMAGE} 2>> $log
	ret=$?
	if [[ ret -ne "0" ]]; then
		echo " => Copy error" >> $log
		echo "End UpdateKernel function" >> $log
		return -1 
	fi #fin if [[ ret -ne "0" ]];
	echo "End UpdateKernel function" >> $log
	return $NEW_INDEX_ZIMAGE
}

#
# Fonction de mise a jour global qui appelle toutes les fonction de mise 
# a jour et qui met jour ulinuxEnv.txt
# Cette fonction a deux parametres 
# $1 le workdir
# $2 le logfile
#
# Cette fonction retourne 0 si ok sinon
# -1 si erreur dans update rootfs
# -2 si erreur dans update kernel
# -3 si erreur dans update dtb
# -4 si erreur dans update application
# -5 si erreur dans update language
# -6 si erreur dans update bluetooth
# -7 si erreur dans update md5
# -8 si erreur ecriture dans uLinuxenv 
# ATTENTION elle utilise les variables globales suivante
#  NAME_FILE_ROOTFS
#  NAME_FILE_ZIMAGE
#  NAME_FILE_DTB
#  NAME_FILE_APP
#  NAME_FILE_TRANSLATION
#  NAME_FILE_BLUETOOTH
#  PATH_ROOT_INSTALL
#  PATH_BOOT

UpdateAll()
{
	local workdir=$1
	local log=$2
	local numpartrootfs="2"
	local extzImage="1"
	local extDtb="1"
	local ret="0"

	#etape 1 mise a jour du rootfs
	echo "Start UpdateAll function" >> $log

	echo " "
	echo "- Update $NAME_FILE_ROOTFS files" >> $log
	UpdateRootfs ${workdir}$NAME_FILE_ROOTFS $PATH_ROOT_INSTALL $log
	#recuperer la sortie de la fonction UpdateRootfs
	numpartrootfs=$?
	#les valeurs de retour negatives sont superieures a 100
	if [[ $numpartrootfs -gt "100" ]]; then
		echo " => UpdateRootfs function error, returns:$numpartrootfs" >> $log
		echo "End UpdateAll function" >> $log
		return -1
	fi #fin if [[ $numpartrootfs -gt "100" ]];

	#etape 2 update kernel
	echo " "
	echo "- Update $NAME_FILE_ZIMAGE file" >> $log
	UpdateKernel ${workdir}$NAME_FILE_ZIMAGE $PATH_BOOT $log
	#recuperer la sortie de la fonction UpdateRootfs
	extzImage=$?
	#les valeurs de retour negatives sont superieures a 100
	if [[ $extzImage -gt "100" ]]; then
		echo " => UpdateKernel function error, returns:$extzImage" >> $log
		#demonter le dossier d'intalle du rootfs monter par la fonction UpdateRootfs
		echo "Umount $PATH_ROOT_INSTALL" >> $log
		UmoutPart $PATH_ROOT_INSTALL $log
		echo "End UpdateAll function" >> $log
		return -2
	fi #fin if [[ $extzImage -gt "100" ]];


	#etape 3 update dtb
	echo " "
	echo "- Update $NAME_FILE_DTB file" >> $log
	UpdateDtb ${workdir}$NAME_FILE_DTB $PATH_BOOT $log
	#recuperer la sortie de la fonction UpdateRootfs
	extDtb=$?
	#les valeurs de retour negatives sont superieures a 100
	if [[ $extDtb -gt "100" ]]; then
		echo " => UpadteDtb function error, returns:$extDtb" >> $log
		#demonter le dossier d'intalle du rootfs monter par la fonction UpdateRootfs
		echo "Umount $PATH_ROOT_INSTALL" >> $log
		UmoutPart $PATH_ROOT_INSTALL $log
		echo "End UpdateAll function" >> $log
		return -2
	fi #fin if [[ $extDtb -gt "100" ]];

	#etape 4 update applicatif
	echo " "
	echo "- Update $NAME_FILE_APP file" >> $log
	#la destination de update appli est PATH_ROOT_INSTALL dossier monter par UpdateRootfs
	UpdateAppli ${workdir}$NAME_FILE_APP $PATH_ROOT_INSTALL $log
	#recuperer la sortie de la fonction UpdateAppli
	ret=$?
	if [[ $ret -ne "0" ]]; then
		echo " => UpdateAppli function error, returns:$ret" >> $log
		#demonter le dossier d'intalle du rootfs monter par la fonction UpdateRootfs
		echo "Umount $PATH_ROOT_INSTALL" >> $log
		UmoutPart $PATH_ROOT_INSTALL $log
		echo "End UpdateAll function" >> $log
		return -4
	fi #fin if [[ $ret -ne "0" ]];


	#etape 5 update language
	echo " "
	echo "- Update $NAME_FILE_TRANSLATION file" >> $log
	#la destination de update translation est PATH_ROOT_INSTALL dossier monter par UpdateRootfs
	UpdateLanguage ${workdir}$NAME_FILE_TRANSLATION $PATH_ROOT_INSTALL $log
	#recuperer la sortie de la fonction UpdateLanguage
	ret=$?
	if [[ $ret -ne "0" ]]; then
		echo " => UpdateLanguage function error, returns:$ret" >> $log
		#demonter le dossier d'intalle du rootfs monter par la fonction UpdateRootfs
		echo "Umount $PATH_ROOT_INSTALL" >> $log
		UmoutPart $PATH_ROOT_INSTALL $log
		echo "End UpdateAll function" >> $log
		return -5
	fi #fin if [[ $ret -ne "0" ]];
	#gestion de l'hebreux
    ret=$(ls ${PATH_OPT}translations | grep "he_IL.txt")
    if [[ $ret == "he_IL.txt" ]]; then
        mv ${PATH_ROOT_INSTALL}opt/translations/he_IL.t__ ${PATH_ROOT_INSTALL}opt/translations/he_IL.txt
        echo " Hebrew language is found in old directory and reinstalled." >> $log
    fi	

	#etape 6 update script bluetooth
	echo " "
	echo "- Update $NAME_FILE_BLUETOOTH files" >> $log
	#la destination de update translation est PATH_ROOT_INSTALL dossier monter par UpdateRootfs
	UpdateBluetooth ${workdir}$NAME_FILE_BLUETOOTH $PATH_ROOT_INSTALL $log
	#recuperer la sortie de la fonction UpdateBluetooth
	ret=$?
	if [[ $ret -ne "0" ]]; then
		echo " => UpdateBluetooth function error, returns:$ret" >> $log
		#demonter le dossier d'installe du rootfs monter par la fonction UpdateRootfs
		echo "Umount $PATH_ROOT_INSTALL" >> $log
		UmoutPart $PATH_ROOT_INSTALL $log
		echo "End UpdateAll function" >> $log
		return -6
	fi #fin if [[ $ret -ne "0" ]];

	#etape 7 copy new md5 file
	echo " "
	echo "- Update MD5 file" >> $log
	UpdateMD5File ${workdir}$NAME_FILE_MD5_NEW $PATH_ROOT_INSTALL $NAME_FILE_MD5 $log
	#recuperer la sortie de la fonction UpdateMD5File
	ret=$?
	if [[ $ret -ne "0" ]]; then
		echo " => UpdateMD5File function error, returns:$ret" >> $log
		#demonter le dossier d'install du rootfs monter par la fonction UpdateRootfs
		echo "Umount $PATH_ROOT_INSTALL" >> $log
		UmoutPart $PATH_ROOT_INSTALL $log
		echo "End UpdateAll function" >> $log
		return -7
	fi #fin if [[ $ret -ne "0" ]];
 
	#etape 8 modifier uLinuxEnv
	echo " "
	echo "- Modify ulinuxEnv.txt file" >> $log
	cp ${PATH_BOOT}ulinuxEnv.txt ulinuxEnvTempStart
	#modification peut etre temporaire a voir s'il ne faudra pas la supprimer par la suite une fois que toutes les cartes seront mise a jour
	echo "Change mmcargs to add uboot version"   >> $log
	SearchvBoot=$(cat ulinuxEnvTempStart | grep "vboot=\${bootcaver}")
	if [[ -z $SearchvBoot ]] ; then
		sed -e "s/mmcargs=setenv bootargs console=\${console},\${baudrate} vt.global_cursor_default=0 root=\${mmcroot}/mmcargs=setenv bootargs console=\${console},\${baudrate} vt.global_cursor_default=0 root=\${mmcroot} vboot=\${bootcaver}/" ulinuxEnvTempStart > ulinuxEnvTemp
	else
		echo "The uboot version already exist" >> $log
		cp ulinuxEnvTempStart ulinuxEnvTemp
	fi
	echo "Change rootfs path in ulinuxEnv.txt"  >> $log
	#modifier le path rootfs 
	sed -e "s/mmcroot=\/dev\/mmcblk2p[2-3] rootfstype=ext4  rootwait rw/mmcroot=\/dev\/mmcblk2p$numpartrootfs rootfstype=ext4  rootwait rw/" ulinuxEnvTemp > ulinuxEnvTemp1
	ret=$?
	if [[ $ret -ne "0" ]]; then
		echo " => sed ulinuxEnvTemp > ulinuxEnvTemp1 function error, returns:$ret" >> $log
		#demonter le dossier d'installe du rootfs monter par la fonction UpdateRootfs
		echo "Umount $PATH_ROOT_INSTALL" >> $log
		UmoutPart $PATH_ROOT_INSTALL $log
		echo "End UpdateAll function" >> $log
		return -8
	fi
	echo "Change zImage index in ulinuxEnv.txt"  >> $log
	#modifier l'index de zimage
	sed -e "s/image=zImage_[1-2]/image=zImage_$extzImage/" ulinuxEnvTemp1 > ulinuxEnvTemp2
	ret=$?
	if [[ $ret -ne "0" ]]; then
		echo " => sed ulinuxEnvTemp1 > ulinuxEnvTemp2 function error, returns:$ret" >> $log
		#demonter le dossier d'installe du rootfs monter par la fonction UpdateRootfs
		echo "Umount $PATH_ROOT_INSTALL" >> $log
		UmoutPart $PATH_ROOT_INSTALL $log
		echo "End UpdateAll function" >> $log
		return -9
	fi
	#modifier l'index de dtb file
	echo "Change dtb file index in ulinuxEnv.txt"  >> $log
	sed -e "s/fdt_file=imx7d-ca1954_[1-2].dtb/fdt_file=imx7d-ca1954_$extDtb.dtb/" ulinuxEnvTemp2 > ${PATH_BOOT}ulinuxEnv.txt
	ret=$?
	if [[ $ret -ne "0" ]]; then
		echo " => sed ulinuxEnvTemp2 > ${PATH_BOOT}ulinuxEnv.txt function error, returns:$ret" >> $log
		#demonter le dossier d'installe du rootfs monter par la fonction UpdateRootfs
		echo "Umount $PATH_ROOT_INSTALL" >> $log
		UmoutPart $PATH_ROOT_INSTALL $log
		echo "End UpdateAll function" >> $log
		return -9
	fi
	
   #modification des droits du repertoire /opt
   find $INSTALL_OPT_PATH -exec chown root:root {} \;
   find $INSTALL_OPT_PATH -exec chmod a+rwx {} \;

	#demonter le dossier d'installe du rootfs monter par la fonction UpdateRootfs
	echo "Umount $PATH_ROOT_INSTALL" >> $log
	UmoutPart $PATH_ROOT_INSTALL $log
	
	echo "End UpdateAll function" >> $log

	return 0
}


#
# Fonction de mise a jour du uboot
# cette fonction en premier regarde si le fichier u-boot est present
# puis, si le code MD5 est different.
# si le code est different, elle demande a l'utilisateur si il souhaite
# faire la mise à jour
#
# elle a 5 parametres d'entree
# $1 est le nom du fichier u-boot, 
# $2 est le path du fichier u-boot,
# $3 est le path du fichier MD5FileToBeInstalled.txt
# $4 est le path du fichier MD5FileInstalled.txt
# $5 est le logfile
#
# elle retourne: 0 si pas de mise à jour, 1 si mise à jour effectuée
#
UpdateUBoot()
{
   local ubootname=$1
   local ubootpath=$2
   local md5new=$3
   local md5=$4
   local log=$5
   local ret=0
   #test si fichier u-boot present
   if [[ -s $ubootpath ]] ; then
      echo "$ubootname is found." >> $log
		TestMd5 $md5new $md5 $ubootname $log
	   ret=$?
	   if [[ $ret -eq  "0" ]]; then
		   echo "$ubootname MD5Checksums are different, u-boot file update is necessary" >> $log
         echo "#confirmmsg #msgwarning \"Update Request\" \"$ubootname is found. u-boot update is critical and must not be interrupted. Be sure you have enough battery to do it. Do you want to update u-boot software?\"" >>  $log
         touch $PATH_CONFIRM_MES_RESP
         read resp < $PATH_CONFIRM_MES_RESP
         while [[ -z $resp ]]; do
	         read resp < $PATH_CONFIRM_MES_RESP
         done
         rm -f $PATH_CONFIRM_MES_RESP
         if [[ $resp -eq "0" ]]; then
	         echo "No u-boot update requested" >> $log
	         #on enleve la ligne u-boot-spi.imx du fichier des MD5 car pas mis à jour
	         echo "copy previous $ubootname line in $md5new" >> $log
	         sed "/"$ubootname"/d" $md5new > toto.txt
	         mv toto.txt $md5new
	         #on recupere celle du fichier MD5FileInstalled.txt si presente
	         TEMP=$(cat $md5 | grep $ubootname)
	         if [[ -n $TEMP ]]; then
	            #la ligne existe: on la rajoute en fin de fichier
	            echo $TEMP >> $md5new
	         fi
	      else
	         #lancement de la mise a jour u-boot
	         ret=1
	         echo "starting uboot update:" >> $log
	         echo " - erasing memory..." >> $log
	         flash_erase /dev/mtd0 0 0
	         echo " - writing memory..." >> $log
	         dd if=$ubootpath of=/dev/mtd0 bs=1k seek=1
	         echo " u-boot update is complete."
         fi #fin if [[ $resp -eq "0" ]]; then
      else
         echo "$ubootname MD5Checksums are equal, u-boot file doesn't need update" >> $log	         
      fi #fin if [[ $ret -eq  "0" ]]; then
   else
      echo "no u-boot file found!" >> $log
      #pour conserver la ligne u-boot dans le fichier MD5FileInstalled.txt en fin de maj:
      #on enleve la ligne u-boot-spi.imx du fichier MD5FileToBeInstalled.txt car pas de fichier
	   echo "copy previous $ubootname line in $md5new" >> $log
      sed "/"$ubootname"/d" $md5new > toto.txt
      mv toto.txt $md5new
      #on recupere celle du fichier MD5FileInstalled.txt si presente
      TEMP=$(cat $md5 | grep $ubootname)
      if [[ -n $TEMP ]]; then
         #la ligne existe: on la rajoute en fin de fichier MD5FileToBeInstalled.txt
         echo $TEMP >> $md5new
      fi
   fi #fin if [[ -s $uboot ]] ; then
	echo "End UpdateUBoot function" >> $log
   return $ret
}


########################################################################################################################################################
#  fin des fonctions, debut du script principal
########################################################################################################################################################

#
# Script general de mise a jour il attend un parametre le fichier de log
#  etape 1  verifier la presence du fichier log
#  etape 2 lire la version hardward de la carte
#  etape 3 verifier que la version hard a son archive
#  etape 4 decompression de l'archive et montage du /media/boot
#  etape 5 test pour savoir si mode production ou si mode mise a jour classique (test de la presence du dossier /opt)
#
# 	cas mode mise a jour classique
#		etape 1 :  calcul du md5 rootfs et kernel et test si different
#		etape 2 :  si cas md5 different pour rootfs ou kernel alors mise à jour totale
#		etape 3 :  si cas md5 egale pour rootfs et kernel alors mise a jour du reste a la carte selon md5
#
#
#	cas du mode production
#		etape 1 : calcul du md5 de zImage_1
#		etape 2 : cas md5 egal alors mise a jour de l'applicatif, de la langue, et de bluetooth, et du fichier md5
#		etape 3 : cas du md5 different mis à jour totale 
#
# Ce script retourne les valeurs suivantes
#  0 si mise a jour production reussie, ne demande pas un redemarrage de la camera et ne pas effacer l'archive update de la sdcard
#  1 si mise a jour production reussie (update all) demande un redemarrage de la camera et ne pas effacer l'archive update de la sdcard
#  2 si mise a jour client reussie demande un redemarrage de la camera et effacement de l'archive update de la sdcard 
#  3 si mise a jour client reussie ne demande pas un redémarrage de la camera et effacement de l'archive update de la sdcard  
#  4 si mise a jour client alors que le systeme est déjà à jour et effacement de l'archive update de la sdcard 
#  <0 si erreur dans la mise jour et effacement de l'archive update de la sdcard. Celle-ci devra etre refaite 
# 

#ensemble des paths utils pour la mise à jour
USER_PATH=/home/root/
UPDATE_PATH=/home/root/update/
PATH_BOOT=/media/boot/
PATH_ROOT_INSTALL=/media/rootfs/
PARTITION_BOOT=/dev/mmcblk2p1
INSTALL_OPT_PATH=${PATH_ROOT_INSTALL}opt/
WORK_DIR=`pwd`
PATH_OPT=/opt/
PATH_OPT_UPDATE=${PATH_OPT}update/


#base de nom pour ecrire dans le fichier ulinuxEnv
BASE_NAME_DTB="imx7d-ca1954_"
BASE_NAME_KERNEL="zImage_"


#nom des differents fichiers se trouvant dans une archive update
NAME_FILE_ROOTFS="core-image-minimal.rootfs.tar.gz"
NAME_FILE_ZIMAGE="zImage"
NAME_FILE_DTB="imx7d-ca1954.dtb"
NAME_FILE_APP="test"
NAME_FILE_TRANSLATION="translations.tar.gz"
NAME_FILE_BLUETOOTH="bluetooth.tar.gz"
NAME_FILE_MD5_NEW="MD5FileToBeInstalled.txt"
NAME_FILE_MD5="MD5FileInstalled.txt"
NAME_FILE_U_BOOT="u-boot-spi.imx"
PATH_CONFIRM_MES_RESP=/tmp/confirmMsgResp.txt
NAME_PROGRESS_FILE=/tmp/progressFile.txt


#ensemble des variables pour tester le hardward
#valeur pin CFG
PIN_CFG_U0=163
PIN_CFG_U1=164
PATH_PIN_CFG_U0=/sys/class/gpio/gpio${PIN_CFG_U0}/
PATH_PIN_CFG_U1=/sys/class/gpio/gpio${PIN_CFG_U1}/
EXPORT_GPIO=/sys/class/gpio/export




#ce placer dans le dossier de travail
cd $UPDATE_PATH

#  etape 1 #

#test de la presence de l'argument le file log
if [[ $# -ne "1" ]]; then
	echo "No parameter found, to use this script add parameter (path to file log)" >> $PATH_LOG
	exit -1
fi

#recuperer le path du fichier de log
PATH_LOG=$1


#  etape 2 #
echo "Read hardware configuration" >> $PATH_LOG
#configuration pin hardware pour detection version hardware
#test de la non presence du directory PATH_PIN_CFG_U0
if [[ ! -d $PATH_PIN_CFG_U0 ]]; then
	echo $PIN_CFG_U0 >> $EXPORT_GPIO 2>>$PATH_LOG
	#test si la gpio a bien ete creee
	RETVAL=$?
	if [[ $RETVAL -ne "0" ]]; then
		echo " => Error $RETVAL to export gpio CFG_U0" >> $PATH_LOG
		exit -2
	fi	
fi
#test de la non presence du directory PATH_PIN_CFG_U1
if [[ ! -d $PATH_PIN_CFG_U1 ]]; then
	echo $PIN_CFG_U1 >> $EXPORT_GPIO 2>>$PATH_LOG
	#test si la gpio a bien ete creee
	RETVAL=$?
	if [[ $RETVAL -ne "0" ]]; then
		echo " => Error $RETVAL to export gpio CFG_U1" >> $PATH_LOG
		exit -3
	fi	
fi

#programmation de la direction les deux pins sont en entrees
echo "in" >> ${PATH_PIN_CFG_U0}direction
echo "in" >> ${PATH_PIN_CFG_U1}direction

#lecture de chaque pin pour etablir la version hardware
VALUE_PIN_CFG_U0=$(cat ${PATH_PIN_CFG_U0}value)
VALUE_PIN_CFG_U1=$(cat ${PATH_PIN_CFG_U1}value)

#creation du mot binaire de la version hardward
VERSION_HARD_BIN=${VALUE_PIN_CFG_U1}$VALUE_PIN_CFG_U0
 

#en fonction de la version hard binaire construction du nom de fichier de l'archive a utiliser
case $VERSION_HARD_BIN in
	00)
		FIRST_NAME_ARCHIVE="V01"
	;;
	01)
		FIRST_NAME_ARCHIVE="V02"
	;;
	10)
		FIRST_NAME_ARCHIVE="V03"
	;;
	11)
		FIRST_NAME_ARCHIVE="V04"
	;;
	*)
		echo " => Read error of hardward version : $VERSION_HARD_BIN" >> $PATH_LOG
		exit -4
	;;
esac

echo "$FIRST_NAME_ARCHIVE hardware version is found" >> $PATH_LOG


# etape 3 #

#recherche de l'archive selon la version hard trouvee
FILE_NAME_ARCHIVE=$(ls | grep "${FIRST_NAME_ARCHIVE}.[0-9][0-9].tar.gz" | head -n 1)

if [[ -z $FILE_NAME_ARCHIVE ]]; then
	echo " => Error no archive file found for $FIRST_NAME_ARCHIVE hardware" >> $PATH_LOG
	exit -5 
fi


# etape 4 #

#decompression de l'archives dans update
echo "#progressFile $NAME_PROGRESS_FILE" >> $PATH_LOG
echo "$FILE_NAME_ARCHIVE is extracting..." >> $PATH_LOG
pv -n -i 0.1 $FILE_NAME_ARCHIVE 2> $NAME_PROGRESS_FILE | tar zxf - 2>> $PATH_LOG 

#la decompression s'est elle bien passee 
RETVAL=$?

#
# Verification du code de retour de la commande tar 	
# SI (le code retour) est egale à 1 alors on stop le script, on sort
# en erreur.
#
if [[ "$RETVAL" -ne "0" ]]; then
	echo " => Error in $FILE_NAME_ARCHIVE extraction, returns:$RETVAL" >> $PATH_LOG
	exit -6
else
    echo "extraction is successfull" >> $PATH_LOG
    echo "#progressfile" >> $PATH_LOG
fi

#mount the folder boot
MountPart $PATH_BOOT $PARTITION_BOOT "vfat" $PATH_LOG


#tous les elements sont la pour pouvoir faire la mise a jour
#maintenant gestion des deux cas : premier demarrage et mise à jour classique client
#test presence repertoire /opt
if [[ -d $PATH_OPT ]]; then


	###############################
	#    Cas mise a jour client   #
	###############################   

	# etape 1 mac# 			


	#le repertoire opt existe donc nous ne sommes pas dans un cas de premier demarrage
	#test du md5 de rootfs et de zimage
	echo "Check $NAME_FILE_ROOTFS and $NAME_FILE_ZIMAGE MD5Checksum"  >> $PATH_LOG
	TestMd5 ${UPDATE_PATH}$NAME_FILE_MD5_NEW ${PATH_OPT_UPDATE}$NAME_FILE_MD5 $NAME_FILE_ROOTFS $PATH_LOG
	#retour du test md5 rootfs	
	RetMd5Rootfs=$?
	TestMd5 ${UPDATE_PATH}$NAME_FILE_MD5_NEW ${PATH_OPT_UPDATE}$NAME_FILE_MD5 $NAME_FILE_ZIMAGE $PATH_LOG
	#retour du test md5 rootfs	
	RetMd5zImage=$?

	#test pour savoir si c'est une mise jour totale ou non
	if [[  $RetMd5Rootfs -eq "0" || $RetMd5zImage -eq "0" ]]; then

		# etape 2 mac# 	
		
		echo "$NAME_FILE_ROOTFS or $NAME_FILE_ZIMAGE have changed" >> $PATH_LOG
		echo "Update all is necessary" >> $PATH_LOG
		
		#mise a jour du u-boot si le fichier est present dans l'archive
		echo " "
		echo "- Does $NAME_FILE_U_BOOT need update?" >> $PATH_LOG
		TEMP = $(UpdateUBoot $NAME_FILE_U_BOOT ${UPDATE_PATH}$NAME_FILE_U_BOOT ${UPDATE_PATH}$NAME_FILE_MD5_NEW ${PATH_OPT_UPDATE}$NAME_FILE_MD5 $PATH_LOG)
      if [[ $TEMP -eq 1 ]]; then
         # une maj est faite, il faut redemarrer la camera
         UpdateDone=1
         NeedReboot=1
      fi

		#mise a jour de tout le reste
		UpdateAll $UPDATE_PATH $PATH_LOG
		retUpdatAll=$?
		if [[ $retUpdatAll -ne "0" ]]; then
			echo " => Error with UpdateAll function, returns:$retUpdatAll" >> $PATH_LOG
			UmoutPart $PATH_BOOT $PATH_LOG
			exit -7
		else
			echo "Update all successfull" >> $PATH_LOG
			UmoutPart $PATH_BOOT $PATH_LOG

			#retourne 2 pour dire que la mise à jour c'est bien passe mais qu' il faut un redemmarrage
 			exit 2
		fi
		
	else
		#verifier le md5 des autres paquets pour des mises à jour individuelles
		echo "$NAME_FILE_ROOTFS and $NAME_FILE_ZIMAGE are inchanged." >> $PATH_LOG
		echo "Check for other changes:" >> $PATH_LOG

		NeedReboot=0
		UpdateDone=0
		# etape 3 mac# 
		
		############
		# file dtb #
      ############

		#variable qui indique si il faut changer le fichier uLinuxEnv.txt
		ChangeUlinuxenv=0
		echo " "
		echo "- Does $NAME_FILE_DTB need update?" >> $PATH_LOG
		TestMd5 ${UPDATE_PATH}$NAME_FILE_MD5_NEW ${PATH_OPT_UPDATE}$NAME_FILE_MD5 $NAME_FILE_DTB $PATH_LOG
		ret=$?
		if [[ $ret -eq  "0" ]]; then
			#un redemarrage est necessaire
			NeedReboot=1
			UpdateDone=1
			echo "$NAME_FILE_DTB MD5Checksum is different, dtb update is necessary" >> $PATH_LOG
			UpdateDtb ${UPDATE_PATH}$NAME_FILE_DTB $PATH_BOOT $PATH_LOG
			retdtb=$?
			#les valeurs de retour negatives sont superieures a 100
			if [[ $retdtb -gt "100" ]]; then
				echo " => Error in $NAME_FILE_DTB update, returns:$retdtb" >> $PATH_LOG
				UmoutPart $PATH_BOOT $PATH_LOG
				exit -8
			else
				echo "$NAME_FILE_DTB update successfull." >> $PATH_LOG
				#valide le changement de uLinuxEnv.txt
				ChangeUlinuxenv=1
			fi #if [[ $retdtb -gt "100" ]]; then 
		fi # fin du if [[ $ret -eq  "0" ]]; then


		###############
		# application #
      ###############

		echo " "
		echo "- Does $NAME_FILE_APP need update?" >> $PATH_LOG
		TestMd5 ${UPDATE_PATH}$NAME_FILE_MD5_NEW ${PATH_OPT_UPDATE}$NAME_FILE_MD5 $NAME_FILE_APP $PATH_LOG
		ret=$?
		if [[ $ret -eq  "0" ]]; then
			echo "$NAME_FILE_APP MD5Checksum is different, application update is necessary" >> $PATH_LOG
			UpdateDone=1
			#le path de destination est le rootfs actuel
			UpdateAppli ${UPDATE_PATH}$NAME_FILE_APP "/" $PATH_LOG
			ret=$?
			#les valeurs de retour negatives sont superieures a 100
			if [[ $ret -gt "100" ]]; then
				echo " => Error in $NAME_FILE_APP update, returns:$ret" >> $PATH_LOG
				UmoutPart $PATH_BOOT $PATH_LOG
				exit -9
			else
				echo "$NAME_FILE_APP update successfull." >> $PATH_LOG
			fi # fin if [[ $ret -gt "100" ]]
		fi # fin du if [[ $ret -eq  "0" ]]
		

		###############
		# language #
      ###############

		echo " "
		echo "- Does $NAME_FILE_TRANSLATION need update?" >> $PATH_LOG
		TestMd5 ${UPDATE_PATH}$NAME_FILE_MD5_NEW ${PATH_OPT_UPDATE}$NAME_FILE_MD5 $NAME_FILE_TRANSLATION $PATH_LOG
		ret=$?
		if [[ $ret -eq  "0" ]]; then
			UpdateDone=1
			echo "$NAME_FILE_TRANSLATION MD5Checksum is different, translations file update is necessary" >> $PATH_LOG
		    #gestion de l'hebreux
            hebrew=$(ls ${PATH_OPT}translations | grep "he_IL.txt")

			#le path de destination est le rootfs actuel
			UpdateLanguage ${UPDATE_PATH}$NAME_FILE_TRANSLATION "/" $PATH_LOG
			ret=$?
			#les valeurs de retour negatives sont superieures a 100
			if [[ $ret -gt "100" ]]; then
				echo " => Error in update $NAME_FILE_TRANSLATION update, returns:$ret" >> $PATH_LOG
				UmoutPart $PATH_BOOT $PATH_LOG
				exit -10
			else
		        #l'hebrew doit il etre reinstalle?
                if [[ $hebrew == "he_IL.txt" ]]; then
                    mv ${PATH_OPT}translations/he_IL.t__ ${PATH_OPT}translations/he_IL.txt
                    echo " Hebrew language is found in old directory and reinstalled." >> $PATH_LOG
                fi	
				echo "$NAME_FILE_TRANSLATION update successfull." >> $PATH_LOG
			fi # fin if [[ $ret -gt "100" ]]
		fi # fin du if [[ $ret -eq  "0" ]]; then



		###############
		# bluetooth   #
      ###############

		echo " "
		echo "- Does $NAME_FILE_BLUETOOTH need update?" >> $PATH_LOG
		TestMd5 ${UPDATE_PATH}$NAME_FILE_MD5_NEW ${PATH_OPT_UPDATE}$NAME_FILE_MD5 $NAME_FILE_BLUETOOTH $PATH_LOG
		ret=$?
		if [[ $ret -eq  "0" ]]; then
			UpdateDone=1
			echo "$NAME_FILE_BLUETOOTH MD5Checksum is different, bluetooth file update is necessary" >> $PATH_LOG
			#le path de destination est le rootfs actuel
			UpdateBluetooth ${UPDATE_PATH}$NAME_FILE_BLUETOOTH "/" $PATH_LOG
			ret=$?
			#les valeurs de retour negatives sont superieures a 100
			if [[ $ret -gt "100" ]]; then
				echo " => Error in $NAME_FILE_BLUETOOTH update, returns:$ret"  >> $PATH_LOG
				UmoutPart $PATH_BOOT $PATH_LOG
				exit -10
			else
				echo "$NAME_FILE_BLUETOOTH update successfull."  >> $PATH_LOG
			fi
		fi # fin du if [[ $ret -eq  "0" ]]; then 


		###############
		# u-boot      #
      ###############
		#mise a jour du u-boot si le fichier est present dans l'archive
		echo " "
		echo "- Does $NAME_FILE_U_BOOT file need update?" >> $PATH_LOG
		UpdateUBoot $NAME_FILE_U_BOOT ${UPDATE_PATH}$NAME_FILE_U_BOOT ${UPDATE_PATH}$NAME_FILE_MD5_NEW ${PATH_OPT_UPDATE}$NAME_FILE_MD5 $PATH_LOG
		#recuperer la sortie de la fonction UpdateUBoot
		ret=$?
		if [[ $ret -eq 1 ]]; then
         # une maj est faite, il faut redemarrer la camera
         echo "Camera restart is needed." >> $PATH_LOG
         UpdateDone=1
         NeedReboot=1
      fi


		######################
		# MD5FileInstalled   #
      ######################
		if [[ $UpdateDone -eq "1" ]]; then
		   echo " "
			echo "- Update $NAME_FILE_MD5 file" >> $PATH_LOG
			UpdateMD5File ${UPDATE_PATH}$NAME_FILE_MD5_NEW "/" $NAME_FILE_MD5 $PATH_LOG
			#recuperer la sortie de la fonction UpdateMD5File
			ret=$?
			if [[ $ret -ne "0" ]]; then
				echo " => Error in UpdateMD5File update, returns:$ret" >> $PATH_LOG
				UmoutPart $PATH_BOOT $PATH_LOG
				exit -11
			fi #fin if [[ $ret -ne "0" ]];
		fi

      #modification des droits du repertoire /opt
      find $PATH_OPT -exec chown root:root {} \;
      find $PATH_OPT -exec chmod a+rwx {} \;

		#########################################################
		# modification du fichier  uLinuxEnv.txt si necessaire  #
      #########################################################
		
		#le fichier uLinuxEnv.txt doit 'il etre modifie
		echo " "
		echo "- Does uLinuxEnv.txt need to be modified?"  >> $PATH_LOG
		if [[ $ChangeUlinuxenv -eq "1" ]]; then
			echo "Modify ulinuxEnv.txt file" >> $PATH_LOG
			cp ${PATH_BOOT}ulinuxEnv.txt ulinuxEnvTemp
			echo "Change dtb file index in ulinuxEnv.txt"  >> $PATH_LOG
	      sed -e "s/fdt_file=imx7d-ca1954_[1-2].dtb/fdt_file=imx7d-ca1954_$retdtb.dtb/" ulinuxEnvTemp > ${PATH_BOOT}ulinuxEnv.txt
		fi #fin if [[ $ChangeUlinuxenv -eq "1" ]]

		UmoutPart $PATH_BOOT $PATH_LOG
		if [[ $UpdateDone -eq "1" ]]; then
			if [[ NeedReboot -eq "0" ]]; then
				#retourne 3 pour dire que la mise à jour c'est bien passe mais qu' il ne faut pas de redemmarrage
				exit 3
			else
				#retourne 2 pour dire que la mise à jour c'est bien passe mais qu' il faut un redemmarrage
				exit 2
			fi
		else
			#pas de mise a jour trouve
			echo "Application is already up to date." >> $PATH_LOG
			exit 4
		fi

	fi #if [[  $RetMd5Rootfs -eq "0" || $RetMd5zImage -eq "0" ]]; then
	
	
else

	
	###################################
	#    Cas mise a jour production   #
	###################################


	# etape 1 pro #
	
	#le dossier opt n'est pas present c'est donc une mise a jour production
	#le repertoir opt n'existe donc nous sommes dans un cas de premier demarrage
	echo "This is the first Camera Starting"  >> $PATH_LOG

	#verifier la coherence du zImage de la carte et celui qui est present dans le update
	#chercher le nom actuel du zimage
	echo "Search $NAME_FILE_ZIMAGE filename in ${PATH_BOOT}" >> $PATH_LOG
	filename=$( ls ${PATH_BOOT} | grep $NAME_FILE_ZIMAGE )
	#calcul du md5 du zImage actuel
	echo "Calculating $filename MD5Checksum" >> $PATH_LOG
	Md5zImage=$( md5sum ${PATH_BOOT}$filename )

	echo "Read $NAME_FILE_ZIMAGE MD5Checksum in file ${UPDATE_PATH}$NAME_FILE_MD5_NEW" >> $PATH_LOG
	Md5zImageNew=$( cat ${UPDATE_PATH}$NAME_FILE_MD5_NEW | grep $NAME_FILE_ZIMAGE)

	Md5zImage=$( echo $Md5zImage | awk '{print $1}')
	Md5zImageNew=$( echo $Md5zImageNew | awk '{print $1}')

	if [[ $Md5zImage == $Md5zImageNew ]]; then
		#les noyaux sont identiques donc mise à jour classique production
		echo "$Md5zImage and $Md5zImageNew MD5Checksum are equal" >> $PATH_LOG

		# etape 2 pro #
		
		###############
		# application #
      ###############

		echo " "
		echo "- Does $NAME_FILE_APP need update?" >> $PATH_LOG
		#le path de destination est le rootfs actuel
		UpdateAppli ${UPDATE_PATH}$NAME_FILE_APP "/" $PATH_LOG
		ret=$?
		#les valeurs de retour negatives sont superieures a 100
		if [[ $ret -gt "100" ]]; then
			echo " => Error in $NAME_FILE_APP update, returns:$ret" >> $PATH_LOG
			UmoutPart $PATH_BOOT $PATH_LOG
			exit -12
		else
			echo "$NAME_FILE_APP update is successfull" >> $PATH_LOG
		fi
		

		###############
		# language #
      ###############

		echo " "
		echo "Does $NAME_FILE_TRANSLATION need update?" >> $PATH_LOG

	    #gestion de l'hebreux
        hebrew=$(ls ${PATH_OPT}translations | grep "he_IL.txt")
        
		#le path de destination est le rootfs actuel
		UpdateLanguage ${UPDATE_PATH}$NAME_FILE_TRANSLATION "/" $PATH_LOG
		ret=$?
		#les valeurs de retour negatives sont superieures a 100
		if [[ $ret -gt "100" ]]; then
			echo " => Error in $NAME_FILE_TRANSLATION update, returns:$ret" >> $PATH_LOG
			UmoutPart $PATH_BOOT $PATH_LOG
			exit -13
		else
		    #l'hebrew doit il etre reinstalle?
            if [[ $hebrew == "he_IL.txt" ]]; then
                mv ${PATH_OPT}translations/he_IL.t__ ${PATH_OPT}translations/he_IL.txt
                echo " Hebrew language is found in old directory and reinstalled." >> $PATH_LOG
            fi	

			echo "$NAME_FILE_TRANSLATION update successfull" >> $PATH_LOG
		fi




		###############
		# bluetooth   #
      ###############

		echo " "
		echo "- Does $NAME_FILE_BLUETOOTH need update?" >> $PATH_LOG

		#le path de destination est le rootfs actuel
		UpdateBluetooth ${UPDATE_PATH}$NAME_FILE_BLUETOOTH "/" $PATH_LOG
		ret=$?
		#les valeurs de retour negatives sont superieures a 100
		if [[ $ret -gt "100" ]]; then
			echo " => Error in $NAME_FILE_BLUETOOTH update, returns:$ret"  >> $PATH_LOG
			UmoutPart $PATH_BOOT $PATH_LOG
			exit -14
		else
			echo "$NAME_FILE_BLUETOOTH update successfull"  >> $PATH_LOG
		fi


		######################
		# MD5FileInstalled   #
      ######################
		echo " "
		echo "- Update $NAME_FILE_MD5 file" >> $PATH_LOG
		UpdateMD5File ${UPDATE_PATH}$NAME_FILE_MD5_NEW "/" $NAME_FILE_MD5 $PATH_LOG
		#recuperer la sortie de la fonction UpdateMD5File
		ret=$?
		if [[ $ret -ne "0" ]]; then
			echo " => Error in UpdateMD5File update, returns:$ret" >> $PATH_LOG
			UmoutPart $PATH_BOOT $PATH_LOG
			exit -15
		fi #fin if [[ $ret -ne "0" ]];

      #modification des droits du repertoire /opt
      find $PATH_OPT -exec chown root:root {} \;
      find $PATH_OPT -exec chmod a+rwx {} \;

		UmoutPart $PATH_BOOT $PATH_LOG
		#retourne 0 pour dire que la mise à jour c'est bien passee et que le redemarrage n'est pas necessaire et qu'il ne faut pas effacer le dossier update de la sdcard
		exit 0

	else

		# etape 3 pro #
		#cas mise a jour totale production

		echo "Warning $Md5zImage and $Md5zImageNew MD5Checksum are not equal" >> $PATH_LOG
		echo "Update all is necessary" >> $PATH_LOG

		#mise a jour du u-boot si le fichier est present dans l'archive
		echo " "
		echo "- Does $NAME_FILE_U_BOOT file need update?" >> $PATH_LOG
		TEMP = $(UpdateUBoot $NAME_FILE_U_BOOT ${UPDATE_PATH}$NAME_FILE_U_BOOT ${UPDATE_PATH}$NAME_FILE_MD5_NEW ${PATH_OPT_UPDATE}$NAME_FILE_MD5 $PATH_LOG)
      if [[ $TEMP -eq 1 ]]; then
         # une maj est faite, il faut redemarrer la camera
         UpdateDone=1
         NeedReboot=1
      fi
      
      #mise a jour du reste
		UpdateAll $UPDATE_PATH $PATH_LOG
		retUpdatAll=$?
		echo "UpdateAll function returns:$retUpdatAll" >> $PATH_LOG 
		if [[ $retUpdatAll -ne "0" ]]; then
			echo " => Error in UpdateAll function, returns:$retUpdatAll" >> $PATH_LOG
			UmoutPart $PATH_BOOT $PATH_LOG
			exit -16
		else
			echo "Update all successfull" >> $PATH_LOG
			UmoutPart $PATH_BOOT $PATH_LOG

			#retourne 1 pour dire que la mise à jour c'est bien passee mais qu' il faut un redemarrage et qu'il ne faut pas effacer le dossier update
 			exit 1
		fi
	fi #fin if[[ $Md5zImage ==  $Md5zImageNew ]]

fi




